/***** -*- mode: C; encodeing: utf-8 -*- **************************************
 * $Id$
 *
 * Copyright (C) 2016 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : rapi driver
 *	 PROGRAM NAME	 : rapi.ko
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : WAKABAYASHI, Ayumu
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 WAKABAYASHI, Ayumu - Nov 2016: Created.
 *	 $Log$
 ******************************************************/


#ifndef	__MACHINE_RAPIVAR_H__
#define	__MACHINE_RAPIVAR_H__
#include "rapidev.h"
#include "rapi_com.h"
#define	RAPI_PCI_IOBA	0x10
#define	RAPI_PRI		(PZERO + 1)
#define	RAPI_UNIT(d)	MINOR(d)
#define	CSF_OPENED		0x01U
#define	CSF_WANTREAD	0x04U
#define	CSF_WANTWRITE	0x10U
#define	CSF_SELREAD		0x08U
#define	CSF_SELWRITE	0x02U
#define	CSF_ERR_DOWN	0x01U
#define	CSF_ERR_WAKEUP	0x02U
#define	CSF_ERR_TIMEOUT	0x04U
#define	CSF_ERR_INTERR	0x08U
#define	CSF_ERR_BADFORM	0x10U
#define	CSF_ERR_SUM		0x20U
#define	CSF_ERR_RETRY	0x40U
#define	CSF_ERR_ERROR	0x80U
#define CSF_ENGRDY      0x01U
#define	PREV_INT_NO_FIXED	0xffff
struct rapi_softc {
	rapi_driver_header_t sc_header;
	rapi_share_param_t *sc_share;
	struct pci_dev *pci_dev;
	u_short sc_flags;
	 irqreturn_t(*rapi_intr) (void *);
	unsigned long io_vaddr;
	unsigned long io_addr;
	unsigned long io_len;
	unsigned long mem_vaddr;
	unsigned long mem_addr;
	unsigned long mem_len;
	unsigned int irqno;
	unsigned int irq_eng_ready;
	COMMHANDLE sc_comm;
	atomic_t sc_nrcv;
	u_char sc_err;
	u_char sc_err2;
	u_char sc_al_opened;
	u_short sc_prevtxint;
	u_short sc_prevrxint;
	u_char int_type;
	struct mutex sc_mutex;
	atomic_t sc_mutex_count;
	struct mutex engine_mutex;
	u_char engine_down;
	atomic_t engine_mutex_count;
	volatile char mem_guard[4];
};
typedef struct rapi_softc rapi_t;
int rapi_intr_asic(rapi_t *);
void rapi_intr_asic_delay(rapi_t *);
int rapi_intr_ipu(rapi_t *);
void rapi_intr_ipu_delay(rapi_t *);
void rapi_attention(int, u_short);
void rapi_enginectrl(int, u_short);
u_short rapi_enginesense(int);
void rapi_setegint(int, u_short);
int rapi_intr_pci_PCIE(void *);
u_short rapi_readpacket_PCIE(int, u_char *, u_short *);
u_short rapi_writepacket_PCIE(int, u_char *, u_short);
void rapi_settxint_PCIE(int, u_short);
void rapi_setrxint_PCIE(int, u_short);
int rapi_rxintcheck_PCIE(int);
#define	PCI_REG_WRITE_DELAY()	DELAY(2)
#define	PCI_REG_READ_DELAY()	DELAY(2)
#define PCI_INTR_DIASERT_WAIT()   DELAY(1)
extern struct cfattach rapi_ca;
extern struct cfdriver rapi_cd;
#endif
