/***** -*- mode: C; encodeing: utf-8 -*- **************************************
 * $Id$
 *
 * Copyright (C) 2016 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : rapi driver
 *	 PROGRAM NAME	 : rapi.ko
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : WAKABAYASHI, Ayumu
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 WAKABAYASHI, Ayumu - Nov 2016: Created.
 *	 $Log$
 ******************************************************/


#ifndef _RAPI_MOD_H_
#define _RAPI_MOD_H_
#include <stddef.h>
#include <linux/ctype.h>
#include <linux/kernel.h>
#define FORCE_DPRINTK(fmt, ...) { printk( fmt,  ##__VA_ARGS__ ); }
#define RAPI_MOD_DEBUG
#ifdef RAPI_MOD_DEBUG
#define FUNC_START	  {}
#define FUNC_END	  {}
#define PRINT_INFO(fmt, args...)	FORCE_DPRINTK(KERN_INFO"[%s]L%d:" fmt, __FUNCTION__, __LINE__, ## args)
#define PRINT_ISR_INFO(fmt, args...)	{}
#define PRINT_ERR(fmt, args...)		FORCE_DPRINTK(KERN_ERR"[%s]L%d:" fmt, __FUNCTION__, __LINE__, ## args)
#endif
#define	PCI_VENDOR_RICOH		0x1180
#define	PCI_PRODUCT_RICOH_RAPI	0x5015
#define  RAPI_DRIVER_NAME "rapi0"
#define  RAPI_MOD_DEVICE_NAME "rapi0"
typedef int (*rapi_intr_establish_t) (irqreturn_t(*)(void *));
typedef struct {
	unsigned irqno;
	rapi_intr_establish_t rapi_intr_establish;
	unsigned long io_vaddr;
	unsigned long io_len;
	unsigned long mem_vaddr;
	unsigned long mem_len;
	unsigned long io_addr;
	unsigned long mem_addr;
	struct pci_dev *pci_dev;
} rapi_share_param_t;
typedef struct {
	dev_t sc_dev;
	struct cdev sc_cdev;
	struct class *sc_class;
	const char *sc_name;
} rapi_driver_header_t;
typedef int (*attach_func_t) (void *);
typedef int (*detach_func_t) (void *);
typedef int (*softcsize_func_t) (void);
struct devlist {
	void *softc;
	size_t softc_size;
	struct file_operations *ops;
	const char *name;
	attach_func_t attachfunc;
	detach_func_t detachfunc;
	softcsize_func_t softcsizefunc;
};
rapi_share_param_t *get_rapi_share_param(void);
extern struct devlist rapi_devlist[1];
#define	RETRY_MAX	3
#define NRAPI 1
#define GPIO_ENG_READY (32+21)
#define GPIO_ENG_PWCTL (32+11)
#define GPIO_FUKKI (32+13)
#define RAPI_WQUEUE_NAME "RAPI_WQUEUE"
typedef struct workqueue_struct workqueue_struct_t;
typedef struct work_struct work_struct_t;
typedef struct rapi_work {
	work_struct_t nfc_work;
} rapi_work_t;
#endif
