/***** -*- mode: C; encodeing: utf-8 -*- **************************************
 * $Id$
 *
 * Copyright (C) 2016 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : rapi driver
 *	 PROGRAM NAME	 : rapi.ko
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : WAKABAYASHI, Ayumu
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 WAKABAYASHI, Ayumu - Nov 2016: Created.
 *	 $Log$
 ******************************************************/


#ifndef	__RAPI_COM_H__
#define	__RAPI_COM_H__
#include <linux/types.h>
#define	STX	 0xf0
#define	STXS 0xf1
#define	ETX	 0xf4
#define	DLE	 0xf5
#define	ACK	0xf2
#define	NAK	0xf3
#define	PK1	0xf6
#define	PK2	0xf7
#define	DPK	0xf8
#define	RAPI_PKT_SIZE	32
#define	RAPICMDQTXLEN	(RAPIFRAMEMAX * 64)
#define	RAPICMDQRXLEN	(RAPIFRAMEMAX * 128)
#define	COMM_TIMEOUT	1000
typedef struct {
	int _Unit;
	void (*_Attention) (int, u_short);
	 u_short(*_ReadPkt) (int, u_char *, u_short *);
	 u_short(*_WritePkt) (int, u_char *, u_short);
	void (*_SetTxInt) (int, u_short);
	void (*_SetRxInt) (int, u_short);
	void (*_SetEgInt) (int, u_short);
	 u_short(*_Sense) (int);
	u_short _RxBuffSize;
	u_char *_RxBuff;
	u_short _RxReadPtr;
	u_short _RxWritePtr;
	u_short _RxWritePtrSave;
	u_short _TxBuffSize;
	u_char *_TxBuff;
	u_short _TxReadPtr;
	u_short _TxWritePtr;
	u_short _TxReadPtrTmp;
	u_char _RxStatus;
	u_char _TxStatus;
	u_char _RetryCount;
	u_char _TxRequest;
	u_char _EngStatus;
	u_char _DrvStatus;
	u_char _TxOddPacket;
	u_char _RxOddPacket;
	u_char _GoodPacket;
	u_char _RetrySize;
	u_char _CommMode;
	u_long *_CallOut;
	int _EtxCount;
} RAPICOMM;
typedef RAPICOMM *COMMHANDLE;
#define	TXSTAT_WAISND	0
#define	TXSTAT_WAIRES	1
#define	RXSTAT_WAISTX	0
#define	RXSTAT_WAIETX	1
#define	DATA_REQ	0x00U
#define	ACK_REQ		0x01U
#define	NAK_REQ		0x02U
#define	TX_FULL		(-1)
#define	RX_FULL		(-1)
#define	RX_INTERR	(-2)
#define	RAPI_PKT	1
#define	RAPI_ENG_DOWN	2
#define	PWR_ON		0x02
#define	IPU_READY	0x10000
#define	RAPI_COMM_PKN	0
#define	RAPI_COMM_DPK	1
#define	ETX_CNT_NOUSE	-1
#define	ETX_CNT_INIT	0
COMMHANDLE RapiCommOpen(int unit,
			u_short Rx,
			u_short Tx,
			void (*Atten) (int, u_short),
			u_short(*Read) (int, u_char *, u_short *),
			u_short(*Write) (int, u_char *, u_short),
			u_short(*Sen) (int),
			void (*TxInt) (int, u_short),
			void (*RxInt) (int, u_short),
			void (*EgInt) (int, u_short));
void RapiCommStop(COMMHANDLE);
void RapiCommStart(COMMHANDLE);
short RapiCommWrite(COMMHANDLE, u_char *, u_short);
short RapiCommRead(COMMHANDLE, u_char *);
void RapiCommRxInt(COMMHANDLE);
void RapiCommTxInt(COMMHANDLE);
void RapiEngStatInt(COMMHANDLE);
u_char RapiTxEmpty(COMMHANDLE);
u_short RapiRxRemain(COMMHANDLE);
void RapiCommModeSet(COMMHANDLE, u_char);
void RapiCommReset(COMMHANDLE);
#endif
