/***** -*- mode: C; encodeing: utf-8 -*- **************************************
 * $Id$
 *
 * Copyright (C) 2016 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : rapi driver
 *	 PROGRAM NAME	 : rapi.ko
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : WAKABAYASHI, Ayumu
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 WAKABAYASHI, Ayumu - Nov 2016: Created.
 *	 $Log$
 ******************************************************/


#include <linux/init.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/cdev.h>
#include <linux/irqreturn.h>
#include <linux/interrupt.h>
#include <linux/io.h>
#include <linux/uaccess.h>
#include <linux/types.h>
#include <linux/clk.h>
#include <linux/clk-provider.h>
#include <linux/delay.h>
#include <linux/device.h>
#include <linux/platform_device.h>
#include <linux/kernel.h>
#include <linux/input.h>
#include <linux/gpio.h>
#include <linux/errno.h>
#include <linux/timer.h>
#include <linux/syscalls.h>
#include <linux/slab.h>
#include <linux/workqueue.h>
#include <linux/kthread.h>
#include "rapidev.h"
#include "rapi_com.h"
#include "rapivar.h"
#include "rapi.h"
#define	Unit		(ptComm->_Unit)
#define	Attention	(ptComm->_Attention)
#define	ReadPkt		(ptComm->_ReadPkt)
#define	WritePkt	(ptComm->_WritePkt)
#define	SetTxInt	(ptComm->_SetTxInt)
#define	SetRxInt	(ptComm->_SetRxInt)
#define	SetEgInt	(ptComm->_SetEgInt)
#define	Sense		(ptComm->_Sense)
#define	RxBuff		(ptComm->_RxBuff)
#define	RxBuffSize	(ptComm->_RxBuffSize)
#define	RxReadPtr	(ptComm->_RxReadPtr)
#define	RxWritePtr	(ptComm->_RxWritePtr)
#define	RxWritePtrSave	(ptComm->_RxWritePtrSave)
#define	TxBuff		(ptComm->_TxBuff)
#define	TxBuffSize	(ptComm->_TxBuffSize)
#define	TxReadPtr	(ptComm->_TxReadPtr)
#define	TxWritePtr	(ptComm->_TxWritePtr)
#define	TxReadPtrTmp	(ptComm->_TxReadPtrTmp)
#define	RxStatus	(ptComm->_RxStatus)
#define	TxStatus	(ptComm->_TxStatus)
#define	RetryCount	(ptComm->_RetryCount)
#define	TxRequest	(ptComm->_TxRequest)
#define	TxOddPacket	(ptComm->_TxOddPacket)
#define	RxOddPacket	(ptComm->_RxOddPacket)
#define	EngStatus	(ptComm->_EngStatus)
#define	DrvStatus	(ptComm->_DrvStatus)
#define	GoodPacket	(ptComm->_GoodPacket)
#define	RetrySize	(ptComm->_RetrySize)
#define	CommMode	(ptComm->_CommMode)
#define	CallOut		(ptComm->_CallOut)
#define	EtxCount	(ptComm->_EtxCount)
#define	BTST(i, b)	((i) &   (1 << (b)))
#define	BSET(i, b)	((i) |=  (1 << (b)))
#define	BCLR(i, b)	((i) &= ~(1 << (b)))
#define TX_TIMEOUT      (HZ/5)
static char ack_packet[4] = { ACK, ACK, ACK, ACK };
static char nak_packet[4] = { NAK, NAK, NAK, NAK };
extern int rdycount;
extern int rdysyncmode;
extern COMMHANDLE rapicom[2];
extern rapi_t g_rapi_softc;
extern struct timer_list check_txtimeout_timer;
u_char rxData[32];
int rx_data_available = 0;
#ifdef RAPI_RETRY_TEST
extern u_int retry_txsumcnt;
extern u_int retry_txackcnt;
extern u_int retry_rxsumcnt;
extern u_int retry_rxackcnt;
#endif
extern void dump_packet(u_char * buf, int size);
extern void dump_registers(int log_level);
static void RapiCommTxInt_Pkn(COMMHANDLE);
static void RapiCommTxInt_DPK(COMMHANDLE);
static int Receive(COMMHANDLE, u_short);
static int PacketSumCheck(u_char * data, int size);
static void RapiTxTimeout(unsigned long data);
static void RapiEngReady(COMMHANDLE);
static void RapiEngDown(COMMHANDLE);
COMMHANDLE RapiCommOpen(int unit,
			u_short Rx,
			u_short Tx,
			void (*Atten) (int, u_short),
			u_short(*Read) (int, u_char *, u_short *),
			u_short(*Write) (int, u_char *, u_short),
			u_short(*Sen) (int),
			void (*TxInt) (int, u_short),
			void (*RxInt) (int, u_short),
			void (*EgInt) (int, u_short))
{
	RAPICOMM *ptComm;
	FUNC_START;
	ptComm = (RAPICOMM *) kmalloc(sizeof(RAPICOMM), GFP_KERNEL);
	if (ptComm == NULL) {
		PRINT_ERR("cannot allocate RAPICOMM struct\n");
		return ((COMMHANDLE) NULL);
	}
	Unit = unit;
	Attention = Atten;
	ReadPkt = Read;
	WritePkt = Write;
	Sense = Sen;
	SetTxInt = TxInt;
	SetRxInt = RxInt;
	SetEgInt = EgInt;
	RxBuffSize = Rx;
	RxBuff = (u_char *) kmalloc(RxBuffSize, GFP_KERNEL);
	if (RxBuff == NULL) {
		PRINT_ERR("cannot allocate RxBuff\n");
		return ((COMMHANDLE) NULL);
	}
	RxReadPtr = 0;
	RxWritePtr = 0;
	TxBuffSize = Tx;
	TxBuff = (u_char *) kmalloc(TxBuffSize, GFP_KERNEL);
	if (TxBuff == NULL) {
		return ((COMMHANDLE) NULL);
	}
	TxReadPtr = 0;
	TxWritePtr = 0;
	RxStatus = RXSTAT_WAISTX;
	TxStatus = TXSTAT_WAISND;
	TxRequest = 0;
	RetryCount = 0;
	DrvStatus = 0;
	EngStatus = Sense(Unit);
	rapicom[unit] = ptComm;
	if ((EngStatus & ENG_READY)) {
		RapiEngReady(ptComm);
	}
	TxOddPacket = 1;
	RxOddPacket = 1;
	RetrySize = 0;
	CommMode = RAPI_COMM_PKN;
	SetEgInt(Unit, 1);
	SetRxInt(Unit, 1);
	SetTxInt(Unit, 0);
	FUNC_END;
	return (ptComm);
}
void RapiCommStart(COMMHANDLE channel)
{
	RAPICOMM *ptComm = channel;
	FUNC_START;
	RxReadPtr = RxWritePtr;
	TxReadPtr = TxWritePtr;
	RetrySize = 0;
	RxStatus = RXSTAT_WAISTX;
	DrvStatus = 1;
	if (EngStatus & ENG_READY) {
		SetRxInt(Unit, 1);
		SetEgInt(Unit, 1);
		SetTxInt(Unit, 0);
	}
	FUNC_END;
}
void RapiCommReset(COMMHANDLE channel)
{
        RAPICOMM *ptComm = channel;
	FUNC_START;
	RxReadPtr = RxWritePtr;
	TxReadPtr = TxWritePtr;
	RetrySize = 0;
	RxStatus = RXSTAT_WAISTX;
	DrvStatus = 1;
	FUNC_END;
}
#define	ChkTxBufFull() 						\
	do { 							\
		if (p >= TxBuffSize) p -= TxBuffSize;		\
		if (p == q) {					\
			SetEgInt(Unit, 1);			\
			return (TX_FULL);			\
		}						\
	} while (0)
short RapiCommWrite(COMMHANDLE channel, u_char * buff, u_short length)
{
	RAPICOMM *ptComm = channel;
	u_short p, q;
	u_char c, r;
	short i;
	FUNC_START;
	r = 1;
	if (rdysyncmode != 0) {
		if (rdycount != NRAPI)
			r = 0;
	}
	p = TxWritePtr;
	q = TxReadPtr;
	TxBuff[p++] = STX;
	ChkTxBufFull();
	for (i = 0; i < length; i++) {
		c = buff[i];
		if (c >= 0xf0) {
			c ^= 0x80;
			TxBuff[p++] = DLE;
			ChkTxBufFull();
		}
		TxBuff[p++] = c;
		ChkTxBufFull();
	}
	TxBuff[p++] = ETX;
	ChkTxBufFull();
	TxWritePtr = p;
	if (TxStatus == TXSTAT_WAISND) {
		BSET(TxRequest, DATA_REQ);
	}
	if ((EngStatus & ENG_READY) && r) {
		SetTxInt(Unit, TxRequest);
	}
	FUNC_END;
	return (0);
}
#undef	ChkTxBufFull
short RapiCommRead(COMMHANDLE channel, u_char * buff)
{
	RAPICOMM *ptComm = channel;
	u_short p, q;
	u_char c;
	short i;
	FUNC_START;
	p = RxReadPtr;
	q = RxWritePtr;
	for (i = 0;; i++) {
		if (p == q) {
			i = RX_INTERR;
			break;
		}
		c = RxBuff[p++];
		if (p >= RxBuffSize)
			p -= RxBuffSize;
		if (c == ETX)
			break;
		if (c == DLE) {
			if (p == q) {
				i = RX_INTERR;
				break;
			}
			c = (RxBuff[p++]) ^ 0x80;
			if (p >= RxBuffSize)
				p -= RxBuffSize;
		}
		if (i < RAPIFRAMEMAX) {
			buff[i] = c;
		}
	}
	if (i < 0) {
		PRINT_INFO("%s: error return value=[%d]\n", __FUNCTION__, i);
		i = 0;
		return (i);
	}
	RxReadPtr = p;
	if (i >= RAPIFRAMEMAX) {
		i = RX_FULL;
	}
#if 0
	rx_data_available = 0;
	SetRxInt(Unit, 1);
	if (0 == rx_data_available) {
		wait_event_interruptible(&rx_wq, rx_data_available != 0);
	}
	i = rx_data_available;
	memcpy(buff, rxData, rx_data_available);
	PRINT_INFO("%s: rx data length=[%d]\n", __FUNCTION__, i);
#endif
	FUNC_END;
	return (i);
}
void RapiCommRxInt(COMMHANDLE channel)
{
	RAPICOMM *ptComm = channel;
	u_short c;
	u_short i;
	u_short RxWritePtrTmp;
	u_short dsize;
	u_char rdata[RAPI_PKT_SIZE];
	PRINT_ISR_INFO("ENG_READY=[%s]\n",
		       (EngStatus & ENG_READY) ? "true" : "false");
	if (EngStatus & ENG_READY) {
		SetEgInt(Unit, 0);
		c = ReadPkt(Unit, rdata, &dsize);
		if (DrvStatus == 0) {
			SetEgInt(Unit, 1);
			PRINT_ISR_INFO("DrvStatus == 0\n");
			return;
		}
		if (dsize == 0 || c != RAPI_PKT) {
			SetEgInt(Unit, 1);
			PRINT_ISR_INFO("dsize==0 || c!=RAPI_PKT\n");
			return;
		}
		PRINT_ISR_INFO("rdata[0]=0x%02x\n", rdata[0]);
		switch (rdata[0]) {
		case DPK:
			for (i = 1; i < dsize; i++) {
				if (rdata[i] == ACK || rdata[i] == NAK) {
					SetEgInt(Unit, 1);
					PRINT_ISR_INFO
					    ("rdata[%d] == ACK or NAK\n", i);
					return;
				}
			}
			if (PacketSumCheck(rdata, dsize)) {
				EtxCount = ETX_CNT_NOUSE;
				for (i = 2; i < dsize; i++) {
					Receive(channel, rdata[i]);
				}
			} else {
			}
			break;
		case PK1:
		case PK2:
			for (i = 1; i < dsize; i++) {
				if (rdata[i] == ACK || rdata[i] == NAK) {
					SetEgInt(Unit, 1);
					PRINT_ISR_INFO
					    ("rdata[%d] == ACK or NAK\n", i);
					return;
				}
			}
			GoodPacket = (rdata[0] == PK1) ?
			    RxOddPacket : 1 - RxOddPacket;
			if (PacketSumCheck(rdata, dsize)) {
				if (GoodPacket) {
					RxWritePtrTmp = RxWritePtr;
					EtxCount = ETX_CNT_INIT;
					for (i = 2; i < dsize; i++) {
						if (!Receive(channel, rdata[i])) {
							break;
						}
					}
					if (i == dsize) {
						for (i = 0; i < EtxCount; i++) {
							Attention(Unit,
								  RAPI_FRAME);
						}
#ifdef RAPI_RETRY_TEST
						if (retry_rxackcnt > 0) {
							retry_rxackcnt--;
							PRINT_INFO
							    ("RETRY(RX ACK ERR)\n");
							break;
						}
#endif
						RxOddPacket ^= 1;
						BSET(TxRequest, ACK_REQ);
					} else {
						RxWritePtr = RxWritePtrTmp;
						BSET(TxRequest, NAK_REQ);
					}
				} else {
#ifdef RAPI_RETRY_TEST
					if (retry_rxackcnt > 0) {
						retry_rxackcnt--;
						PRINT_INFO
						    ("RETRY(RX ACK ERR2)\n");
						break;
					}
#endif
					PRINT_ISR_INFO
					    ("***** BAD PACKET, even/odd is miss *****\n");
					BSET(TxRequest, ACK_REQ);
				}
			} else {
				PRINT_INFO
				    ("***** BAD PACKET, packet checksum error, send NACK *****\n");
				BSET(TxRequest, NAK_REQ);
			}
			SetTxInt(Unit, TxRequest);
			memcpy(rxData, rdata, 32);
			rx_data_available = dsize;
			break;
		case ACK:
#ifdef RAPI_RETRY_TEST
			if (retry_txackcnt > 0) {
				retry_txackcnt--;
				PRINT_INFO("RETRY(TX ACK ERR)\n");
				break;
			}
#endif
			if (dsize == 4 && rdata[1] == ACK && rdata[2] == ACK && rdata[3] == ACK) {
				if (TxStatus == TXSTAT_WAIRES) {
					del_timer(&check_txtimeout_timer);
					TxStatus = TXSTAT_WAISND;
					RetryCount = 0;
					RetrySize = 0;
					TxReadPtr = TxReadPtrTmp;
					TxOddPacket ^= 1;
					if (TxReadPtr != TxWritePtr) {
						BSET(TxRequest, DATA_REQ);
						SetTxInt(Unit, TxRequest);
					}
				}
			}
			break;
		case NAK:
			if (dsize == 4 && rdata[1] == NAK && rdata[2] == NAK && rdata[3] == NAK) {
				if (TxStatus == TXSTAT_WAIRES) {
					del_timer(&check_txtimeout_timer);
					TxStatus = TXSTAT_WAISND;
					RetryCount = 0;
					BSET(TxRequest, DATA_REQ);
					SetTxInt(Unit, TxRequest);
				}
				dump_packet(rxData, dsize);
			}
			break;
		default:
			break;
		}
		SetEgInt(Unit, 1);
	}
}
static int PacketSumCheck(u_char * data, int size)
{
	int i;
	unsigned short sum = 0;
	struct timeval cur;
	static char strbuff[(3*256)+1] = { 0x00 };
#ifdef RAPI_RETRY_TEST
	if (retry_rxsumcnt > 0) {
		retry_rxsumcnt--;
		PRINT_INFO("RETRY(RX CHECKSUM ERR)\n");
		return (0);
	}
#endif
	if (size < 3) {
		return (0);
	}
	for (i = 2; i < size; i++) {
		sum += data[i];
	}
	if ((sum % 0xf0) == data[1]) {
		return (1);
	} else {
		FUNC_START;
		PRINT_ERR("SumCheck:NG(%02x != %02x)\n", data[1], (sum % 0xf0));
		do_gettimeofday(&cur);
		printk("[%s][%ld.%06ld] ENG->CTL", __FUNCTION__, cur.tv_sec, cur.tv_usec);
		for (i=0; i < size; i++)
		{
			sprintf(&(strbuff[i*3]), " %02x", data[i]);
		}
		printk("[%s]%s\n", __FUNCTION__, strbuff);
		FUNC_END;
	}
	return (0);
}
static int Receive(COMMHANDLE channel, u_short c)
{
	RAPICOMM *ptComm = channel;
	u_short p;
	if (RxStatus == RXSTAT_WAIETX) {
		if (c == STX) {
			PRINT_INFO("Attention=[RAPI_BADFORM]\n");
			Attention(Unit, RAPI_BADFORM);
			RxWritePtr = RxWritePtrSave;
			goto Restart;
		}
		p = RxWritePtr;
		RxBuff[p++] = c;
		if (p >= RxBuffSize)
			p -= RxBuffSize;
		if (p == RxReadPtr) {
			return (0);
		}
		RxWritePtr = p;
		if (c == ETX) {
			RxStatus = RXSTAT_WAISTX;
			if (EtxCount == ETX_CNT_NOUSE) {
				Attention(Unit, RAPI_FRAME);
			} else {
				EtxCount++;
			}
		}
	} else if (RxStatus == RXSTAT_WAISTX) {
 Restart:
		if (c == STX) {
			RxWritePtrSave = RxWritePtr;
			RxStatus = RXSTAT_WAIETX;
		}
	} else {
		;
	}
	return (1);
}
void RapiCommTxInt(COMMHANDLE channel)
{
	RAPICOMM *ptComm = channel;
	u_short c;
	if (EngStatus & ENG_READY) {
		SetEgInt(Unit, 0);
		if (BTST(TxRequest, ACK_REQ)) {
			c = WritePkt(Unit, ack_packet, sizeof(ack_packet));
			BCLR(TxRequest, ACK_REQ);
			SetTxInt(Unit, TxRequest);
		} else if (BTST(TxRequest, NAK_REQ)) {
			c = WritePkt(Unit, nak_packet, sizeof(nak_packet));
			BCLR(TxRequest, NAK_REQ);
			SetTxInt(Unit, TxRequest);
		} else if (BTST(TxRequest, DATA_REQ)) {
			if (CommMode == RAPI_COMM_DPK) {
				RapiCommTxInt_DPK(channel);
			} else {
				RapiCommTxInt_Pkn(channel);
				SetTxInt(Unit, 0);
#if 0
				SetTxInt(Unit, 0);
				intrflg =
				    ioread32((void *)(sc->mem_vaddr + 0x74));
				PRINT_INFO("intrflag: %02x\n", intrflg);
				intrflg =
				    ioread32((void *)(sc->mem_vaddr + 0x74));
				PRINT_INFO("intrflag: %02x\n", intrflg);
#endif
			}
		} else {
			SetTxInt(Unit, TxRequest);
		}
		SetEgInt(Unit, 1);
	} else {
		PRINT_INFO("RapiCommTxInt: NOT ENGRDY:");
	}
}
static void RapiCommTxInt_DPK(COMMHANDLE channel)
{
	RAPICOMM *ptComm = channel;
	u_short p, q;
	u_char wdata[RAPI_PKT_SIZE];
	u_short c;
	u_short i;
	u_short sum = 0;
	FUNC_START;
	if (TxReadPtr == TxWritePtr) {
		BCLR(TxRequest, DATA_REQ);
		SetTxInt(Unit, TxRequest);
		PRINT_INFO("Attention=[RAPI_TXEMPTY]\n");
		Attention(Unit, RAPI_TXEMPTY);
	} else {
		p = TxReadPtr;
		q = TxWritePtr;
		wdata[0] = DPK;
		for (i = 2; i < RAPI_PKT_SIZE;) {
			if (p == q)
				break;
			sum += TxBuff[p];
			wdata[i++] = TxBuff[p++];
			if (p >= TxBuffSize)
				p -= TxBuffSize;
		}
		wdata[1] = (u_char) (sum % 0xF0);
		c = WritePkt(Unit, wdata, i);
		if (c == RAPI_ENG_DOWN) {
			SetTxInt(Unit, 0);
		} else {
			TxReadPtr = p;
		}
		if (p == q) {
			BCLR(TxRequest, DATA_REQ);
			SetTxInt(Unit, TxRequest);
		}
	}
	FUNC_END;
}
static void RapiCommTxInt_Pkn(COMMHANDLE channel)
{
	RAPICOMM *ptComm = channel;
	u_short p, q;
	u_char wdata[RAPI_PKT_SIZE];
	u_short i;
	u_short c;
	u_short sum = 0;
	FUNC_START;
	if (TxStatus == TXSTAT_WAISND) {
		TxReadPtrTmp = TxReadPtr;
		p = TxReadPtrTmp;
		q = TxWritePtr;
		wdata[0] = TxOddPacket ? PK1 : PK2;
		if (RetrySize == 0) {
			for (i = 2; i < RAPI_PKT_SIZE;) {
				if (p == q)
					break;
				sum += TxBuff[p];
				wdata[i++] = TxBuff[p++];
				if (p >= TxBuffSize)
					p -= TxBuffSize;
			}
		} else {
			for (i = 2; i < 2 + RetrySize;) {
				if (p == q)
					break;
				sum += TxBuff[p];
				wdata[i++] = TxBuff[p++];
				if (p >= TxBuffSize)
					p -= TxBuffSize;
			}
		}
		wdata[1] = (u_char) (sum % 0xF0);
#ifdef RAPI_RETRY_TEST
		if (retry_txsumcnt > 0) {
			retry_txsumcnt--;
			PRINT_INFO("RETRY(TX CHECKSUM ERR)\n");
			wdata[1] += 1;
		}
#endif
		RetrySize = i - 2;
		c = WritePkt(Unit, wdata, i);
		if (c == RAPI_ENG_DOWN) {
			SetTxInt(Unit, 0);
		} else {
			TxReadPtrTmp = p;
		}
		TxStatus = TXSTAT_WAIRES;
		BCLR(TxRequest, DATA_REQ);
#if 0
		SetTxInt(Unit, TxRequest);
#endif
		init_timer(&check_txtimeout_timer);
		check_txtimeout_timer.expires = jiffies + TX_TIMEOUT;
		check_txtimeout_timer.data = (unsigned long)ptComm;
		check_txtimeout_timer.function = RapiTxTimeout;
		add_timer(&check_txtimeout_timer);
	} else {
		BCLR(TxRequest, DATA_REQ);
#if 0
		SetTxInt(Unit, TxRequest);
#endif
	}
	FUNC_END;
}
void RapiTxTimeout(unsigned long data)
{
	RAPICOMM *ptComm = (RAPICOMM *) data;
	FUNC_START;
	PRINT_INFO("%s: TxStatus=[0x%02x]\n", __FUNCTION__, TxStatus);
	if (TxStatus == TXSTAT_WAIRES) {
		TxStatus = TXSTAT_WAISND;
		RetryCount++;
		if (RetryCount <= RETRY_MAX) {
			PRINT_INFO("Attention=[RAPI_RETRY]\n");
			Attention(Unit, RAPI_RETRY);
			BSET(TxRequest, DATA_REQ);
			SetTxInt(Unit, TxRequest);
		} else {
			PRINT_INFO("Attention=[RAPI_ERROR]\n");
			Attention(Unit, RAPI_ERROR);
			RetryCount = 0;
			RetrySize = 0;
			TxReadPtr = TxReadPtrTmp;
			if (TxReadPtr != TxWritePtr) {
				BSET(TxRequest, DATA_REQ);
				SetTxInt(Unit, TxRequest);
			}
		}
	}
	FUNC_END;
}
void RapiEngStatInt(COMMHANDLE channel)
{
	u_short stat;
	RAPICOMM *ptComm = channel;
	FUNC_START;
	stat = Sense(ptComm->_Unit);
	FORCE_DPRINTK(KERN_ERR "[%s]: Sense=[0x%02x], EngStatus=[0x%02x], unit=[%d] \n", __FUNCTION__, stat, EngStatus, Unit);
	if ((EngStatus & ENG_READY) && !(stat & ENG_READY)) {
		dump_registers(5);
		TxReadPtr = TxWritePtr;
		TxOddPacket = 1;
		TxStatus = TXSTAT_WAISND;
		TxRequest = 0;
		RetrySize = 0;
		RapiEngDown(channel);
	}
	if (!(EngStatus & ENG_READY) && (stat & ENG_READY)) {
		dump_registers(5);
		SetRxInt(Unit, 0);
		RxReadPtr = RxWritePtr;
		RxStatus = RXSTAT_WAISTX;
		RxOddPacket = 1;
		SetRxInt(Unit, 1);
		RapiEngReady(channel);
	}
	EngStatus = stat;
	FUNC_END;
}
static void RapiEngReady(COMMHANDLE channel)
{
	RAPICOMM *ptComm = channel;
	int i;
	FUNC_START;
	rdycount++;
	if (rdysyncmode != 0) {
		if (rdycount != NRAPI)
			return;
		for (i = 0; i < NRAPI; i++) {
			if (rapicom[i] == NULL) {
				PRINT_INFO("rapicom[%d] is null, continue...\n",
					   i);
				continue;
			}
			if (!RapiTxEmpty(rapicom[i])) {
				SetTxInt(rapicom[i]->_Unit,
					 rapicom[i]->_TxRequest);
			}
		}
	} else {
		if (!RapiTxEmpty(channel)) {
			SetTxInt(Unit, TxRequest);
		}
	}
	PRINT_INFO("RAPI-%d ENGINE WAKEUP!!\n", Unit);
	PRINT_INFO("Attention=[RAPI_WAKEUP]\n");
	Attention(Unit, RAPI_WAKEUP);
	FUNC_END;
}
static void RapiEngDown(COMMHANDLE channel)
{
	RAPICOMM *ptComm = channel;
	FUNC_START;
	rdycount--;
	if (rdysyncmode != 0) {
		if (rdycount != NRAPI - 1)
			return;
	}
	PRINT_INFO("RAPI-%d ENGINE DOWN!!\n", Unit);
	PRINT_INFO("Attention=[RAPI_TXEMPTY]\n");
	Attention(Unit, RAPI_TXEMPTY);
	PRINT_INFO("Attention=[RAPI_DOWN]\n");
	Attention(Unit, RAPI_DOWN);
	FUNC_END;
}
u_char RapiTxEmpty(COMMHANDLE channel)
{
	RAPICOMM *ptComm = channel;
	FUNC_START;
	if (TxReadPtr == TxWritePtr) {
		return (1);
	}
	FUNC_END;
	return (0);
}
void RapiCommModeSet(COMMHANDLE channel, u_char mode)
{
        RAPICOMM *ptComm;
	FUNC_START;
	FORCE_DPRINTK(KERN_ERR "[%s]channel=0x%p, mode=%d \n", __FUNCTION__, channel, mode);
	ptComm = channel;
	CommMode = mode;
	FUNC_END;
}
