#!/bin/ash
#
# ===========================================================================
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2015, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ================================================================================

#
# updates LP IDLE flags.
#
# requires .ko loaded.. 
# modprobe low_power_idle
#
# expect lp_flags.sh [show:set] [light:deep:softoff:hibernate] [value]
echo " "
echo " "
if [ "$1" = "show" ]; then
    if [ "$2" = "light" ]; then
      cat /sys/class/low_power_idle/sleep/light_sleep_flags
      exit 0
    fi
    if [ "$2" = "deep" ]; then
      cat /sys/class/low_power_idle/sleep/deep_sleep_flags
      exit 0
    fi
    if [ "$2" = "hibernate" ]; then
      cat /sys/class/low_power_idle/sleep/hibernate_sleep_flags
      exit 0
    fi
    if [ "$2" = "softoff" ]; then
      cat /sys/class/low_power_idle/sleep/softoff_sleep_flags
      exit 0
    fi
    if [ "$2" = "" ]; then
        echo "all flags are"
        ls /sys/class/low_power_idle/sleep/*
        exit 0
    fi
    echo "$2 "; cat /sys/class/low_power_idle/sleep/$2
else if [ "$1" = "set" ]; then
    if [ "$2" = "light" ]; then
      cat /sys/class/low_power_idle/sleep/light_sleep_flags
      echo "$3" > /sys/class/low_power_idle/sleep/light_sleep_flags
      exit 0
    fi
    if [ "$2" = "deep" ]; then
      cat /sys/class/low_power_idle/sleep/deep_sleep_flags
      echo "$3" > /sys/class/low_power_idle/sleep/deep_sleep_flags
      exit 0
    fi
    if [ "$2" = "hibernate" ]; then
      cat /sys/class/low_power_idle/sleep/hibernate_sleep_flags
      echo "$3" > /sys/class/low_power_idle/sleep/hibernate_sleep_flags
      exit 0
    fi
    if [ "$2" = "softoff" ]; then
      cat /sys/class/low_power_idle/sleep/softoff_sleep_flags
      echo "$3" > /sys/class/low_power_idle/sleep/softoff_sleep_flags
      exit 0
    fi
    cat /sys/class/low_power_idle/sleep/$2
    if [ "$3" = "" ]; then
        echo "no value was supplied!"
        exit 0
    fi
    echo "$3" > /sys/class/low_power_idle/sleep/$2
    exit 0
else
    echo "lp_flags.sh [show:set] [ap:lpp] [value]"
fi
fi

