/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
/**
 * \file low_power_idle.h
 *
 * \brief
 *
 **/

#ifndef INC_LPI_H
#define INC_LPI_H

#define LP_FLAGS_CORE0_PD          (1 << 0x00)     // only for LPP mode
#define LP_FLAGS_DDR_SR            (1 << 0x08)     // manually enter SR cmd to MC
#define LP_FLAGS_DDR_PLL_BP        (1 << 0x09)
#define LP_FLAGS_DDR_PLL_PD        (3 << 0x09)     // include bypass -- 50us extra latency
#define LP_FLAGS_DDR_AUTO_SR       (1 << 0x0B)     // tell MC how many CLK of idle to auto enter SR
#define LP_FLAGS_DDR_HALT_MC       (1 << 0x0E)     // halt MC, allows DDR to deep SR; pad PD, PLL by
#define LP_FLAGS_DDR_MC_PAD        (1 << 0x0f)     // allows MC PADS to be controls
#define LP_FLAGS_CORE_PLL_BP       (1 << 0x10)     // bypass core PLL
#define LP_FLAGS_CORE_PLL_PD       (3 << 0x10)     // includes bypass -- 50us extra latency (actually about 250us)
#define LP_FLAGS_LPP_CLK_DIV       (3 << 0x14)     // only for LPP mode, set LPP into new clk div
#define LP_FLAGS_AVS_CONTROL       (1 << 0x16)     // only for LPP mode, allow LPP to look for AVS actions
#define LP_FLAGS_SYS_CLK_GATE      (1 << 0x17)     // gate SYS PLL
#define LP_FLAGS_SYS_PLL_PD        (3 << 0x17)     // gate SYS PLL bypass and power pd-- 50us extra latency

#define LP_FLAGS_LPP_CLK_DIV_SET(x)   (x << 0x14)

/* LOW POWER IDLE MODES */
typedef enum
{
    e_lpp_level_wake = 0,     //
    e_lpp_level_light,        //
    e_lpp_level_deep,         //
    e_lpp_level_suspend,      //
    e_lpp_level_hibernate,    //
    e_lpp_level_softoff,      //
    e_lpp_level_rtos,         //
    e_lpp_level_levels,    //
} lpp_sleep_level_t;


#define FIXED_MODE_SSC_MODE_BP       0x00010000
#define CLK_EN                       0x00000002

#define CORE_FIXED_MODE_SSC_MODE_REG 0x00002018
#define CORE_PLL_EN_REG              ((mpmu_base) + CORE_FIXED_MODE_SSC_MODE_REG)

#define SYSPLL_ENABLE_REG            0x00007018
#define SYS_CLK_GATE_REG             ((mpmu_base) + SYSPLL_ENABLE_REG)

#define USER_COMMAND_0_SR_ENTER      0x1f000040
#define USER_COMMAND_0_SR_EXIT       0x1f000080
#define USER_COMMAND_0_REG           0x00000020
#define MC_SR_REG                    ((mc_base) + USER_COMMAND_0_REG)

#define CH0_MC_Control_4_Auto_SR     0x000002cc
#define MC_AUTO_SR_REG               ((mc_base) + CH0_MC_Control_4_Auto_SR)

#define MC_DRAM_STATUS_INIT_DONE00_MASK     0x001
#define MC_DRAM_STATUS_INIT_DONE01_MASK     0x010
#define MC_DRAM_STATUS_INIT_DONE02_MASK     0x100

#define DRAM_STATUS_REG              0x00000008
#define MC_DRAM_STATUS_REG           ((mc_base) + DRAM_STATUS_REG)

#define MC_PERF_COUNTER_0_REG        0x00000110
#define MC_PC0_REG                   ((mc_base) + MC_PERF_COUNTER_0_REG)

#define MC_PERF_COUNTER_1_REG        0x00000114
#define MC_PC1_REG                   ((mc_base) + MC_PERF_COUNTER_1_REG)

#define MC_PERF_COUNTER_2_REG        0x00000118
#define MC_PC2_REG                   ((mc_base) + MC_PERF_COUNTER_2_REG)

#define CIU_REG_8C                    0x0000008c
#define CIU_REG_90                    0x00000090
#define CIU_REG_94                    0x00000094
#define CIU_REG_98                    0x00000098
#define CIU_REG_9C                    0x0000009c
#define CIU_CPU_CSTATE_NOT_3          ((ciu_base) + CIU_REG_8C)  // set ONLY by LPP, asking to stay out of SUSPEND
#define CIU_CPU_CSTATE                ((ciu_base) + CIU_REG_90)  // AP LPI will write active CSTATE
#define CIU_CPU_TIMER                 ((ciu_base) + CIU_REG_94)  // AP LPI will write next timer event
#define CIU_CPU_CSTATE_B              ((ciu_base) + CIU_REG_98)  // AP LPI will write previous CSTATE
#define CIU_CPU_SLEPT_TIME            ((ciu_base) + CIU_REG_9C)  // AP LPI will write how long actual slept

//#define APCPUClkStatus_REG           0x00000570
//#define APMU_APCPUClkStatus_REG      ((apmu_base) + APCPUClkStatus_REG)

#define LPI_GPIO_PIN(BANK,ACK,PIN)   (ACK << 12 | BANK << 8 | PIN)

#define LPI_MODE_LPP_LIGHT_STR      "light"
#define LPI_MODE_LPP_DEEP_STR       "deep"
#define LPI_MODE_LPP_DEEP25_STR     "deep25"
#define LPI_MODE_LPP_DEEP_SX        "S1"
#define LPI_MODE_LPP_SUSPEND_STR    "suspend"
#define LPI_MODE_LPP_SUSPEND_SX     "S2"
#define LPI_MODE_LPP_HIBERNATE_STR  "hibernate"
#define LPI_MODE_LPP_HIBERNATE_SX   "S4"
#define LPI_MODE_LPP_SOFTOFF_STR    "softoff"
#define LPI_MODE_LPP_SOFTOFF_SX     "S5"
#define LPI_MODE_LPP_WAKE_STR       "wake"
#define LPI_MODE_LPP_WAKE_SX        "S0"
#define LPI_MODE_LPP_RTOS1_STR      "rtos"
#define LPI_MODE_LPP_UNKNOWN_STR    "unknown"

typedef struct lpp_control_s
{
    unsigned int     wake;
    unsigned int     service;
    unsigned int     wfi;
    unsigned int     global;
    unsigned int     avs;
    unsigned int     mc;
    unsigned int     debug;
    unsigned int     asr_clocks;
} lpp_control_t;

typedef struct lp_control_s
{
    unsigned int     mode;
    char *           mode_name[e_lpp_level_levels];
    char *           sleep_name[e_lpp_level_levels];
    unsigned int     debug;                                 // enable our debug mode
    unsigned int     light_lpi_enable;                      // light sleep is either AP WFI, or our LPI_MODE_LINUX_SLEEP_1
    lpp_control_t    lpp[e_lpp_level_levels];
} lp_control_t;

#endif   // #ifndef INC_LPI_H

