/*
 * linux/sound/soc/pxa/pegmatite.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

#include <linux/dmaengine.h>
#include <sound/pcm.h>
#include <sound/dmaengine_pcm.h>
#include <linux/platform_data/mv61_cdma.h>

#define MV61X0_SND_MIN_PERIODS 16
#define MV61X0_SND_MAX_PERIODS 16
#define MV61X0_SND_MIN_PERIOD_BYTES 0x1000
#define MV61X0_SND_MAX_PERIOD_BYTES 0x1000

static struct snd_pcm_hardware mv61x0_dma_snd_hw = {
	.info				= (SNDRV_PCM_INFO_INTERLEAVED    |
						   SNDRV_PCM_INFO_MMAP           |
						   SNDRV_PCM_INFO_MMAP_VALID     |
						   SNDRV_PCM_INFO_HALF_DUPLEX ),
	.formats			= SNDRV_PCM_FMTBIT_S16_LE | SNDRV_PCM_FMTBIT_U8,
	.rates				= SNDRV_PCM_RATE_8000_96000 | SNDRV_PCM_RATE_192000,
	.buffer_bytes_max	= MV61X0_SND_MAX_PERIOD_BYTES * MV61X0_SND_MAX_PERIODS,
	.period_bytes_min	= MV61X0_SND_MIN_PERIOD_BYTES,
	.period_bytes_max	= MV61X0_SND_MAX_PERIOD_BYTES,
	.periods_min		= MV61X0_SND_MIN_PERIODS,
	.periods_max		= MV61X0_SND_MAX_PERIODS,
	.fifo_size			= 0,
};

static struct mv61_dma_slave i2s_dma_parms_tx = {
	.vtype = MV61_VDMA_CYCLIC,
	.wr_delay = 0,
	.destendian = MV61_DMA_BIG_ENDIAN,
	.srcendian = MV61_DMA_LITTLE_ENDIAN,
	.flowctrl = MV61_DMA_MEMORY_TO_PERIPHERAL,
	.dest_pid = 13, //I2S_TX_PID,
	.dest_addr_inc = false,
	.dest_reg = 0xf81a0080,
	.src_addr_inc = true,
	.src_width = MV61_DMA_XFER_WIDTH_32BIT,
	.dest_width = MV61_DMA_XFER_WIDTH_16BIT,
	.data_unit_size = MV61_DMA_UNIT_SIZE_16BIT,
	.dest_burst = MV61_DMA_BURST1,
	.src_burst = MV61_DMA_BURST1,
	.timebase = MV61_TIMEBASE_1US,
	.timer = 0,
};

static struct dma_chan *sspa_dma_request_channel(struct snd_soc_pcm_runtime *rtd, struct snd_pcm_substream *substream) {
	dma_cap_mask_t mask;
	dma_cap_zero(mask);
	dma_cap_set(DMA_CYCLIC, mask);

	return dma_request_channel(mask, filter, &i2s_dma_parms_tx);
}

static const struct snd_dmaengine_pcm_config sspa_pcm_config = {
	.pcm_hardware = &mv61x0_dma_snd_hw,
	.compat_request_channel = sspa_dma_request_channel,
};

int pegmatite_sspa_probe(struct platform_device *pdev)
{
	return devm_snd_dmaengine_pcm_register(&pdev->dev, &sspa_pcm_config,
			SND_DMAENGINE_PCM_FLAG_COMPAT |
			SND_DMAENGINE_PCM_FLAG_NO_RESIDUE |
			SND_DMAENGINE_PCM_FLAG_HALF_DUPLEX |
			SND_DMAENGINE_PCM_FLAG_NO_DT);
}
