#include <linux/linkage.h>
#include <linux/init.h>

        .section ".text.head", "ax"

ENTRY(pegmatite_smp_jump)
	ldr     r1, pegmatite_smp_jump_table
	mrc	p15, 0, r0, c0, c0, 5	@ Read MPIDR
	and	r0, r0, #0xf		@ Get CPU number in R0
	ldr	r1, [r1, r0, LSL #2]	@ Read jump address for this cpu
	blx     r1

	.globl	pegmatite_smp_jump_table
pegmatite_smp_jump_table:
	.long	0x0
ENDPROC(pegmatite_smp_jump)
	.globl pegmatite_smp_jump_size
pegmatite_smp_jump_size:
	.long	. - pegmatite_smp_jump

	.macro	pegmatite_cpu_prepare
	bl      v7_invalidate_l1
	mrrc	p15, 1, r0, r1, c15	@ Read CPUECTRL register
	orr	r0, r0, #(1<<6)         @ Turn on SMP (coherency)
	mcrr	p15, 1, r0, r1, c15	@ Write CPUECTRL register
	.endm

ENTRY(pegmatite_secondary_startup)
	pegmatite_cpu_prepare
	b       secondary_startup
ENDPROC(pegmatite_secondary_startup)

ENTRY(pegmatite_cpu_resume_entry)
	pegmatite_cpu_prepare
	b       cpu_resume
ENDPROC(pegmatite_cpu_resume_entry)
