/*
 * APB config support for Pegmatite platforms.
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2.  This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 *
 */
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/of_address.h>
#include <linux/io.h>

static void __iomem *apb_config_base;

#define SQU_REV0_A0 0x40
#define SQU_REV0    0x38

static const struct of_device_id of_apb_config_table[] = {
	{.compatible = "marvell,pegmatite-apb-config"},
	{ /* end of list */ },
};

extern int is_reva(void);
int is_fpga(void)
{
	int val;

	if (is_reva( ))
		val = readl(apb_config_base + SQU_REV0_A0);
	else
		val = readl(apb_config_base + SQU_REV0);

	return (val == 0);
};

int __init pegmatite_apb_config_init(void)
{
	struct device_node *np;

	np = of_find_matching_node(NULL, of_apb_config_table);
	if (np) {
		pr_info("Initializing Pegmatite APB config\n");
		apb_config_base = of_iomap(np, 0);
	}

	return 0;
}

early_initcall(pegmatite_apb_config_init);
