/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1995, 96, 97, 98, 99, 2000 by Ralf Baechle
 * Copyright (C) 1999, 2000 Silicon Graphics, Inc.
 *
 * Changed system calls macros _syscall5 - _syscall7 to push args 5 to 7 onto
 * the stack. Robin Farine for ACN S.A, Copyright (C) 1996 by ACN S.A
 */

#ifndef _MIPS_SIM_ABI32
#define _MIPS_SIM_ABI32			1
#define _MIPS_SIM_NABI32		2
#define _MIPS_SIM_ABI64			3
#endif

#if _MIPS_SIM == _MIPS_SIM_ABI32

/*
 * Linux o32 style syscalls are in the range from 4000 to 4999.
 */
#define __NR_Linux			4000
#define __NR_io_setup			(__NR_Linux + 241)
#define __NR_io_destroy			(__NR_Linux + 242)
#define __NR_io_getevents		(__NR_Linux + 243)
#define __NR_io_submit			(__NR_Linux + 244)
#define __NR_io_cancel			(__NR_Linux + 245)

#endif /* _MIPS_SIM == _MIPS_SIM_ABI32 */

#if _MIPS_SIM == _MIPS_SIM_ABI64

/*
 * Linux 64-bit syscalls are in the range from 5000 to 5999.
 */
#define __NR_Linux			5000
#define __NR_io_setup			(__NR_Linux + 200)
#define __NR_io_destroy			(__NR_Linux + 201)
#define __NR_io_getevents		(__NR_Linux + 202)
#define __NR_io_submit			(__NR_Linux + 203)
#define __NR_io_cancel			(__NR_Linux + 204)
#endif /* _MIPS_SIM == _MIPS_SIM_ABI64 */

#if _MIPS_SIM == _MIPS_SIM_NABI32

/*
 * Linux N32 syscalls are in the range from 6000 to 6999.
 */
#define __NR_Linux			6000
#define __NR_io_setup			(__NR_Linux + 200)
#define __NR_io_destroy			(__NR_Linux + 201)
#define __NR_io_getevents		(__NR_Linux + 202)
#define __NR_io_submit			(__NR_Linux + 203)
#define __NR_io_cancel			(__NR_Linux + 204)
#endif /* _MIPS_SIM == _MIPS_SIM_NABI32 */

#define io_syscall1(type,fname,sname,atype,a) \
type fname(atype a) \
{ \
	register unsigned long __a0 asm("$4") = (unsigned long) a; \
	register unsigned long __a3 asm("$7"); \
	unsigned long __v0; \
	\
	__asm__ volatile ( \
	".set\tnoreorder\n\t" \
	"li\t$2, %3\t\t\t# " #fname "\n\t" \
	"syscall\n\t" \
	"move\t%0, $2\n\t" \
	".set\treorder" \
	: "=&r" (__v0), "=r" (__a3) \
	: "r" (__a0), "i" (__NR_##sname) \
	: "$2", "$8", "$9", "$10", "$11", "$12", "$13", "$14", "$15", "$24", \
	  "memory"); \
	\
	if (__a3 == 0) \
		return (type) __v0; \
	return (type) (-(__v0)); \
}

#define io_syscall2(type,fname,sname,atype,a,btype,b) \
type fname(atype a, btype b) \
{ \
	register unsigned long __a0 asm("$4") = (unsigned long) a; \
	register unsigned long __a1 asm("$5") = (unsigned long) b; \
	register unsigned long __a3 asm("$7"); \
	unsigned long __v0; \
	\
	__asm__ volatile ( \
	".set\tnoreorder\n\t" \
	"li\t$2, %4\t\t\t# " #fname "\n\t" \
	"syscall\n\t" \
	"move\t%0, $2\n\t" \
	".set\treorder" \
	: "=&r" (__v0), "=r" (__a3) \
	: "r" (__a0), "r" (__a1), "i" (__NR_##sname) \
	: "$2", "$8", "$9", "$10", "$11", "$12", "$13", "$14", "$15", "$24", \
	  "memory"); \
	\
	if (__a3 == 0) \
		return (type) __v0; \
	return (type) (-(__v0)); \
}

#define io_syscall3(type,fname,sname,atype,a,btype,b,ctype,c) \
type fname(atype a, btype b, ctype c) \
{ \
	register unsigned long __a0 asm("$4") = (unsigned long) a; \
	register unsigned long __a1 asm("$5") = (unsigned long) b; \
	register unsigned long __a2 asm("$6") = (unsigned long) c; \
	register unsigned long __a3 asm("$7"); \
	unsigned long __v0; \
	\
	__asm__ volatile ( \
	".set\tnoreorder\n\t" \
	"li\t$2, %5\t\t\t# " #fname "\n\t" \
	"syscall\n\t" \
	"move\t%0, $2\n\t" \
	".set\treorder" \
	: "=&r" (__v0), "=r" (__a3) \
	: "r" (__a0), "r" (__a1), "r" (__a2), "i" (__NR_##sname) \
	: "$2", "$8", "$9", "$10", "$11", "$12", "$13", "$14", "$15", "$24", \
	  "memory"); \
	\
	if (__a3 == 0) \
		return (type) __v0; \
	return (type) (-(__v0)); \
}

#define io_syscall4(type,fname,sname,atype,a,btype,b,ctype,c,dtype,d) \
type fname(atype a, btype b, ctype c, dtype d) \
{ \
	register unsigned long __a0 asm("$4") = (unsigned long) a; \
	register unsigned long __a1 asm("$5") = (unsigned long) b; \
	register unsigned long __a2 asm("$6") = (unsigned long) c; \
	register unsigned long __a3 asm("$7") = (unsigned long) d; \
	unsigned long __v0; \
	\
	__asm__ volatile ( \
	".set\tnoreorder\n\t" \
	"li\t$2, %5\t\t\t# " #fname "\n\t" \
	"syscall\n\t" \
	"move\t%0, $2\n\t" \
	".set\treorder" \
	: "=&r" (__v0), "+r" (__a3) \
	: "r" (__a0), "r" (__a1), "r" (__a2), "i" (__NR_##sname) \
	: "$2", "$8", "$9", "$10", "$11", "$12", "$13", "$14", "$15", "$24", \
	  "memory"); \
	\
	if (__a3 == 0) \
		return (type) __v0; \
	return (type) (-(__v0)); \
}

#if (_MIPS_SIM == _MIPS_SIM_ABI32)

/*
 * Using those means your brain needs more than an oil change ;-)
 */

#define io_syscall5(type,fname,sname,atype,a,btype,b,ctype,c,dtype,d,etype,e) \
type fname(atype a, btype b, ctype c, dtype d, etype e) \
{ \
	register unsigned long __a0 asm("$4") = (unsigned long) a; \
	register unsigned long __a1 asm("$5") = (unsigned long) b; \
	register unsigned long __a2 asm("$6") = (unsigned long) c; \
	register unsigned long __a3 asm("$7") = (unsigned long) d; \
	unsigned long __v0; \
	\
	__asm__ volatile ( \
	".set\tnoreorder\n\t" \
	"lw\t$2, %6\n\t" \
	"subu\t$29, 32\n\t" \
	"sw\t$2, 16($29)\n\t" \
	"li\t$2, %5\t\t\t# " #fname "\n\t" \
	"syscall\n\t" \
	"move\t%0, $2\n\t" \
	"addiu\t$29, 32\n\t" \
	".set\treorder" \
	: "=&r" (__v0), "+r" (__a3) \
	: "r" (__a0), "r" (__a1), "r" (__a2), "i" (__NR_##sname), \
	  "m" ((unsigned long)e) \
	: "$2", "$8", "$9", "$10", "$11", "$12", "$13", "$14", "$15", "$24", \
	  "memory"); \
	\
	if (__a3 == 0) \
		return (type) __v0; \
	return (type) (-(__v0)); \
}

#endif /* (_MIPS_SIM == _MIPS_SIM_ABI32) */

#if (_MIPS_SIM == _MIPS_SIM_NABI32) || (_MIPS_SIM == _MIPS_SIM_ABI64)

#define io_syscall5(type,fname,sname,atype,a,btype,b,ctype,c,dtype,d,etype,e) \
type fname (atype a,btype b,ctype c,dtype d,etype e) \
{ \
	register unsigned long __a0 asm("$4") = (unsigned long) a; \
	register unsigned long __a1 asm("$5") = (unsigned long) b; \
	register unsigned long __a2 asm("$6") = (unsigned long) c; \
	register unsigned long __a3 asm("$7") = (unsigned long) d; \
	register unsigned long __a4 asm("$8") = (unsigned long) e; \
	unsigned long __v0; \
	\
	__asm__ volatile ( \
	".set\tnoreorder\n\t" \
	"li\t$2, %6\t\t\t# " #fname "\n\t" \
	"syscall\n\t" \
	"move\t%0, $2\n\t" \
	".set\treorder" \
	: "=&r" (__v0), "+r" (__a3) \
	: "r" (__a0), "r" (__a1), "r" (__a2), "r" (__a4), "i" (__NR_##sname) \
	: "$2", "$9", "$10", "$11", "$12", "$13", "$14", "$15", "$24", \
	  "memory"); \
	\
	if (__a3 == 0) \
		return (type) __v0; \
	return (type) (-(__v0)); \
}

#endif /* (_MIPS_SIM == _MIPS_SIM_NABI32) || (_MIPS_SIM == _MIPS_SIM_ABI64) */

