/*
 * testmain.c
 *
 *  Created on: 2014/11/13
 *      Author: sai495479
 */

#include <stdio.h>
#include <stdlib.h>

#include <fcntl.h>

#include <sys/sem.h>
#include <sys/select.h>

#include <err.h>
#include <errno.h>
#include <unistd.h>

#include <pthread.h>

/* セマフォ操作 */
#define MFPRINTF_LOCK		(-1)
#define MFPRINTF_UNLOCK		1

pthread_mutex_t gMutex4port;
pthread_mutex_t gMutexWCMD;

/*
 * semget for mfprintf
 * 初回呼び出し元が不明でも複数プロセスから呼び出せるsemgetのラッパー
 * 初回は初期化を行い、次回からはただgetするだけ
 */
static inline int
_mfprintf_semget(int key)
{
	int semid = -1, rv;
	unsigned short vals[1] = {1};

	union semun {
		int		 val;
		struct semid_ds	 *buf;
		unsigned short	 *array;
	} ctl_arg;

	/* 引数検査 */
	if (key < 0) {
		return -EINVAL;
	}

	/* 初回作成要求 */
	if ((semid = semget(key, 1, IPC_CREAT | IPC_EXCL | 0777)) != -1) {
		/* セマフォ初期化 */
		ctl_arg.array = vals;
		if (semctl(semid, 0, SETALL, ctl_arg) == -1) {
			rv = -errno;
			warn("_mfprintf_semget:pid=%d, semctl key=%d",
			     getpid(), key);
			return rv;
		}
	} else {
		/* 既に存在していた？ */
		if (errno == EEXIST) {
			/* 再作成要求(初期化なし) */
			if ((semid = semget(key, 1, IPC_CREAT)) == -1) {
				rv = -errno;
				warn("_mfprintf_semget:pid=%d, resemget key=%d",
				     getpid(), key);
				return rv;
			}
		}else{
			/* 完全失敗 */
			rv = -errno;
			warn("_mfprintf_semget:pid=%d, semget failure key=%d",
			     getpid(), key);
			return rv;
		}
	}
	return semid;
}


/*
 * semop for mfprintf
 * セマフォ操作を行う
 */
static inline int
_mfprintf_semop(int semid, int op)
{
	struct sembuf	 sops[1];

	/* 引数検査 */
	if (semid < 0 ||
	    !((op == MFPRINTF_LOCK) || (op == MFPRINTF_UNLOCK))) {
		return -EINVAL;
	}

	sops[0].sem_num = 0;
	sops[0].sem_op = op;
	sops[0].sem_flg = SEM_UNDO;

	if (semop(semid, sops, 1) == -1) {
		int rv = -errno;
		warn( "_mfprintf_semop:pid=%d, failure id=%d, op=%d",
		      getpid(), semid, op);
		return rv;
	}
	return semid;
}

// write, read rsci cmd R4.1
// write, read leci cmd R4.2
// write, read rsci signal R4.3
// write, read leci signal R4.4
//CMD_SEM_KEY
//READ_SIGNAL_SEM_KEY
int write1(const char *devname, int semkey, unsigned int *buf)
{
	int semid = -1;
	int fd;
	int size=-1;

	if ((semid = _mfprintf_semget(semkey)) == -1) {
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
		return -1;
	}
	if (_mfprintf_semop(semid, MFPRINTF_LOCK) == -1) {
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
		return -1;
	}

	fd = open(devname, O_WRONLY );
	if (fd < 0)
	{
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
	}

	size = write(fd, buf, 4);
printf("write	0x%8x, ret %d\n", *buf, size);
	close(fd);

	_mfprintf_semop(semid, MFPRINTF_UNLOCK);
	return size;
}

//CMD_SEM_KEY
//READ_SIGNAL_SEM_KEY
int read1(const char *devname, int semkey, unsigned int *buf)
{
	int semid = -1;
	int fd;
	int size=-1;

	if ((semid = _mfprintf_semget(semkey)) == -1) {
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
		return -1;
	}
	if (_mfprintf_semop(semid, MFPRINTF_LOCK) == -1) {
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
		return -1;
	}

	fd = open(devname, O_RDONLY );
	if (fd < 0)
	{
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
	}

//	printf("read 0x%8x\n", *buf);
	size = read(fd, buf, 4);
	if (size < 0) {
		printf("%s(%d):ERR! read() fd=%d ", __func__, __LINE__, fd);
		perror(":");
	}
//	printf("read ret %d\n", size);
	close(fd);

	_mfprintf_semop(semid, MFPRINTF_UNLOCK);
	return size;
}

/*
 * mfprintf/shmlog間で利用するセマフォ番号
 *   セマフォ番号割り当てはLPUX設計仕様書DBを参照のこと
 */
#define	RWCMD_WSIG_SEM_KEY	(0x8439327)

#define	R_SIG_SEM_KEY			(RWCMD_WSIG_SEM_KEY+0x423)
#define	R_RSCI_SEM_KEY			(RWCMD_WSIG_SEM_KEY+0x424)
#define	R_LECI_SEM_KEY			(RWCMD_WSIG_SEM_KEY+0x425)
#define	R_FAX_SEM_KEY			(RWCMD_WSIG_SEM_KEY+0x426)

#define	W_CMD_SEM_KEY			(RWCMD_WSIG_SEM_KEY+0x34320)

#define R_SIG(_a)	(read1("/sys/class/ipc/R4/R4.1/rw", R_SIG_SEM_KEY, _a))
#define R_RSCI_CMD(_a)	(read1("/sys/class/ipc/R4/R4.2/rw", R_RSCI_SEM_KEY, _a))
#define R_LECI_CMD(_a)	(read1("/sys/class/ipc/R4/R4.3/rw", R_LECI_SEM_KEY, _a))
#define R_FAX_CMD(_a)	(read1("/sys/class/ipc/R4/R4.4/rw", R_FAX_SEM_KEY, _a))

#define W_SIG(_a)	(write1("/sys/class/ipc/R4/R4.1/rw", RWCMD_WSIG_SEM_KEY, _a))

#define W_RSCI_CMD(_a)	(write1("/sys/class/ipc/R4/R4.2/rw", RWCMD_WSIG_SEM_KEY, _a))

#define W_LECI_CMD(_a)	(write1("/sys/class/ipc/R4/R4.3/rw", RWCMD_WSIG_SEM_KEY, _a))

#define W_FAX_CMD(_a)	(write1("/sys/class/ipc/R4/R4.4/rw", RWCMD_WSIG_SEM_KEY, _a))

void *thread_recv_4port(void *param)
{
	unsigned int buf;
printf("%s(%d) start\n", __func__, __LINE__);
	int semid = -1;
	int fd41,fd42,fd43,fd44;
	int size=-1;
	int semkey=RWCMD_WSIG_SEM_KEY;
	
	fd_set fdset;
	struct timeval timeout;
	int retselect;
	
	if ((semid = _mfprintf_semget(semkey)) == -1) {
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
	}
	if (_mfprintf_semop(semid, MFPRINTF_LOCK) == -1) {
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
	}

printf("%s(%d)\n", __func__, __LINE__);
	timeout.tv_sec=0;
	timeout.tv_usec=0;
	while(1) {
printf("%s(%d)\n", __func__, __LINE__);
		fd41 = open("/sys/class/ipc/R4/R4.1/rw", O_RDONLY );
		if (fd41 < 0)
		{
			printf("ERR! %s(%d)\n", __func__, __LINE__);
			exit(31);
		}
		fd42 = open("/sys/class/ipc/R4/R4.2/rw", O_RDONLY );
		if (fd42 < 0)
		{
			printf("ERR! %s(%d)\n", __func__, __LINE__);
			exit(31);
		}
		fd43 = open("/sys/class/ipc/R4/R4.3/rw", O_RDONLY );
		if (fd43 < 0)
		{
			printf("ERR! %s(%d)\n", __func__, __LINE__);
			exit(31);
		}
		fd44 = open("/sys/class/ipc/R4/R4.4/rw", O_RDONLY );
		if (fd44 < 0)
		{
			printf("ERR! %s(%d)\n", __func__, __LINE__);
			exit(31);
		}
		
		FD_ZERO(&fdset);
		FD_SET(fd41, &fdset);
		FD_SET(fd42, &fdset);
		FD_SET(fd43, &fdset);
		FD_SET(fd44, &fdset);
		
printf("%s(%d)\n", __func__, __LINE__);
		retselect = select(5, &fdset, NULL, NULL, NULL);
		if (retselect <= 0) {
			perror("select:");
			break;
		}

		if (FD_ISSET(fd41, &fdset)) {
printf("%s(%d)\n", __func__, __LINE__);
		}
		if (FD_ISSET(fd42, &fdset)) {
printf("%s(%d)\n", __func__, __LINE__);
		}
		if (FD_ISSET(fd43, &fdset)) {
printf("%s(%d)\n", __func__, __LINE__);
		}
		if (FD_ISSET(fd44, &fdset)) {
printf("%s(%d)\n", __func__, __LINE__);
		}
		
printf("%s(%d)\n", __func__, __LINE__);
		if (FD_ISSET(fd41, &fdset)) {
			size = read(fd41, &buf, 4);
			if (size == 4) {
printf("read 0x%8x\n", buf);
			} else {
				printf("%s(%d):ERR! read() fd=%d\n", __func__, __LINE__, fd41);
				perror(":");
			}
		}
printf("%s(%d)\n", __func__, __LINE__);
		if (FD_ISSET(fd42, &fdset)) {
printf("%s(%d)\n", __func__, __LINE__);
			size = read(fd42, &buf, 4);
printf("%s(%d)\n", __func__, __LINE__);
			if (size == 4) {
printf("read 0x%8x\n", buf);
			} else {
				printf("%s(%d):ERR! read() fd=%d\n", __func__, __LINE__, fd42);
				perror(":");
			}
		}
printf("%s(%d)\n", __func__, __LINE__);
		if (FD_ISSET(fd43, &fdset)) {
			size = read(fd43, &buf, 4);
			if (size == 4) {
printf("read 0x%8x\n", buf);
			} else {
				printf("%s(%d):ERR! read() fd=%d\n", __func__, __LINE__, fd43);
				perror(":");
			}
		}
printf("%s(%d)\n", __func__, __LINE__);
		if (FD_ISSET(fd44, &fdset)) {
			size = read(fd44, &buf, 4);
			if (size == 4) {
printf("read 0x%8x\n", buf);
			} else {
				printf("%s(%d):ERR! read() fd=%d\n", __func__, __LINE__, fd44);
				perror(":");
			}
		}
printf("%s(%d)\n", __func__, __LINE__);
		
		close(fd41);
		close(fd42);
		close(fd43);
		close(fd44);
	}
	
//	printf("read ret %d\n", size);

	_mfprintf_semop(semid, MFPRINTF_UNLOCK);
}


#define CMDBUFSIZ 256
unsigned int gCmdBuf[CMDBUFSIZ];
int gCmdBufAddCnt=0;
int gCmdBufGetCnt=0;

int add_command(unsigned int command)
{
	if (gCmdBufAddCnt > 0xffffff00) { printf("command counter overrun !\n"); return -1; }
	if (gCmdBufAddCnt < gCmdBufGetCnt + CMDBUFSIZ) {
		gCmdBuf[gCmdBufAddCnt%CMDBUFSIZ]=command;
		gCmdBufAddCnt++;
	} else {
		return -1;
	}
	return 0;
}

int get_command(unsigned int *command)
{
	if (gCmdBufGetCnt < gCmdBufAddCnt) {
//printf("%s(%d):gCmdBufAddCnt=0x%8x, gCmdBufGetCnt=0x%8x, \n", __func__, __LINE__, gCmdBufAddCnt, gCmdBufGetCnt);
		*command = gCmdBuf[gCmdBufGetCnt%CMDBUFSIZ];
//printf("%s(%d):command=0x%8x\n", __func__, __LINE__, *command);
		gCmdBufGetCnt++;
	} else {
		return -1;
	}
	return 0;
}

void *thread_send_command(void *param)
{
//printf("%s(%d) start\n", __func__, __LINE__);
	while(1) {
		int ret_get_command;
		unsigned int command;

		pthread_mutex_lock(&gMutexWCMD);
		ret_get_command=get_command(&command);
		pthread_mutex_unlock(&gMutexWCMD);

		if (ret_get_command >= 0) {
			//success
			switch(ret_get_command & 0x30000000) {
			case 0x00000000://signal
				W_SIG(&command);
				break;
			case 0x10000000://leci
				W_LECI_CMD(&command);
				break;
			case 0x20000000://rsci
				W_RSCI_CMD(&command);
				break;
			case 0x30000000://fax
				W_FAX_CMD(&command);
				break;
			default:
				break;
			}
		}
	}
	return 0;
}

char gCmdString[16];

void parse_commands(char *filename)
{
	FILE *cmdfilefp;
//printf("%s(%d) start\n", __func__, __LINE__);
	cmdfilefp = fopen("cmdfile.txt", "r");
	if (cmdfilefp == NULL) {
		perror("fopen cmdfile.txt:"); exit(-1);
	}

	while(1) {
		int ret_add_command;
		unsigned int command;
		char *retfgets;

		retfgets = fgets(gCmdString, 16-1, cmdfilefp);
		if (retfgets == NULL) { break; }
		errno=0;
		command=strtoul(gCmdString, NULL, 16);
		if (errno != 0) {
			perror("parse_commands() strtoul error!:");
			break;
		}

		ret_add_command=-1;
		while(ret_add_command < 0) {
			pthread_mutex_lock(&gMutexWCMD);
			ret_add_command=add_command(command);
			pthread_mutex_unlock(&gMutexWCMD);
			if (ret_add_command < 0) { sleep(1); }
		}
	}
	fclose(cmdfilefp);
//printf("%s(%d) end\n", __func__, __LINE__);
}

int main(int argc, char *argv[])
{
	pthread_t recv_4port;
	pthread_t send_command;
	
printf("ipc test(select) start %s\n", __TIME__);
	
	if(pthread_create(&recv_4port, NULL , thread_recv_4port, NULL) !=0)  /*2番目の引数にNULLを指定することによりスレッドの属性にデフォルトとする*/
	{
		perror("thread_recv_signal\n"); exit(-1);
	}
	if(pthread_create(&send_command, NULL , thread_send_command, NULL) !=0)  /*2番目の引数にNULLを指定することによりスレッドの属性にデフォルトとする*/
	{
		perror("thread_send_command\n"); exit(-1);
	}

	pthread_mutex_init(&gMutex4port, NULL);
	pthread_mutex_init(&gMutexWCMD, NULL);

	parse_commands("command.txt");

	pthread_mutex_destroy(&gMutex4port);
	pthread_mutex_destroy(&gMutexWCMD);


	while(1);
	return 0;
}

