/*
    commands.h: Commands sent to the card
    Copyright (C) 2003   Ludovic Rousseau

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

/*
 * $Id: commands.h 2090 2006-07-03 13:56:42Z rousseau $
 */

#define SIZE_GET_SLOT_STATUS 10
#define STATUS_OFFSET 7
#define ERROR_OFFSET 8
#define CHAIN_PARAMETER_OFFSET 9
#define SERIAL_TIMEOUT 2	// CCIDPCSC:0003

RESPONSECODE CmdPowerOn(unsigned int reader_index, unsigned int * nlength,
	unsigned char buffer[], int voltage);

RESPONSECODE SecurePINVerify(unsigned int reader_index,
	unsigned char TxBuffer[], unsigned int TxLength,
	unsigned char RxBuffer[], unsigned int *RxLength);

RESPONSECODE SecurePINModify(unsigned int reader_index,
	unsigned char TxBuffer[], unsigned int TxLength,
	unsigned char RxBuffer[], unsigned int *RxLength);

RESPONSECODE CmdEscape(unsigned int reader_index,
	const unsigned char TxBuffer[], unsigned int TxLength,
	unsigned char RxBuffer[], unsigned int *RxLength);

RESPONSECODE CmdPowerOff(unsigned int reader_index);

RESPONSECODE CmdGetSlotStatus(unsigned int reader_index,
	unsigned char buffer[]);

RESPONSECODE CmdXfrBlock(unsigned int reader_index, unsigned int tx_length,
	unsigned char tx_buffer[], unsigned int *rx_length,
	unsigned char rx_buffer[], int protoccol);

RESPONSECODE CCID_Transmit(unsigned int reader_index, unsigned int tx_length,
	const unsigned char tx_buffer[], unsigned short rx_length, unsigned char bBWI);

RESPONSECODE CCID_Receive(unsigned int reader_index, unsigned int *rx_length,
	unsigned char rx_buffer[], unsigned char *chain_parameter);

RESPONSECODE SetParameters(unsigned int reader_index, char protocol,
	unsigned int length, unsigned char buffer[]);

/* internal functions */
RESPONSECODE CmdXfrBlockTPDU_T1(unsigned int reader_index,
	unsigned int tx_length, unsigned char tx_buffer[], unsigned int *rx_length,
	unsigned char rx_buffer[]);

int isCharLevel(int reader_index);



// CCIDPCSC:0020
/************************************/
/* DENSO PR-401UDM Command Function */
/************************************/

RESPONSECODE ReaderInit(unsigned int reader_index);
RESPONSECODE GetinfPCD(unsigned int reader_index, unsigned char *buffer);
RESPONSECODE GetinfPICC(unsigned int reader_index, unsigned char *buffer);
RESPONSECODE CarrierON(unsigned int reader_index);
RESPONSECODE CarrierOFF(unsigned int reader_index);
RESPONSECODE SetCardStatus(unsigned int reader_index,unsigned char speed);
RESPONSECODE SetinfPICC(unsigned int reader_index);
RESPONSECODE ReqbPICC(unsigned int reader_index, unsigned char *buffer);
RESPONSECODE AttribPICC(unsigned int reader_index);
RESPONSECODE HaltPICC(unsigned int reader_index);
RESPONSECODE WakeupPICC(unsigned int reader_index, unsigned char *buffer);
RESPONSECODE SensPCD(unsigned int reader_index, unsigned char *buffer);
RESPONSECODE ReaderStart(unsigned int reader_index);
RESPONSECODE ReaderClose(unsigned int reader_index);
RESPONSECODE RequestCard(unsigned int reader_index, unsigned char *buffer);
RESPONSECODE SetDeviceSpeed(unsigned int reader_index, unsigned char speed);
RESPONSECODE Device_LED_Control(unsigned int reader_index, unsigned char mode, unsigned short on_time,
					unsigned short off_time);
RESPONSECODE SetTimeout(unsigned int reader_index, unsigned int fwt);

/* DENSO PR-401UDM Command Sub Function */
RESPONSECODE ICC_Trancefer(unsigned int reader_index, int tx_length, unsigned char tx_buffer[],
			   int *rx_length, unsigned char rx_buffer[]);
unsigned short UpdateCrc(unsigned char ch, unsigned short *lpwCrc);
void ComputeCrc(int CRCType, char *Data, int Length,
                unsigned char* TransmitFirst, unsigned char* TransmitSecond);
int MakeICCCmd(char* src, int srclen, int blockno, char* dest, int destlen);
char	getBcc(char* str, int len);

/* DENSO PR-401UDM Command Make Function */
int Make_InitReset_Cmd(unsigned char *cmd,unsigned int *cmdlen);
int Make_Check_Device_Cmd(unsigned char *cmd, unsigned int *cmdlen);
int Make_Get_Device_Status_Cmd(unsigned char *cmd, unsigned int *cmdlen);
int Make_Set_Device_Speed_Cmd(unsigned char *cmd, unsigned int *cmdlen, unsigned char speed);
void Make_LED_CTL_Cmd(unsigned char *cmd, unsigned int *cmdlen ,unsigned char mode,
				unsigned short  on_time, unsigned short off_time);


RESPONSECODE Exec_Command(unsigned int reader_index, unsigned char *sendbuf, unsigned int sendlen,
				unsigned char *resbuf, unsigned int *reslen);
// CCIDPCSC:0020


// CCIDPCSC:0024
/* DENSO PR-401UDM Command Define */

#define	IFD_CMD_LENGTH_MAX	0x10c		/* Command Length Max (268byte)	*/
#define	IFD_CARD_CMD_LENGTH_MAX	0x10a		/* Command Length Max (266byte)	*/
#define	IFD_CMD_BUFFER_MAX	(0x10c+4)	/* Command Buffer Max (268byte+header+bcc)	*/

#define	IFD_RCV_CMD_LENGTH_OFFSET	1	/* Data Area Start offset */
#define	IFD_RCV_CMD_DATA_OFFSET		5	/* Data Area Start offset */
#define	IFD_RCV_RSP_DATA_OFFSET		4	/* Data Area Start offset */
#define IFD_RCV_CARD_CMD_RSP_OFFSET	3	/* IC Card Command Data Area */

#define	IFD_ATR_DATA_SIZE	11			/* (for TYPE-B) ATR Size	*/
#define	IFD_CID_DATA_SIZE	1			/* (for TYPE-B) CID Size	*/
#define	IFD_DEV_CMD_SIZE	128
// CCIDPCSC:0024

// CCIDPCSC:0025
/* Command Header (RCB)	*/

#define	CMD_RCB_IFD		0x08	/* Device Control Commands	*/
#define	CMD_RCB_CCTL		0x28	/* Card Communication Control Commands	*/
#define	CMD_RCB_ICC		0x20	/* Card data(add Card Command) Transfer Commands	*/

#define	CMD_DEVICE_SUCCESS_RESP	0x00
#define	CMD_CARD_SUCCESS_RESP	0x20

#define	CMD_DEVICE_ERR_RESP	0x80
#define	CMD_DEVICE_ERR_CWT	0x81
#define	CMD_DEVICE_ERR_BUF_OVER	0x82
#define	CMD_DEVICE_ERR_BCC	0x83
#define	CMD_DEVICE_ERR_BWT	0x84
#define	CMD_DEVICE_ERR_UNKNOWN	0x87

#define CMD_CARD_ERR_RESP	0xA0
#define CMD_CARD_ERR_CWT	0xA1
#define CMD_CARD_ERR_BUF_OVER	0xA2
#define CMD_CARD_ERR_BCC	0xA3
#define CMD_CARD_ERR_BWT	0xA4
#define CMD_CARD_ERR_UNKNOWN	0xA7

/* Command Result Parameter (SW1) */
#define	CMD_RESULT_SW1_OFFSET(a)	(a - 3)
#define	CMD_RESULT_SW1_SUCCESS		0x90
#define	CMD_RESULT_SW1_ERR_CARDTYPE	0x64
#define	CMD_RESULT_SW1_ERR_LENGTH	0x67
#define	CMD_RESULT_SW1_ERR_POWER	0x69
#define	CMD_RESULT_SW1_ERR_PARAM	0x6b
	
/* Command Result Parameter (SW2) */
#define	CMD_RESULT_SW2_OFFSET(a)	(a - 2)
#define	CMD_RESULT_SW2_NOMAL		0x00
#define	CMD_RESULT_SW2_ERR_POWER	0x85
// CCIDPCSC:0025

// CCIDPCSC:0023
/* Command Name Define(INS) for Device Control */
#define RESET_IFD               0x01    /* Device Main Reset */
#define CHECK_STATUS            0x03    /* Device Control Status Check */
#define GET_IFD_STATUS          0x05    /* Get Reader/Writer Status */
#define SET_IFD_SPEED           0x07    /* Device Control Parameter Change */

#define	LED_CTL					0x0b	/* LED Control Command	*/
// CCIDPCSC:0023

// CCIDPCSC:0028
/* CmdGetSlotStatus */
#define	IFD_PRESENSE_OFFSET	4
#define	IFD_CARD_ON		1
#define	IFD_CARD_OFF		0
// CCIDPCSC:0028

// CCIDPCSC:0021
/* Command Name Define(INS) for Card Communication Control  */
//#define CARD_POLLING            0x00    /* Card Polling Command */
#define CARD_CTL_RESET          0x01    /* J[hʐM䕔Zbg */
#define GET_CARD_CTL_STATUS     0x03    /* J[hʐM䕔擾 */
#define REQUEST_RESPONSE        0x04    /* Request Response (Felica) */
#define GET_CARD_STATUS         0x05    /* J[hʐMݒ擾 */
#define CARRIOR                 0x11    /* LA  */
#define SET_CARD_STATUS         0x13    /* J[hʐMݒ */
#define SET_TIMEOUT             0x15    /* ^CAEgԐݒ */
#define SET_RECEIVE_MODE        0x17    /* M[hݒ */

#define REQUEST_ALL_A           0x21    /* NGXgI[` */
#define SELECT_A                0x23    /* ZNg` */
#define HALT_A                  0x29    /* zg` */

#define REQUEST_ALL_B           0x31    /* NGXgI[a(REQB) */
#define ATTRIBUTE               0x33    /* NGXgI[a(ATTRIB) */
#define HALT_B                  0x39    /* zga */

#define REQUEST_ALL_C           0x51    /* NGXgI[b */

#define EP1			0
#define EP2			1
// CCIDPCSC:0021


// CCIDPCSC:0022
/*******************/
/* Commands Define */
/*******************/
//#define	IFD_ATQB_DATA_SIZE		11	/* (for TYPE-B Card) ATQB Size	*/

#define	CMD_RCB_OFFSET			0
#define	CMD_LEN_HIGH_OFFSET		1
#define	CMD_LEN_LOW_OFFSET		2
#define	CMD_DATA_AREA_OFFSET		3

/* Device Commands Offset Value */
#define	CMD_CLA_OFFSET			3
#define	CMD_INS_OFFSET			4
#define	CMD_PARAM1_OFFSET		5
#define	CMD_PARAM2_OFFSET		6
#define	CMD_LE_OFFSET			7
#define	CMD_LC_OFFSET			7

#define	CMD_ATTRIBUTE_DATA_OFFSET	7
#define	CMD_ATTRIBUTE_PUPI_OFFSET	8
#define	CMD_ATTRIBUTE_PARAM1_OFFSET	12
#define	CMD_ATTRIBUTE_PARAM2_OFFSET	13
#define	CMD_ATTRIBUTE_PARAM3_OFFSET	14
#define	CMD_ATTRIBUTE_PARAM4_OFFSET	15

#define	CMD_RCB_SIZE			1
#define	CMD_LENGTH_SIZE			2
#define	CMD_BCC_SIZE			1
#define	CMD_HEADER_SIZE			(CMD_RCB_SIZE + CMD_LENGTH_SIZE)

/* Reader Init (Reader Reset) Command */
#define	READER_INIT_DATA_SIZE		0x05

/* Check Device	Command */
#define	CHK_DEVICE_DATA_SIZE		0x05
#define	CHK_DEVICE_DCTL			0x01	/* Device Control */
#define	CHK_DEVICE_CCTL			0x04	/* Card Control	*/

/* Get Device Status Command */
#define GET_DEVICE_DATA_SIZE		0x04

/* Set Device Speed Command */
#define	SET_DEV_SPEED_DATA_SIZE		0x04

#define	DEV_SPD_B9600			0x00
#define	DEV_SPD_B19200			0x01
#define	DEV_SPD_B38400			0x02
#define	DEV_SPD_B14400			0x10
#define	DEV_SPD_B28800			0x11
#define	DEV_SPD_B57600			0x12
#define	DEV_SPD_B115200			0x13

/* Reset Card Control Command */
#define	RESET_CCTL_DATA_SIZE		0x04

/* Get Card Control Info Command */
#define	GET_CCTL_INFO_DATA_SIZE		0x04

/* Get Card Control Status Command */
#define	GET_CCTL_STATUS_DATA_SIZE	0x04

/* Carrior Command */
#define	CMD_CARRIOR_DATA_SIZE		0x04

#define	CARRIOR_ON			0x01
#define	CARRIOR_OFF			0x00

/* Set Receive Mode Command */
#define	SET_RCV_MODE_DATA_SIZE		0x04

#define	RCV_CUT_OUT			0x00
#define	RCV_RETRY			0x01

/* Set Card Communication Status Command */
#define	SET_CARD_STATUS_DATA_SIZE	0x04
#define SET_CARD_STATUS_DEFAULT		0x00

/* Set Card Response Timeout(FWT) Command */
#define	SET_TIMEOUT_DATA_SIZE	0x04

#define SET_TIMEOUT_DEFAULT		154
#define FWT_MAX					4949
#define fc 						13560		// CCIDPCSC:0231

#define	CARD_TYPE_A			0x01	/* PR-40?UDMł͎gps */
#define	CARD_TYPE_B			0x03
#define	CARD_TYPE_C			0x04

#define	CARD_SND_SPD_B106K		0x00
#define	CARD_SND_SPD_B212K		0x01
#define	CARD_SND_SPD_B424K		0x02

#define	CARD_RCV_SPD_B106K		0x00
#define	CARD_RCV_SPD_B212K		0x04
#define	CARD_RCV_SPD_B424K		0x08

/* Request_All_B */
#define REQ_ALL_B_CMD_DATA_SIZE		0x04
#define NO_AFI_VALUE				0x00

#define REQB_RESPONSE			0x08    /* AChԁAfB[ԁAzgԂ̃J[hREQBɉ */
#define REQB_RESPONSE_NO_HOLT	0x00    /* AChԁAfB[Ԃ̃J[hREQBɉ */
#define REQ_TIMESLOT_0			0x00    /* ^CXbg0 svH */
#define REQ_TIMESLOT_1			0x01    /* ^CXbg1 svH */
#define REQ_TIMESLOT_2			0x02    /* ^CXbg2 svH */
#define REQ_TIMESLOT_3			0x03    /* ^CXbg3 svH */
#define REQ_TIMESLOT_4			0x04    /* ^CXbg4 svH */

/* offset */
#define	REQ_ALL_B_DATA_OFFSET		3
#define	REQ_ALL_B_CARD_COLLISION	3
#define	CARD_NO_COLLISION			0x00
#define	CARD_COLLISION				0x01
#define	CARD_NONE					0x00
//#define	REQ_ALL_C_ERR_DATA_OFFSET	3
#define	REQ_ALL_B_CARD_COUNT			4
#define	REQ_ALL_B_CARD_DATA_OFFSET		5
#define	REQ_ALL_C_DATA_SIZE				18
#define IFD_CARRIER_WAIT				5000	/* usec */

#define ATQB_PUPI_OFFSET			0
#define ATQB_AFI_OFFSET				4
#define ATQB_PROTOCOL_OFFSET		8

#define	IFD_NO_CARD		0xC0

/* Attribute */
#define ATTRIBUTE_CMD_DATA_SIZE		0x0d
#define ATTRIBUTE_LENGTH			0x08    /* 4(PUPI) + Param1(1) + Param2(1) +Param3(1) + Param4(1) */
/* ATTRIBUTE DATA */
/* PARAM1 */
#define ATTRIBUTE_RFU				0x00	/* PARAM1(bit12) */
#define ATTRIBUTE_SOF				0x00	/* PARAM1(bit3) */
#define ATTRIBUTE_EOF				0x00	/* PARAM1(bit4) */

#define ATTRIBUTE_TR1_NONE			0x00	/* PARAM1(bit56) */
#define ATTRIBUTE_TR1_64FS			0x10
#define ATTRIBUTE_TR1_16FS			0x20
#define ATTRIBUTE_TR1_RFU			0x30

#define ATTRIBUTE_TR0_NONE			0x00	/* PARAM1(bit78) */
#define ATTRIBUTE_TR0_48FS			0x40
#define ATTRIBUTE_TR0_16FS			0x80
#define ATTRIBUTE_TR0_RFU			0xc0

/* PARAM2 */
#define ATTRIBUTE_FRAME_SIZE_16		0x00	/* PARAM2(bit1234) Frame Size */
#define ATTRIBUTE_FRAME_SIZE_24		0x01
#define ATTRIBUTE_FRAME_SIZE_32		0x02
#define ATTRIBUTE_FRAME_SIZE_40		0x03
#define ATTRIBUTE_FRAME_SIZE_48		0x04
#define ATTRIBUTE_FRAME_SIZE_64		0x05
#define ATTRIBUTE_FRAME_SIZE_96		0x06
#define ATTRIBUTE_FRAME_SIZE_128	0x07
#define ATTRIBUTE_FRAME_SIZE_256	0x08

#define ATTRIBUTE_PCD_PICC_106		0x00	/* PARAM2(bit56) PCD->PICC */
#define ATTRIBUTE_PCD_PICC_212		0x10
#define ATTRIBUTE_PCD_PICC_424		0x20
#define ATTRIBUTE_PCD_PICC_847		0x30

#define ATTRIBUTE_PICC_PCD_106		0x00	/* PARAM2(bit78) PICC->PCD */
#define ATTRIBUTE_PICC_PCD_212		0x40
#define ATTRIBUTE_PICC_PCD_424		0x80
#define ATTRIBUTE_PICC_PCD_847		0xc0

/* PARAM3 */
#define ATTRIBUTE_PROTOCOL_SUPPORT	0x01			/* PARAM3(bit1234) */
#define ATTRIBUTE_PROTOCOL_NON_SUPPORT	0x00

#define ATTRIBUTE_PROTOCOL_FIXED_HIGHER_ORDER 0x00	/* PARAM3(bit5678) */

/* PARAM4 */
#define ATTRIBUTE_CARD_ID			0x01			/* PARAM4 CID FIXED No Support Multi Card */

// CCIDPCSC:0022

// CCIDPCSC:0026
/* Device_LED_Control	*/
#define	LED_CTL_DATA_SIZE			0x09
#define	LED_BLINK_DATA_SIZE			0x04

#define	LED_CTL_BLINK_ON_OFFSET		8
#define	LED_CTL_BLINK_OFF_OFFSET	10
#define	IFD_LED_CTL_DEFAULT			0x00
#define	IFD_LED_CTL_OFF				0x01
#define	IFD_LED_CTL_ON				0x02
#define	IFD_LED_CTL_BLINK			0x03

#define	IFD_LED_CTL_TIME_DEFAULT	0x0000
// CCIDPCSC:0026

// CCIDPCSC:0027
#define	REQ_RES_CMD_OFFSET		3
#define	REQ_RES_ERR_DATA_OFFSET		3
#define REQ_RES_ANS			0x05
#define	IFD_ON				1
#define	IFD_OFF				0
// CCIDPCSC:0027

#define T1_PROTOCOL_LENGTH 4
#define T1_PROTOCOL_HEADER 2
#define T1_PROTOCOL_FOOTER 2
