package jcifs.smb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Key;
import java.util.Iterator;

import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;

import jcifs.Config;
import jcifs.util.LogStream;

import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

import com.sun.security.jgss.ExtendedGSSContext;
import com.sun.security.jgss.InquireType;

// >>SmbAuthenticator
/**
 * This class used to provide Kerberos feature when setup GSSContext.
 * 
 * @author Shun
 */
class Kerb5Context {
	private static final String OID = "1.2.840.113554.1.2.2";
	private GSSContext gssContext;
	private static LogStream log = LogStream.getInstance();
	
	Kerb5Context(String host, String service, String name, int userLifetime, int contextLifetime) throws GSSException {
		GSSManager manager = GSSManager.getInstance();
		Oid oid = null;
		GSSName serviceName = null;
		GSSName clientName = null;
		GSSCredential clientCreds = null;

		oid = new Oid(OID);
		
		//This process stops TGS-REQ with domain name from DFS referral, which results in failure
		//and causes delivery delay. 
		
		//In JRE 7, an IP address, a domain name or FQDN (for alias) must be resolved.
		//In JRE 6 or below, this process was done in JRE library.
		
		if (log.level == 6) {
			log.println("before canonicalize : " + host);
		}
		
		if(Config.getBoolean( "jcifs.smb.client.canonicalize", true )){
			try {
				host = (InetAddress.getByName(host)).getCanonicalHostName();
			} catch (UnknownHostException e) {
				if (log.level == 6) {
					e.printStackTrace(log);
				}
			}
		}
		
		if (log.level == 6) {
			log.println("after canonicalize : " + host);
		}
		
		serviceName = manager.createName(service + "@" + host, GSSName.NT_HOSTBASED_SERVICE, oid);
		if (name != null) {
			clientName = manager.createName(name, GSSName.NT_USER_NAME, oid);
			clientCreds = manager.createCredential(clientName, userLifetime, oid, GSSCredential.INITIATE_ONLY);
		}
		gssContext = manager.createContext(serviceName, oid, clientCreds, contextLifetime);
	}

	GSSContext getGSSContext() {
		return gssContext;
	}

	Key searchSessionKey(Subject subject) throws GSSException {
		MIEName src = new MIEName(gssContext.getSrcName().export());
		MIEName targ = new MIEName(gssContext.getTargName().export());
		Iterator iter = subject.getPrivateCredentials(KerberosTicket.class).iterator();
		while (iter.hasNext()) {
			KerberosTicket ticket = (KerberosTicket) iter.next();
			MIEName client = new MIEName(gssContext.getMech(), ticket.getClient().getName());
			MIEName server = new MIEName(gssContext.getMech(), ticket.getServer().getName());
			if (src.equals(client) && targ.equals(server)) {
				return ticket.getSessionKey();
			}
		}
		return null;
	}

	public void dispose() throws GSSException {
		if (gssContext != null) {
			gssContext.dispose();
		}
	}

	// Customization to get a session key with Java 7
	Key searchSessionKey() throws GSSException {
		if (gssContext instanceof ExtendedGSSContext) {
			ExtendedGSSContext ex = (ExtendedGSSContext) gssContext;
			Key key = (Key) ex.inquireSecContext(InquireType.KRB5_GET_SESSION_KEY);
			return key;
		}
		return null;
	}
}
// SmbAuthenticator<<
