package jp.co.ricoh.dsdk.util.usb;

import java.util.List;

import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbServices;

import com.ibm.jusb.UsbInterfaceImp;

/**
 * Special utility methods for Ricoh's devices.
 */
public class JavaxUsbUtil {

	private static boolean tracing = false;
	
	/**
	 * <p>
	 *  Closes all connections. (Disconnects all connected devices.)
	 * <p>
	 *  When the obtained data is invalid, call this method before retrying the data obtainment.
	 * @deprecated  Not for public use in the future. 
	 * This method is expected to be retained only as a package private method. 
	 * {@link #reset(UsbInterface)}
	 */
	public static void reset(){
		UsbServices services;
		UsbHub rootHub = null;
		try {
			services = UsbHostManager.getUsbServices();
			rootHub = services.getRootUsbHub();					
		} catch (SecurityException e) {
			if(tracing){
				System.out.println("[SDK_N_JXUSB]SecurityException occurs");
				e.printStackTrace();
			}
		} catch (UsbException e) {
			if(tracing){
				System.out.println("[SDK_N_JXUSB]UsbException occurs");
				e.printStackTrace();
			}
		}
		traverse(rootHub);
	}

	/**
	 * <p>
	 *  Closes specified connection. (Disconnects one connected device.) 
	 * <p>
	 *  When the obtained data is invalid, call this method before retrying the data obtainment.
	 * @exception UsbException if the error occurs.
	 * @exception UsbNotActiveException if the interface setting is not active.
	 * @exception UsbDisconnectedException If this device has been disconnected.
	 */
	public static void reset(UsbInterface usbInterface) throws UsbException, UsbNotActiveException, UsbDisconnectedException {
		((UsbInterfaceImp)usbInterface).reset();
	}

	private static byte[] traverse(UsbDevice device) {
		UsbDeviceDescriptor udd = device.getUsbDeviceDescriptor();
		if(tracing){
			System.out.println("[SDK_N_JXUSB]device descriptor = " + udd);
		}

		if (device.isUsbHub()) {
			List attachedDevices = ((UsbHub) device).getAttachedUsbDevices();
			for (int i = 0; i < attachedDevices.size(); i++) {
				traverse((UsbDevice) attachedDevices.get(i));
			}
		}else{
			UsbConfiguration ucf = device.getActiveUsbConfiguration();
			if (ucf != null) { // if conf is null get the interface
				UsbInterface ui = ucf.getUsbInterface((byte)0);
				if(ui != null){
					try {
						JavaxUsbUtil.reset(ui);
					} catch (UsbNotActiveException e) {
						if(tracing){
							System.out.println("[SDK_N_JXUSB]UsbNotActiveException occurs");
							e.printStackTrace();
						}
					} catch (UsbDisconnectedException e) {
						if(tracing){
							System.out.println("[SDK_N_JXUSB]UsbDisconnectedException occurs");
							e.printStackTrace();
						}
					} catch (UsbException e) {
						if(tracing){
							System.out.println("[SDK_N_JXUSB]UsbException occurs");
							e.printStackTrace();
						}
					}
				}else{
					if(tracing){
						System.out.println("[SDK_N_JXUSB]ui == null");
					}
				}
			}else{
				if(tracing){
					System.out.println("[SDK_N_JXUSB]ucf == null");
				}
			}
			
		}
		return null;
	}

	public static void setTracing(boolean log) {
		JavaxUsbUtil.tracing = log;
	}
}
