/*
 * Copyright (C) 2007 RICOH Co.,LTD.
 * All rights reserved.
 *
 * Department   :  3rd�@Development Section
 *                 2nd  Development Department
 *                 DSS  Development Center
 *                 DS&S (Document Solutions & Service) Division
 *
 * Purpose      :  RiMAP Software Development Kit
 *
 * $Name: not supported by cvs2svn $
 * $Date: 2009-04-16 03:59:37 $
 */

#ifndef _UHCOMM_DEF_H_
#define _UHCOMM_DEF_H_

/*
 * uhcomm parameters (to communicate with usbhd)
 */
#define UHCOMM_PNAME_PCSC 		"pcsc"				/* application name (notify to usbhd) */
#define UHCOMM_PNAME_JAVAXUSB 	"javaxusb"		/* application name (notify to usbhd) */
#define UHCOMM_PNAME_MAX 		16
#define UHCOMM_RETRY_INTERVAL 	2	/* communication retry interval */
#define UHCOMM_RETRY_LIMIT 		30	/* communication retry limit */



/*
 * log func
 */
#ifdef UHCOMM_DEBUG
/* debug log */
 #define UHCOMM_LOG_CRITICAL 	1
 #define UHCOMM_LOG_ERROR 	 	2
 #define UHCOMM_LOG_WARNING 	3
 #define UHCOMM_LOG_INFO 		4
 #define UHCOMM_LOG_DETAIL 		5
 #define UHCOMM_LOG_FUNC 		6
 #define UHCOMM_LOG_MUTEX 		7
 #define UHCOMM_LOG_OTHER 		8

 #include <stdio.h>
 #include <stdlib.h>

 #define UHCOMM_LOG_LEN 		128
 #define UHCOMM_LOG(level,args...) 	do { \
	char buf_def[UHCOMM_LOG_LEN], *buf = buf_def, *r_buf = NULL; \
	int ln; \
	ln = snprintf(buf, UHCOMM_LOG_LEN, args); \
	if (0 > ln || UHCOMM_LOG_LEN < ln) { \
	if ((r_buf = malloc(UHCOMM_LOG_LEN * 2))) { \
		buf = r_buf; \
		ln = snprintf(buf, UHCOMM_LOG_LEN * 2, args); \
	} \
	} \
	if (level <= UHCOMM_DEBUG) { \
	char* type;\
	switch(level) {\
	case 1: type = "critical";	break; \
	case 2: type = "error";	break; \
	case 3: type = "warning";	break; \
	case 4: type = "info";	break; \
	case 5: type = "detail";	break; \
	case 6: type = "func";	break; \
	case 7: type = "mutex";	break; \
	case 8: type = "other";	break; \
	default: type = "unknown";; break; \
	} \
	printf("[%s] %s(%d) %s(), %s\n", type, __FILE__, __LINE__, __FUNCTION__, buf); \
	} \
	if (r_buf) free(r_buf); \
	} while (0)

#else
/* javax.usb log */
 #include "JavaxUsbLog.h"
 #define UHCOMM_LOG_CRITICAL 	LOG_HOTPLUG_CRITICAL
 #define UHCOMM_LOG_ERROR 	 	LOG_HOTPLUG_ERROR
 #define UHCOMM_LOG_WARNING 	LOG_HOTPLUG_CHANGE
 #define UHCOMM_LOG_INFO 		LOG_HOTPLUG_CHANGE
 #define UHCOMM_LOG_DETAIL 		LOG_HOTPLUG_DEVICE
 #define UHCOMM_LOG_FUNC 		LOG_HOTPLUG_OTHER
 #define UHCOMM_LOG_MUTEX 		LOG_HOTPLUG_OTHER
 #define UHCOMM_LOG_OTHER		LOG_HOTPLUG_OTHER

 #define UHCOMM_LOG(level, args...) 	log(level, ##args)
#endif


/*
 * rename func (for lower module bug...)
 */
#include <string.h>
#ifdef UHCOMM_NO_TRIM_DEVNAME
#define uhcomm_trim_udev_name(src, dest, n) 	memcpy(dest, src, n)
#else
void uhcomm_trim_udev_name(char* src, char* dest, size_t n) {

	int i = 0;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	memcpy(dest, src, n);

	for (i = 0; i < n; i++) {
		if (dest[i] >= '0' && dest[i] <= '9') {
			while (i < n) {
				i++;
				if (dest[i] < '0' || dest[i] > '9') {
					break;
				}
			}
			memset(dest + i, '\0', n - i);
			break;
		}
	}
};
#endif


#endif
