
/** 
 * Copyright (c) 1999 - 2001, International Business Machines Corporation.
 * All Rights Reserved.
 *
 * This software is provided and licensed under the terms and conditions
 * of the Common Public License:
 * http://oss.software.ibm.com/developerworks/opensource/license-cpl.html
 */

#include "JavaxUsb.h"

#include "JavaxUsbUhCommunicator.h"
//static inline int build_device( JNIEnv *env, jclass JavaxUsb, jobject linuxUsbServices, unsigned char bus, unsigned char dev,
//	jobject parent, int parentport, jobject connectedDevices, jobject disconnectedDevices );
//static inline int build_config( JNIEnv *env, jclass JavaxUsb, int fd, jobject device, unsigned char bus, unsigned char dev );

//static inline jobject build_interface( JNIEnv *env, jclass JavaxUsb, int fd, jobject config, struct jusb_interface_descriptor *if_desc, unsigned char bus, unsigned char dev );

//static inline void build_endpoint( JNIEnv *env, jclass JavaxUsb, jobject interface, struct jusb_endpoint_descriptor *ep_desc );

//static inline void *get_descriptor( JNIEnv *env, int fd );

static inline int build_device( JNIEnv *env, jclass JavaxUsb, jobject linuxUsbServices, int bus, int addr, int lowspeed,
	jobject parent, int parentport, jobject connectedDevices, jobject disconnectedDevices, usb_device_info_list_t* udilist, int rootflag );

static inline int build_config( JNIEnv *env, jclass JavaxUsb, int fd, jobject device, int bus, int addr, int ncfg);

static inline jobject build_interface( JNIEnv *env, jclass JavaxUsb, int fd, jobject config, struct usb_interface_desc uid, int bus, int addr );

static inline void build_endpoint( JNIEnv *env, jclass JavaxUsb, jobject interface, struct usb_endpoint_desc ued);

//added by kawakubo	
//static int select_usbfs(const struct dirent *entry);

int try_ioctl(int fd, int request, void* output);
int get_root_list(usb_device_info_list_t* udilist, root_list* rootlist );
int	search_udi(usb_device_info_list_t* udilist, int bus, int addr, int lowspeed, struct usb_device_info* udi, int rootflag );

/* print */
void display_info_list (usb_device_info_list_t* list);
void display_device_info (struct usb_device_info* info);

/**
 * Update topology tree
 * @author Dan Streetman
 */
JNIEXPORT jint JNICALL Java_com_ibm_jusb_os_linux_JavaxUsb_nativeTopologyUpdater
			( JNIEnv *env, jclass JavaxUsb, jobject linuxUsbServices, jobject connectedDevices, jobject disconnectedDevices )
{
	//added by kawakubo
//	int busses, port, devices = 0;
	int port, devices = 0;
	//int bus = 0;
	//struct dirent **buslist = NULL;
	int i = 0;
	int ur = 0;
	usb_device_info_list_t* udilist = NULL;
  	//bus_list *buslist = NULL;
  	root_list *rootlist = NULL;

	jclass LinuxUsbServices = CheckedGetObjectClass( env, linuxUsbServices );
	jmethodID getRootUsbHubImp = CheckedGetMethodID( env, LinuxUsbServices, "getRootUsbHubImp", "()Lcom/ibm/jusb/UsbHubImp;" );
	jobject rootHub = CheckedCallObjectMethod( env, linuxUsbServices, getRootUsbHubImp );
	CheckedDeleteLocalRef( env, LinuxUsbServices );

	if (0 > (*env)->EnsureLocalCapacity(env, 40)) {
		log( LOG_CRITICAL, "Could not reserve enough local references, Out of Memory!");
		return -ENOMEM;
	}

 	if (!rootHub) {
		log( LOG_ERROR, "Could not get rootHub!");
		return -EINVAL;
	}

	//Get the usb topology information.
	for (i = 0; i < 3; i++) {
		udilist = NULL;
		ur = uhcomm_get_plugged_list(&udilist);
		if (ur != UHCOMM_NORMAL && ur != UHCOMM_INIT_BUSY) {
			log( LOG_ERROR, "uhcomm_get_plugged_list() returned NG:%d.", ur);
			CheckedDeleteLocalRef( env, rootHub );
			return 0;
		}
		if (udilist == NULL) {
			log( LOG_DEBUG, "uhcomm_get_plugged_list() returned NULL list.");
			sleep(5);
			continue;
		}
	}

	if(udilist == NULL){
		log( LOG_ERROR, "uhcomm_get_plugged_list() returned NULL list.");
		CheckedDeleteLocalRef( env, rootHub );
		return 0;	
	}

	display_info_list(udilist);
	
	//added by kawakubo
//	buslist = (bus_list *)malloc(sizeof(bus_list));
//	buslist->num = 0;
	
	rootlist = (root_list *)malloc(sizeof(root_list));
  	rootlist->num = 0;

	errno = 0;
	//get_bus_list(udilist, buslist);
	get_root_list(udilist, rootlist);

//added by kawakubo
//	if (0 > (busses = scandir(USBDEVFS_PATH, &buslist, select_usbfs, alphasort)) ) {
//		log( LOG_ERROR, "Could not access %s : %s", USBDEVFS_PATH, strerror(errno) );
//		return -errno;
//	}

//	for (port=0; port<busses; port++) {
//	for (port=0; port < buslist->num; port++) {
	for (port=0; port < rootlist->num; port++) {
	//struct dirent **devlist = NULL;
		//int bus, hcAddress, devs;
		//int busdir_len = strlen(USBDEVFS_PATH) + strlen(buslist[port]->d_name) + 2;
		//char busdir[busdir_len];

		//sprintf(busdir, "%s/%s", USBDEVFS_PATH, buslist[port]->d_name);
		//bus = atoi( buslist[port]->d_name );
		//bus = buslist->bus[port];

		//errno = 0;
		//devs = scandir(busdir, &devlist, select_usbfs, alphasort);
		//if (0 > devs) {
		//	log( LOG_ERROR, "Could not access device nodes in %s : %s", busdir, strerror(errno) );
		//} else if (!devs) {
		//	log( LOG_ERROR, "No device nodes found in %s : %s", busdir, strerror(errno) );
		//} else {
			/* Hopefully, the host controller has the lowest numbered address on this bus! */
			//added by kawakubo
			//hcAddress = atoi( devlist[0]->d_name );
			//devices += build_device( env, JavaxUsb, linuxUsbServices, bus, hcAddress, rootHub, port, connectedDevices, disconnectedDevices );

		/* Hopefully, the host controller has the lowest numbered address on this bus! */
		//devices += build_device( env, JavaxUsb, linuxUsbServices, bus, 1, rootHub, bus, connectedDevices, disconnectedDevices, udilist);
		devices += build_device( env, JavaxUsb, linuxUsbServices, rootlist->root[port].bus, rootlist->root[port].addr, rootlist->root[port].lowspeed, rootHub, port, connectedDevices, disconnectedDevices, udilist, 1);

		//	}

		//while (0 < devs) free(devlist[--devs]);
		//if (devlist) free(devlist);

		//free(buslist[port]);
	}

//	free(buslist);
	free(rootlist);
	uhcomm_release_plugged_list(udilist);
	if (rootHub) CheckedDeleteLocalRef( env, rootHub );

	return 0;
}

static inline int build_device( JNIEnv *env, jclass JavaxUsb, jobject linuxUsbServices, int bus, int addr, int lowspeed,
	jobject parent, int parentport, jobject connectedDevices, jobject disconnectedDevices, usb_device_info_list_t* udilist, int rootflag)
{
	int fd = 0, port, ncfg;
	int devices = 0, speed = SPEED_UNKNOWN;
//added by kawakubo
//	struct usbdevfs_ioctl *usbioctl = NULL;
//	struct usbdevfs_hub_portinfo *portinfo = NULL;
//	struct usbdevfs_connectinfo *connectinfo = NULL;
//	struct jusb_device_descriptor *dev_desc = NULL;
	usb_device_descriptor_t udd;
	struct usb_device_info udi;
	char node[100];
	char key[100];
	int res = 0;
	jboolean exist = JNI_TRUE;

	jobject device = NULL, existingDevice = NULL;
	jstring keyString = NULL;

	jclass LinuxUsbServices = CheckedGetObjectClass( env, linuxUsbServices );
	jmethodID createUsbHubImp = CheckedGetStaticMethodID( env, JavaxUsb, "createUsbHubImp", "(Ljava/lang/String;II)Lcom/ibm/jusb/UsbHubImp;" );
	jmethodID createUsbDeviceImp = CheckedGetStaticMethodID( env, JavaxUsb, "createUsbDeviceImp", "(Ljava/lang/String;I)Lcom/ibm/jusb/UsbDeviceImp;" );
	jmethodID configureUsbDeviceImp = CheckedGetStaticMethodID( env, JavaxUsb, "configureUsbDeviceImp", "(Lcom/ibm/jusb/UsbDeviceImp;BBBBBBBBBBSSSSI)V" );
	jmethodID checkUsbDeviceImp = CheckedGetMethodID( env, LinuxUsbServices, "checkUsbDeviceImp", "(Lcom/ibm/jusb/UsbHubImp;ILcom/ibm/jusb/UsbDeviceImp;Ljava/util/List;Ljava/util/List;)Lcom/ibm/jusb/UsbDeviceImp;" );
	jmethodID checkUsbDeviceImpCookie = CheckedGetMethodID( env, LinuxUsbServices, "checkUsbDeviceImpCookie", "(Lcom/ibm/jusb/UsbHubImp;ILcom/ibm/jusb/UsbDeviceImp;Ljava/util/List;Ljava/util/List;)Z" );
	CheckedDeleteLocalRef( env, LinuxUsbServices );

	res = search_udi(udilist, bus, addr, lowspeed, &udi, rootflag);
	if(res < 0){
		log( LOG_ERROR, "udi_list doesn't have the target device.");
		return 0;
	}
	
	if(udi.lowspeed == 0x01){
		speed = SPEED_LOW;
	}else if(udi.lowspeed == 0x02){
		speed = SPEED_FULL;
	}
		//added by kawakubo
//	sprintf(node, "%s/%03d/%03d", USBDEVFS_PATH, (0xff&bus), (0xff&dev));
	sprintf(key, "%s%s", USBDEVFS_PATH, udi.devnames[0]);
	sprintf(node, "%s.%.2d", key, 0);

	keyString = CheckedNewStringUTF( env, key );

//	if (dev_desc->bDeviceClass == USB_CLASS_HUB) {
	if(udi.class == UICLASS_HUB){
//added by kawakubo
//		usbioctl = malloc(sizeof(*usbioctl));
//		portinfo = malloc(sizeof(*portinfo));
//		usbioctl->ioctl_code = USBDEVFS_HUB_PORTINFO;
//		usbioctl->ifno = 0;
//		usbioctl->data = portinfo;
//		errno = 0;
//		if (0 >= ioctl( fd, USBDEVFS_IOCTL, usbioctl )) {
//			log( LOG_ERROR, "Could not get portinfo from hub, error = %d", errno );
//			goto BUILD_DEVICE_EXIT;
//		} else {
//		  log( LOG_HOTPLUG_DEVICE, "Device is hub with %d ports",portinfo->nports );
		  log( LOG_HOTPLUG_DEVICE, "Device is hub with %d ports",udi.nports );
//		}
//		free(usbioctl);
//		usbioctl = NULL;
//		device = CheckedCallStaticObjectMethod( env, JavaxUsb, createUsbHubImp, keyString, portinfo->nports );
		  device = CheckedCallStaticObjectMethod( env, JavaxUsb, createUsbHubImp, keyString, udi.cookie.cookie, udi.nports );

		udd.bLength = 0x12; 
		udd.bDescriptorType = 0x01;
		//udd.bDeviceClass = UDCLASS_HUB; 
		//udd.bDeviceSubClass = 0x00; 
		//udd.bDeviceProtocol = 0x00;
		udd.bMaxPacketSize = 0x00; 
		udd.iManufacturer = 0x00; 
		udd.iProduct = 0x00; 
		udd.iSerialNumber = 0x00;
		udd.bNumConfigurations = 0x00; 
		//udd.idVendor[0] = 0x00;
		//udd.idVendor[1] = 0x00; 
		//udd.idProduct[0] = 0x00; 
		//udd.idProduct[1] = 0x00; 
		//udd.bcdDevice[0] = 0x00; 
		//udd.bcdDevice[1] = 0x00; 
		udd.bcdUSB[0] = 0x00; 
		udd.bcdUSB[1] = 0x00; 
//			speed = SPEED_LOW;
		CheckedCallStaticVoidMethod( env, JavaxUsb, configureUsbDeviceImp, device, 
			udd.bLength, udd.bDescriptorType,
			udi.class, udi.subclass, udi.protocol,
			udd.bMaxPacketSize, udd.iManufacturer, udd.iProduct, udd.iSerialNumber,
			udd.bNumConfigurations, udi.vendorNo, udi.productNo,
			udi.releaseNo, uWordTou_int16_t(udd.bcdUSB), speed );		
		existingDevice = CheckedCallObjectMethod( env, linuxUsbServices, checkUsbDeviceImp, parent, parentport+1, device, connectedDevices, disconnectedDevices );
		CheckedDeleteLocalRef( env, device );
		device = existingDevice;
	} else {//The usb device isn't hub.
		device = CheckedCallStaticObjectMethod( env, JavaxUsb, createUsbDeviceImp, keyString, udi.cookie.cookie );
		//Check whether the usb device has already existed or not.
		exist = CheckedCallBooleanMethod( env, linuxUsbServices, checkUsbDeviceImpCookie, parent, parentport+1, device, connectedDevices, disconnectedDevices );
		if(exist == JNI_FALSE){
			log( LOG_HOTPLUG_DEVICE, "Building device %s", node );
		//added by kawakubo
		//	fd = open( node, O_RDWR );
			fd = open( node, O_RDONLY);
			if ( 0 >= fd ) {
				log( LOG_ERROR, "Could not access %s", node );
				goto BUILD_DEVICE_EXIT;
			}
		//added by kawakubo
		//	if (!(dev_desc = get_descriptor( env, fd ))) {
			if (try_ioctl(fd, USB_GET_DEVICE_DESC, &udd) < 0) {
				log( LOG_ERROR, "Could not get device descriptor." );
				goto BUILD_DEVICE_EXIT;
			}

		//	connectinfo = malloc(sizeof(*connectinfo));
		//	errno = 0;
		//	if (0 > (ioctl( fd, USBDEVFS_CONNECTINFO, connectinfo ))) {
		//		log( LOG_ERROR, "Could not get connectinfo from device, error = %d", errno );
		//		goto BUILD_DEVICE_EXIT;
		//	} else {
		//	log( LOG_HOTPLUG_OTHER, "Device speed is %s", (connectinfo->slow?"1.5 Mbps":"12 Mbps") );
		//	}
		//	speed = ( connectinfo->slow ? SPEED_LOW : SPEED_FULL );
		//	free(connectinfo);
		//	connectinfo = NULL;


		//added by kawakubo
		//	CheckedCallStaticVoidMethod( env, JavaxUsb, configureUsbDeviceImp, device, 
		//		dev_desc->bLength, dev_desc->bDescriptorType,
		//		dev_desc->bDeviceClass, dev_desc->bDeviceSubClass, dev_desc->bDeviceProtocol,
		//		dev_desc->bMaxPacketSize0, dev_desc->iManufacturer, dev_desc->iProduct, dev_desc->iSerialNumber,
		//		dev_desc->bNumConfigurations, dev_desc->idVendor, dev_desc->idProduct,
		//		dev_desc->bcdDevice, dev_desc->bcdUSB, speed );
			CheckedCallStaticVoidMethod( env, JavaxUsb, configureUsbDeviceImp, device, 
					udd.bLength, udd.bDescriptorType,
					udd.bDeviceClass, udd.bDeviceSubClass, udd.bDeviceProtocol,
					udd.bMaxPacketSize, udd.iManufacturer, udd.iProduct, udd.iSerialNumber,
					udd.bNumConfigurations, uWordTou_int16_t(udd.idVendor), uWordTou_int16_t(udd.idProduct),
					uWordTou_int16_t(udd.bcdDevice), uWordTou_int16_t(udd.bcdUSB), speed );

			/* Build config descriptors */
			for (ncfg=0; ncfg < udd.bNumConfigurations; ncfg++) {
				if (build_config( env, JavaxUsb, fd, device, bus, addr, ncfg )) {
					log( LOG_ERROR, "Could not get config %d for device %d", ncfg, addr );
					goto BUILD_DEVICE_EXIT;
				}
			}
			existingDevice = CheckedCallObjectMethod( env, linuxUsbServices, checkUsbDeviceImp, parent, parentport+1, device, connectedDevices, disconnectedDevices );
			CheckedDeleteLocalRef( env, device );
			device = existingDevice;

			/* This device is set up and ready! */
			close( fd );
			fd = 0;
		}else{
			log( LOG_DEBUG, "The usb device has already existed. %s : %d : %d", node, udi.cookie.cookie, addr );
			CheckedDeleteLocalRef( env, device );
		}
	}

	/* This device is set up and ready! */
	devices = 1;

	//if ((dev_desc->bDeviceClass == USB_CLASS_HUB) && portinfo)
	//	for (port=0; port<(portinfo->nports); port++)
	//		if (portinfo->port[port]) {
	//			log( LOG_HOTPLUG_OTHER, "Building device %d attached to port %d", portinfo->port[port], port);
	//			devices += build_device( env, JavaxUsb, linuxUsbServices, bus, portinfo->port[port], device, port, connectedDevices, disconnectedDevices );
	//		}
	if((udi.class == UICLASS_HUB) && (udi.nports > 0)){
		for (port = 0; port < udi.nports; port++){
			if(udi.ports[port] < USB_MAX_DEVICES){
				log( LOG_HOTPLUG_OTHER, "Building device %d attached to port %d", udi.ports[port], port);
				if(addr == 1){
					devices += build_device( env, JavaxUsb, linuxUsbServices, bus, udi.ports[port], udi.lowspeed, device, port, connectedDevices, disconnectedDevices, udilist, 1);
				}else{
					devices += build_device( env, JavaxUsb, linuxUsbServices, bus, udi.ports[port], udi.lowspeed, device, port, connectedDevices, disconnectedDevices, udilist, 0);
				}
			}
		}
	}


BUILD_DEVICE_EXIT:
	if (fd) close(fd);
	if (device) CheckedDeleteLocalRef( env, device );
//	if (connectinfo) free(connectinfo);
//	if (dev_desc) free(dev_desc);
//	if (usbioctl) free(usbioctl);
//	if (portinfo) free(portinfo);
	if (keyString) CheckedDeleteLocalRef( env, keyString );

	return devices;
}

static inline int build_config( JNIEnv *env, jclass JavaxUsb, int fd, jobject device, int bus, int addr, int ncfg)
{
	int result = -1;
	int i,j;
//	struct jusb_config_descriptor *cfg_desc = NULL;
	struct usb_config_desc ucd;
	struct usb_alt_interface uai;
	struct usb_interface_desc uid;
	struct usb_endpoint_desc ued;
//added by kawakubo
//	unsigned char *desc = NULL;
	unsigned short wTotalLength;
	unsigned int pos;
	jobject config = NULL, interface = NULL;
	jmethodID createUsbConfigurationImp;

	int try_count = 0;
	
//	if (!(cfg_desc = get_descriptor( env, fd ))) {
	ucd.config_index = ncfg;
	if (try_ioctl(fd, USB_GET_CONFIG_DESC, &ucd) < 0) {
		log( LOG_ERROR, "Could not get config desriptor." );
		goto BUILD_CONFIG_EXIT;
	}

	createUsbConfigurationImp = CheckedGetStaticMethodID( env, JavaxUsb, "createUsbConfigurationImp", "(Lcom/ibm/jusb/UsbDeviceImp;BBSBBBBB)Lcom/ibm/jusb/UsbConfigurationImp;" );

	log( LOG_HOTPLUG_OTHER, "Building config %d", ucd.desc.bConfigurationValue );
//added by kawakubo
//	wTotalLength = cfg_desc->.wTotalLength;
//	pos = cfg_desc->.bLength;
//	config = CheckedCallStaticObjectMethod( env, JavaxUsb, createUsbConfigurationImp, device,
//		cfg_desc->bLength, cfg_desc->bDescriptorType, wTotalLength,
//		cfg_desc->bNumInterfaces, cfg_desc->bConfigurationValue, cfg_desc->iConfiguration,
//		cfg_desc->bmAttributes, cfg_desc->bMaxPower );
	wTotalLength = uWordTou_int16_t(ucd.desc.wTotalLength);
	pos = ucd.desc.bLength;
	config = CheckedCallStaticObjectMethod( env, JavaxUsb, createUsbConfigurationImp, device,
		ucd.desc.bLength, ucd.desc.bDescriptorType, wTotalLength,
		ucd.desc.bNumInterface, ucd.desc.bConfigurationValue, ucd.desc.iConfiguration,
		ucd.desc.bmAttributes, ucd.desc.bMaxPower );


	//added by kawakubo
//	while (pos < wTotalLength) {
//		desc = get_descriptor( env, fd );
//		if ((!desc) || (2 > desc[0])) {
//			log( LOG_ERROR, "Short read on descriptor" );
//			goto BUILD_CONFIG_EXIT;
//		}
//		pos += desc[0];
//		switch( desc[1] ) {
//			case USB_DT_DEVICE:
//				log( LOG_ERROR, "Got device descriptor inside of config descriptor" );
//				goto BUILD_CONFIG_EXIT;
//
//			case USB_DT_CONFIG:
//				log( LOG_ERROR, "Got config descriptor inside of config descriptor" );
//				goto BUILD_CONFIG_EXIT;
//
//			case USB_DT_INTERFACE:
//				if (interface) CheckedDeleteLocalRef( env, interface );
//				interface = build_interface( env, JavaxUsb, fd, config, (struct jusb_interface_descriptor*)desc, bus, dev );
//				break;
//
//			case USB_DT_ENDPOINT:
//				build_endpoint( env, JavaxUsb, interface, (struct jusb_endpoint_descriptor*)desc );
//				break;
//
//			default:
//				/* Ignore proprietary descriptor */
//				break;
//		}
//		free(desc);
//		desc = NULL;
//	}
	for(i = 0; i < ucd.desc.bNumInterface ; i++){
		//get alternate setting
		uai.config_index = ncfg;//The config_index is ignored in this call.
		uai.interface_index = i;

		errno = 0;
		try_count = 0;
		if (try_ioctl(fd, USB_GET_ALTINTERFACE, &uai) < 0) {
			log( LOG_ERROR, "Could not get alter interface.");
			goto BUILD_CONFIG_EXIT;
		}

		//get interface descriptor
		uid.config_index = ncfg;
		uid.interface_index =i;
		uid.alt_index = uai.alt_no;
		errno = 0;
		
		//Sometimes false the function.So,adding the loop function.
		if (try_ioctl(fd, USB_GET_INTERFACE_DESC, &uid) < 0) {
			log( LOG_ERROR, "Could not get interface descriptor.");
			goto BUILD_CONFIG_EXIT;
		}

		if (interface) CheckedDeleteLocalRef( env, interface );
			interface = build_interface( env, JavaxUsb, fd, config, uid, bus, addr );
		
		//get endopoint descriptor
		ued.config_index = ncfg;
		ued.interface_index =i;
		ued.alt_index = uai.alt_no;
		for(j = 0; j < uid.desc.bNumEndpoints ; j++){
			ued.endpoint_index = j;
			if(try_ioctl(fd, USB_GET_ENDPOINT_DESC, &ued) < 0) {
				log( LOG_ERROR, "Could not get endpoint descriptor.");
				goto BUILD_CONFIG_EXIT;
			}
			
			build_endpoint( env, JavaxUsb, interface, ued );
		}
	}
	result = 0;

BUILD_CONFIG_EXIT:
	if (config) CheckedDeleteLocalRef( env, config );
	if (interface) CheckedDeleteLocalRef( env, interface );
//added by kawakubo
//	if (cfg_desc) free(cfg_desc);
//	if (desc) free(desc);

	return result;
}

//added by kawakubo
//static inline jobject build_interface( JNIEnv *env, jclass JavaxUsb, int fd, jobject config, struct jusb_interface_descriptor *if_desc, unsigned char bus, unsigned char dev )
static inline jobject build_interface( JNIEnv *env, jclass JavaxUsb, int fd, jobject config, struct usb_interface_desc uid, int bus, int addr )
{
	jobject interface;

	jmethodID createUsbInterfaceImp = CheckedGetStaticMethodID( env, JavaxUsb, "createUsbInterfaceImp", "(Lcom/ibm/jusb/UsbConfigurationImp;BBBBBBBBB)Lcom/ibm/jusb/UsbInterfaceImp;" );

	log( LOG_HOTPLUG_OTHER, "Building interface %d", uid.desc.bInterfaceNumber );
//added by kawakubo
//	interface = CheckedCallStaticObjectMethod( env, JavaxUsb, createUsbInterfaceImp, config,
//		if_desc->bLength, if_desc->bDescriptorType,
//		if_desc->bInterfaceNumber, if_desc->bAlternateSetting, if_desc->bNumEndpoints, if_desc->bInterfaceClass,
//		if_desc->bInterfaceSubClass, if_desc->bInterfaceProtocol, if_desc->iInterface );
	interface = CheckedCallStaticObjectMethod( env, JavaxUsb, createUsbInterfaceImp, config,
		uid.desc.bLength, uid.desc.bDescriptorType,
		uid.desc.bInterfaceNumber, uid.desc.bAlternateSetting, uid.desc.bNumEndpoints, uid.desc.bInterfaceClass,
		uid.desc.bInterfaceSubClass, uid.desc.bInterfaceProtocol, uid.desc.iInterface );

	return interface;
}
//added by kawakubo
//static inline void build_endpoint( JNIEnv *env, jclass JavaxUsb, jobject interface, struct jusb_endpoint_descriptor *ep_desc )
static inline void build_endpoint( JNIEnv *env, jclass JavaxUsb, jobject interface, struct usb_endpoint_desc ued)
{
	jmethodID createUsbEndpointImp = CheckedGetStaticMethodID( env, JavaxUsb, "createUsbEndpointImp", "(Lcom/ibm/jusb/UsbInterfaceImp;BBBBBS)Lcom/ibm/jusb/UsbEndpointImp;" );

	log( LOG_HOTPLUG_OTHER, "Building endpoint 0x%2.02x", ued.desc.bEndpointAddress );

	if (!interface) {
		log( LOG_ERROR, "Interface is NULL");
		return;
	}
//added by kawakubo
//	CheckedCallStaticObjectMethod( env, JavaxUsb, createUsbEndpointImp, interface,
//		ep_desc->bLength, ep_desc->bDescriptorType,
//		ep_desc->bEndpointAddress, ep_desc->bmAttributes, ep_desc->bInterval, ep_desc->wMaxPacketSize );
	CheckedCallStaticObjectMethod( env, JavaxUsb, createUsbEndpointImp, interface,
		ued.desc.bLength, ued.desc.bDescriptorType,
		ued.desc.bEndpointAddress, ued.desc.bmAttributes, ued.desc.bInterval, uWordTou_int16_t(ued.desc.wMaxPacketSize) );
}

//added by kawakubo
//static inline void *get_descriptor( JNIEnv *env, int fd )
//{
//	unsigned char *buffer = NULL, *len = NULL;
//	int nread;
//
//	len = malloc(1);
//	if (1 > read( fd, len, 1 )) {
//		log( LOG_ERROR, "Cannot read from file!" );
//		goto GET_DESCRIPTOR_EXIT;
//	}
//
//	if (*len == 0) {
//		log( LOG_ERROR, "Zero-length descriptor?" );
//		goto GET_DESCRIPTOR_EXIT;
//	}
//
//	buffer = malloc(*len);
//	buffer[0] = *len;
//	free(len);
//	len = NULL;
//
//	nread = read( fd, buffer+1, buffer[0]-1 );
//	if (buffer[0]-1 != nread) {
//		if (buffer[0]-1 > nread) log( LOG_ERROR, "Short read on file" );
//		else log( LOG_ERROR, "Long read on file" );
//		free(buffer);
//		buffer = NULL;
//	}
//
//GET_DESCRIPTOR_EXIT:
//	if (len) free(len);
//
//	return buffer;
//}
//
//static inline get_device_descriptor( JNIEnv *env, int fd, )
//{
//	if (ioctl(fd, USB_GET_DEVICE_DESC, &udd) < 0) {
//       	printf("ioctl USB_GET_DEVICE_DESC Error\n");
//		return ;
//	}
//
//
//	unsigned char *buffer = NULL, *len = NULL;
//	int nread;
//
//	len = malloc(1);
//	if (1 > read( fd, len, 1 )) {
//		log( LOG_ERROR, "Cannot read from file!" );
//		goto GET_DESCRIPTOR_EXIT;
//	}
//
//	if (*len == 0) {
//		log( LOG_ERROR, "Zero-length descriptor?" );
//		goto GET_DESCRIPTOR_EXIT;
//	}
//
//	buffer = malloc(*len);
//	buffer[0] = *len;
//	free(len);
//	len = NULL;
//
//	nread = read( fd, buffer+1, buffer[0]-1 );
//	if (buffer[0]-1 != nread) {
//		if (buffer[0]-1 > nread) log( LOG_ERROR, "Short read on file" );
//		else log( LOG_ERROR, "Long read on file" );
//		free(buffer);
//		buffer = NULL;
//	}
//
//GET_DESCRIPTOR_EXIT:
//	if (len) free(len);
//
//	return buffer;
//}

//added by kawakubo	
//static int select_usbfs(const struct dirent *entry)
//{
	//added by kawakubo
	///* This originally used entry->d_type, however Linux 2.4 doesn't implement d_type,
	// * and POSIX apparently doesn't define it either.  So let's just do name matching.
	// * Hope that doesn't change.
	// */
	//int n = atoi(entry->d_name);
	///* If the number conversion of the name is 1-999 and the name is 3 characters long (exactly),
	// * it's (hopefully) ok.  Technically, the number should be no larger than 127, but let's not get
	// * unnecessarily picky.
	// */
	//return (0 < n) && (n < 1000) && (3 == strlen(entry->d_name));
//}

int try_ioctl(int fd, int request, void* output)
{
	int try_count = 0;
	int ret = 0;
	errno = 0;
	while(1){
		if (ioctl(fd, request, output) < 0) {
			int errsv = USBERRNO;
			log( LOG_ERROR, "Could not get device information,request = %d. %d : %s", request, errsv, strerror(errsv));
			if(try_count < 3){
				usleep(500000);//500msec
				try_count++;
				continue;
			}else{
				int errsv = USBERRNO;
				ret = -errsv;
				log( LOG_ERROR, "ERROR:Could not get device information. %d : %s", errsv, strerror(errsv));
				break;
			}
		}else{
			break;
		}
	}
	return ret;
}

int get_root_list(usb_device_info_list_t* udilist, root_list* rootlist ){
	usb_device_info_list_t* udilist_temp = udilist;
	int res = 0;

	while (udilist_temp) {
		if(udilist_temp->info.addr == 1){
			rootlist->root[rootlist->num].bus = udilist_temp->info.bus;
			rootlist->root[rootlist->num].addr = udilist_temp->info.addr;
			rootlist->root[rootlist->num].lowspeed = udilist_temp->info.lowspeed;
			rootlist->num++;
		}
		udilist_temp = (usb_device_info_list_t*)udilist_temp->next;
	}
	return res;
}

int	search_udi(usb_device_info_list_t* udilist, int bus, int addr, int lowspeed, struct usb_device_info* udi, int rootflag)
{
	usb_device_info_list_t* udilist_temp = udilist;
	int res = 0;
	log( LOG_HOTPLUG_OTHER, "search_udi bus  = %d : addr = %d : lowspeed = %d : rootflag = %d ", bus, addr, lowspeed, rootflag);
	
	while (udilist_temp) {
		if((udilist_temp->info.bus == bus) && (udilist_temp->info.addr == addr)){
			if(udilist_temp->info.class == UICLASS_HUB){
				if(addr == 1){//for get roothub
					if(udilist_temp->info.lowspeed == lowspeed){
						*udi = udilist_temp->info;
						return res;
					}
				}else{
					if(rootflag == 1){//the parent device is roothub
						if(lowspeed == 3){
							if(udilist_temp->info.lowspeed == 3){
								*udi = udilist_temp->info;
								return res;
							}
						}else{
							if(udilist_temp->info.lowspeed < 3){
								*udi = udilist_temp->info;
								return res;
							}						
						}
					}else{
						*udi = udilist_temp->info;
						return res;
					}
				}
			}else{
				if(!(strncmp(udilist_temp->info.devnames[0], "ugen", 4))){//for umass
					if(rootflag == 1){//the parent device is roothub
						if(lowspeed == 3){
							if(udilist_temp->info.lowspeed == 3){
								*udi = udilist_temp->info;
								return res;
							}
						}else{
							if(udilist_temp->info.lowspeed < 3){
								*udi = udilist_temp->info;
								return res;
							}						
						}
					}else{
						*udi = udilist_temp->info;
						return res;
					}
				}
			}
		}
		udilist_temp = (usb_device_info_list_t*)udilist_temp->next;
	} 
	res = -1;
	return res;
}
	
void display_info_list (usb_device_info_list_t* list) {
	
	usb_device_info_list_t* info = list;
	while (info) {
		display_device_info(&(info->info));
		info = (usb_device_info_list_t*)info->next;
	} 
}

void display_device_info (struct usb_device_info* info) {
	int i = 0;
	log( LOG_HOTPLUG_OTHER,"------------ USB device Start------------");
	log( LOG_HOTPLUG_OTHER, "[bus:%d, addr:%d, cookie:%d, product:%d, vender:%d, release:%d, class:%d, subclass:%d, protocol:%d, config:%d, lowspeed:%d, power:%d, nports:%d, devname1:%s]",
		info->bus,
		info->addr,
		info->cookie.cookie,
		info->productNo,
		info->vendorNo,
		info->releaseNo,
		info->class,
		info->subclass,
		info->protocol,
		info->config,
		info->lowspeed,
		info->power,
		info->nports,
		info->devnames[0]);
	
	for (i = 0; i < info->nports; i++) {
		log(LOG_HOTPLUG_OTHER, "port%02d  : %03d\n", i+1, info->ports[i]);
	}

	log( LOG_HOTPLUG_OTHER,"------------ USB device End------------");
}
