package jp.co.ricoh.dsdk.util.usb;

/**
 * Copyright (c) 1999 - 2001, International Business Machines Corporation.
 * All Rights Reserved.
 *
 * This software is provided and licensed under the terms and conditions
 * of the Common Public License:
 * http://oss.software.ibm.com/developerworks/opensource/license-cpl.html
 */

import java.util.*;

/**
 * Interface to/from JNI.
 * @author Dan Streetman
 */
public class NativeJavaxUsb
{
	//*************************************************************************
	// Native methods

		//*********************************
		// Tracing/Logging methods

	/**
	 * Enable (or disable) tracing.
	 * @param enable If tracing of data should be enabled.
	 */
	static public native void nativeSetTracing(Class JavaxUsb, boolean enable);

	/**
	 * Enable (or disable) tracing of a certain type of data.
	 * @param enable If tracing of data should be enabled.
	 * @param type The type of data.
	 */
	static public native void nativeSetTraceType(Class JavaxUsb, boolean enable, String type);

	/**
	 * Set the level of tracing.
	 * @param level The level of tracing.
	 */
	static public native void nativeSetTraceLevel(Class JavaxUsb, int level);

	/**
	 * Set the trace output.
	 * @param output Where to output; 1=stdout, 2=stderr, 3=file.
	 * @param filename The filename (ignored if output != 3).
	 */
	static public native void nativeSetTraceOutput(Class JavaxUsb, int output, String filename);

		//*********************************
		// JavaxUsbTopologyUpdater methods

	/**
	 * Call the native function that updates the topology.
	 * @param services The LinuxUsbServices instance.
	 * @param list The List to fill with newly connected devices.
	 * @param list The List of currently connected devices, which still connected devices will be removed from.
	 * @return The error number if one occurred.
	 */
	static public native int nativeTopologyUpdater(Class JavaxUsb, Object services, List connected, List disconnected );

	/**
	 * Get the current active configuration number.
	 * @param device The LinuxDeviceOsImp.
	 * @return The active configuration number.
	 */
	static public native int nativeGetActiveConfigurationNumber(Class JavaxUsb,  Object device );

	/**
	 * Get the current active interface setting for the specified interface.
	 * @param device The LinuxDeviceOsImp.
	 * @param interfaceNumber The interface number to check.
	 * @return The active interface number.
	 */
	static public native int nativeGetActiveInterfaceSettingNumber(Class JavaxUsb,  Object device, int interfaceNumber );

		//*********************************
		// JavaxUsbTopologyListener methods

	/**
	 * Call the native function that listens for topology changes
	 * @param services The LinuxUsbServices instance.
	 * @return The error that caused the listener to exit.
	 */
	static public native int nativeTopologyListener(Class JavaxUsb,  Object services );

		//*********************************
		// JavaxUsbDeviceProxy methods

	/**
	 * Start a LinuxDeviceProxy
	 * @param io A LinuxInterfaceIO object
	 */
	static public native void nativeDeviceProxy(Class JavaxUsb,  Object proxy );

		//*********************************
		// JavaxUsbError methods

	/**
	 * @param error the error number
	 * @return the message associated with the specified error number
	 */
	static public native String nativeGetErrorMessage(Class JavaxUsb,  int error );


}
