/*
 * Copyright (C) 2007 RICOH Co.,LTD.
 * All rights reserved.
 *
 * Department   :  3rd@Development Section
 *                 2nd  Development Department
 *                 DSS  Development Center
 *                 DS&S (Document Solutions & Service) Division
 *
 * Purpose      :  RiMAP Software Development Kit
 *
 * $Name: not supported by cvs2svn $
 * $Date: 2009-04-16 03:59:37 $
 */


#include <errno.h>
#include <stdlib.h> 	/* malloc, free */
#include <string.h> 	/* memcpy, memset, strlen, strcmp */
#include <pthread.h> 	/* mutex, cond, pthraed... */
#include <signal.h> 	/* pthraed_kill */
#include <unistd.h>		/* read, select, fd_set, sleep */
#include <limits.h>
#include <sys/socket.h>
#include <sys/time.h>	/* select, fd_set */
#include <sys/types.h>	/* select, fd_set */
#include <sys/stat.h>	/* stat */
#include <fcntl.h> 		/* open */
#include <sys/ioctl.h> 	/* ioctl */

/* ugen lib */
//#include <dev/usb/usb.h>
//added by kawakubo
#include "usb.h"

/* libusbh */
#include <uhcommon.h>
#include <uh_apl_framework.h>

#include "JavaxUsbUhCommunicator.h"
#include "JavaxUsbUhDef.h"
#include "JavaxUsbUhDevProfile.h"


/*
+-------------------------------+
| define                        |
+-------------------------------+
*/
struct uhcomm_event_info_list_t;
typedef struct uhcomm_event_info_list {
	struct uhcomm_event_info_list_t* next;
	uhcomm_client_endpoint_t endpoint;
	int type;
	struct usb_device_info info;	/* (ugen defined) */
} uhcomm_event_info_list_t;


/*
+-------------------------------+
| variable                      |
+-------------------------------+
*/

static int uh_fd = -1;											/* socket with usbhostd */

static pthread_mutex_t list_mutex = PTHREAD_MUTEX_INITIALIZER;	/* mutex for list operation */
static pthread_mutex_t comm_mutex = PTHREAD_MUTEX_INITIALIZER;	/* mutex for exclusive init */
static pthread_mutex_t notify_mutex = PTHREAD_MUTEX_INITIALIZER;/* mutex for notify to client */
static pthread_cond_t notify_cond = PTHREAD_COND_INITIALIZER; 	/* for thread signal */

static pthread_t* recv_th = NULL; 								/* worker thread for event(from host) watcher */
static pthread_t* notify_th = NULL; 							/* worker thread for event(to client) notifier */

static usb_device_info_list_t* device_list = NULL;				/* plugged device list */
static uhcomm_event_info_list_t* notify_list = NULL; 			/* notifying event list */

static uhcomm_client_endpoint_t notify_ep = NULL; 				/* registered client endpoint to notify */

#ifdef	FIXEDLINK
extern int *__errno();
#else
extern int errno;
#endif

/*
+-------------------------------+
| prototype (inner functions)   |
+-------------------------------+
*/

#ifdef FIXEDLINK
extern void _pthread_init __P((void));
#endif

//uhcomm basic function
extern void* start_receive_event(void*);
int uhcomm_init(int* fd);
int uhcomm_recv(uhpacket_t* event, int fd);
int uhcomm_handle_event(uhpacket_t* packet);
void uhcomm_clear();

//List operation function
void clear_device_info_list(usb_device_info_list_t** list);
int add_device_info(struct usb_device_info* dev, usb_device_info_list_t** list);
int remove_device_info(struct usb_device_info* dev, usb_device_info_list_t** list);
int update_device_info_from_list(struct usb_device_info* dev, usb_device_info_list_t* list);
struct usb_device_info* find_parent_info_from_list(struct usb_device_info* dev, usb_device_info_list_t* list);

//Event notifier function
int add_notify_info(uhcomm_event_info_list_t* info, uhcomm_event_info_list_t** list);
int notify_event(uhcomm_client_endpoint_t endpoint, int type, struct usb_device_info* info);
extern void* start_notify_event(void*);

//Hub refresh function
void refresh_uhub_info(usb_device_info_list_t* list, usb_device_info_list_t** updateList);
int refresh_uhub_node(int* fd, u_int8_t addr, usb_device_info_list_t* list, usb_device_info_list_t** updateList);

/**
 * ڑĂUSBfoCXXg擾܂
 * @param list 擾郊Xg̊i[AhX [/O]
 * @return 0: 擾 / -n: 擾s
 * @see 擾Xg͌ĂяoŎ͊J邩Auhcomm_release_plugged_list()ɓnŊJĂB
 * @see listɂłɂȂ炩̏񂪂ꍇA擾͎s܂B
 */
int uhcomm_get_plugged_list(usb_device_info_list_t** list) {
	
	int result = UHCOMM_NORMAL;
	usb_device_info_list_t* dev = NULL;
	usb_device_info_list_t* ndev = NULL;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	/* list̃|CgNULLwł邱 */
	if (*list != NULL) {
		UHCOMM_LOG(UHCOMM_LOG_WARNING, "invalid parameter. (expected param is NULL)");
		return UHCOMM_PARAMETER_ERROR;
	}

//  --------->
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "enter mutex. [comm_mutex]");
	pthread_mutex_lock(&comm_mutex);
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "get mutex. [comm_mutex]");

	if (uh_fd < 1) {
		result = uhcomm_init(&uh_fd);
//      <----------
		UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex. [comm_mutex]");
		pthread_mutex_unlock(&comm_mutex);

		if (result == UHCOMM_NORMAL) {
			result = UHCOMM_INIT_BUSY;
		} else {
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "init failed. [result : %d]", result);
			result = UHCOMM_INIT_ERROR;
		}
		return result;
	}

//  <---------
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex. [comm_mutex]");
	pthread_mutex_unlock(&comm_mutex);
	
//  =========>
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "enter mutex. [list_mutex]");
	pthread_mutex_lock(&list_mutex);
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "get mutex. [list_mutex]");

	dev = device_list;
	while (dev) {
		ndev = (usb_device_info_list_t*)dev->next;
		result = add_device_info(&(dev->info), list);
		if (result != UHCOMM_NORMAL) {
			clear_device_info_list(list);
			break;
		}
		dev = ndev;
	}

//  <=========
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex. [list_mutex]");
	pthread_mutex_unlock(&list_mutex);
	
	return result;
}


/**
 * listJ܂
 */
void uhcomm_release_plugged_list (usb_device_info_list_t* list) {

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	clear_device_info_list(&list);
}


/**
 * dev̏icookiejƈvfoCXlist폜܂<br>
 * @param dev 	: 폜ΏۃfoCXiƓcookieł́j [I/ ]
 * @param list 	: ΏۃXg [I/O] 
 * @see ΏۃXg͌ĂяoŔrĂ
 */
int remove_device_info(struct usb_device_info* dev, usb_device_info_list_t** list) {

	usb_device_info_list_t* tdev = *list;
	usb_device_info_list_t* ndev = NULL;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	if (dev == NULL || *list == NULL) {
		return UHCOMM_PARAMETER_ERROR;
	}

	if (((*list)->info).cookie.cookie == dev->cookie.cookie) {
		/* Xg擪ΏۃfoCX̂Ƃ */
		*list = (usb_device_info_list_t*)tdev->next;
		tdev->next = NULL;
		free(tdev);
		return UHCOMM_NORMAL;
	}

	while (tdev->next) {
		ndev = (usb_device_info_list_t*)tdev->next;
		if ((ndev->info).cookie.cookie == dev->cookie.cookie) {
			tdev->next = ndev->next;
			ndev->next = NULL;
			free(ndev);
			return UHCOMM_NORMAL;
		}
		tdev = ndev;
	}
	
	/* ɗP[X͒ʏȂ */
	UHCOMM_LOG(UHCOMM_LOG_WARNING, "device not found. [device : %s, bus : %d, addr : %d, cookie : %d]", dev->devnames[0], dev->bus, dev->addr, dev->cookie.cookie);
	return UHCOMM_TARGET_NOT_FOUND;
}


/**
 * dev̏𕡐listvf𕡐Alist̍Ōɉ܂<br>
 * @param dev ǉi̕j 
 * @param list ǉΏۂ̃Xg [I/O]
 * @see ΏۃXg͌ĂяoŔrĂ
 */
int add_device_info(struct usb_device_info* dev, usb_device_info_list_t** list) {
	
	usb_device_info_list_t* tdev = NULL;
	usb_device_info_list_t** cdev;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	if (dev == NULL) {
		UHCOMM_LOG(UHCOMM_LOG_WARNING, "invalid parameter. [dev : NULL]");
		return UHCOMM_PARAMETER_ERROR;
	}

	if (*list == NULL) {
		*list = (usb_device_info_list_t*)malloc(sizeof(usb_device_info_list_t));
		if (*list == NULL) {
			return UHCOMM_MEMORY_ERROR;
		}
		memcpy(&((*list)->info), dev, sizeof(*dev));
		(*list)->next = NULL;
		return UHCOMM_NORMAL;
	} 

	tdev = *list;
	while (tdev->next) {
		 tdev = (usb_device_info_list_t*)tdev->next;
	}

//modify by shori for ver4
//	(usb_device_info_list_t*)tdev->next = (usb_device_info_list_t*)malloc(sizeof(usb_device_info_list_t));
//	if (tdev->next == NULL) {
//		return UHCOMM_MEMORY_ERROR;
//	}
//	tdev = (usb_device_info_list_t*)tdev->next;
//	memcpy(&(tdev->info), dev, sizeof(*dev));
//	tdev->next = NULL;
	cdev = (usb_device_info_list_t**)(&(tdev->next));
	*cdev = (usb_device_info_list_t*)malloc(sizeof(usb_device_info_list_t));
	if (*cdev == NULL) {
		return UHCOMM_MEMORY_ERROR;
	}
	memcpy(&((*cdev)->info), dev, sizeof(*dev));
	(*cdev)->next = NULL;

	return UHCOMM_NORMAL;
}


/**
 * w肵XgJ܂
 * @param list J郊Xg
 * @see ΏۃXg͌ĂяoŔrĂ
 */
void clear_device_info_list(usb_device_info_list_t** list) {

	usb_device_info_list_t* ninfo = NULL;
	usb_device_info_list_t* info = *list;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	while (info) {
		ninfo = (usb_device_info_list_t*)info->next;
		info->next = NULL;
		free(info);
		info = ninfo;
	}
	*list =info;
}


/**
 * USBHOST DAEMONƂ̒ʐMJn܂
 * @param fd ʐMpfBXNv^ [I/O]
*/
int uhcomm_init(int* fd) {

	int result = UH_NG;
	char pname[UHCOMM_PNAME_MAX];

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	/* ݑ| */
	uhcomm_clear();
	clear_device_info_list(&device_list);

#ifdef FIXEDLINK
        /* Xbh񏉊 */
		UHCOMM_LOG(UHCOMM_LOG_FUNC, "call function. [_pthread_init()]");
        _pthread_init();
#endif

	/* usbhƂ̒ʐMm */
	UHCOMM_LOG(UHCOMM_LOG_FUNC, "call function. [uh_socket_create(&%d)]", *fd);
	result = uh_socket_create(fd);
	if (result != UH_OK) {	/* UH_OKlibusbhdefine */
		UHCOMM_LOG(UHCOMM_LOG_ERROR, "socket to usbhd not established.");
		*fd = -1;
		return result;
	}
	UHCOMM_LOG(UHCOMM_LOG_INFO, "uh_socket_create() returned. [fd : %d]", *fd);

	if (strlen(UHCOMM_PNAME) > UHCOMM_PNAME_MAX) {
		UHCOMM_LOG(UHCOMM_LOG_ERROR, "notifying too long. [name : %s]", UHCOMM_PNAME);
		close(*fd);
		*fd = -1;
		return UHCOMM_PARAMETER_ERROR;
	}
	memset(pname, 0, UHCOMM_PNAME_MAX);
	memcpy(pname, UHCOMM_PNAME, strlen(UHCOMM_PNAME));

	/* usbhɃAvP[Vo^ */
	UHCOMM_LOG(UHCOMM_LOG_FUNC, "call function. [uh_event_init(&%d, %s)]", *fd, pname);
	result = uh_event_init(fd, UHCOMM_PNAME);
	if (result != UH_OK) {
		UHCOMM_LOG(UHCOMM_LOG_ERROR, "notifying to usbhd not completed. [pname : %s]", pname);
		close(*fd);
		*fd = -1;
		return result;
	}
	
	/* usbh̃CxgĎJniʃXbhj */
	recv_th = (pthread_t*)malloc(sizeof(*recv_th));
	if (recv_th == NULL) {
		UHCOMM_LOG(UHCOMM_LOG_CRITICAL, "event receiving thread not created. [can't allocated]");
		return UHCOMM_MEMORY_ERROR;
	}
	result = pthread_create(recv_th, NULL, start_receive_event, NULL);
	if (result != UH_OK) {
		UHCOMM_LOG(UHCOMM_LOG_ERROR, "event receiving thread not created. [failed pthread_create]");
		close(*fd);
		*fd = -1;
		free(recv_th);
		recv_th = NULL;
		return result;
	}
	//added by hori
	//pthread_setname_np(*recv_th, "UhcommEventWatcher");

	return result;
}


/**
*	USBhostd̃CxgĎ܂
*/
void* start_receive_event(void* arg) {

	int result = UH_NG;
	int retry = 0;
	uhpacket_t usbh_event;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");
	UHCOMM_LOG(UHCOMM_LOG_INFO, "start event receiving thread.");

	memset(&usbh_event, 0, sizeof(uhpacket_t));

	while(1) {
		if (uh_fd < 0) {
			UHCOMM_LOG(UHCOMM_LOG_DETAIL, "communication closed. exit event receiving roop. [fd : %d]", uh_fd);
			break;
		}
		result = uhcomm_recv(&usbh_event, uh_fd);
		if (result != UHCOMM_SOCKET_OK) {
			retry++;
			if (retry == UHCOMM_RETRY_LIMIT) {
				UHCOMM_LOG(UHCOMM_LOG_ERROR, "receiving packet retry limit reached.");
				notify_event(notify_ep, UHCOMM_ERROR_OCCURRED, NULL);
				break;
			}
			UHCOMM_LOG(UHCOMM_LOG_DETAIL, "failed receive event, retry again. [retry : %d]", retry);
			sleep(UHCOMM_RETRY_INTERVAL);
			continue;
		}
		retry = 0;
		result = uhcomm_handle_event(&usbh_event);
		if (result != UHCOMM_NORMAL) {
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "event handling error.");
		}
	}

	UHCOMM_LOG(UHCOMM_LOG_INFO, "finish event receiving thread.");
	return NULL;
}


/**
*	USBhostd̃CxgM܂.
*	@param event Mpobt@
*	@param fd	 ʐM\Pbg̃t@CfBXNv^
*	@return 0: / -n:s
 */
int uhcomm_recv(uhpacket_t* event, int fd) {

	int result = UHCOMM_SOCKET_OK;

	fd_set rfd;
	size_t remain_len = sizeof(uhpacket_t);
	int read_len = 0;
	unsigned char* buffer = (unsigned char*) event;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function. [fd : %d]", fd);
	
	if (fd < 0) {
		UHCOMM_LOG(UHCOMM_LOG_ERROR, "socket to usbhd not established. [fd : %d]", fd);
		return UHCOMM_SOCKET_NG;
	}

	do {
		FD_ZERO(&rfd);
		FD_SET(fd, &rfd);
	
		result = select((fd + 1), &rfd, (fd_set*)NULL, (fd_set*)NULL, NULL);
		if (result >= 0) {
			result = UHCOMM_NORMAL;
		} else {
			result = UHCOMM_SOCKET_NG;
#ifdef FIXEDLINK
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "select() return fault. [result : %d, err : %s]", result, strerror(*__errno())); 
#else
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "select() return fault. [result : %d, err : %s]", result, strerror(errno));
#endif			

			break;
		}

		if (!FD_ISSET(fd, &rfd)) {
			result = UHCOMM_SOCKET_NG;
#ifdef FIXEDLINK
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "FD_ISSET() return fault. [err : %s]", strerror(*__errno()));
#else
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "FD_ISSET() return fault. [err : %s]", strerror(errno));
#endif
			break;
		}
		
		read_len = read(fd, buffer, remain_len);
		UHCOMM_LOG(UHCOMM_LOG_DETAIL, "receive packet. [size : %d]", read_len);
		if (read_len > 0) {
			/* read something */
			remain_len -= read_len;
			buffer += read_len;	/* move pointer for offset to read next */
		} else if (read_len == 0) {
			/* peer closed the socket */
			result = UHCOMM_SOCKET_CLOSED;
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "packet read error (get zero packet). [remain size : %d]", remain_len);
			break;
		} else {
			/*
			 * ignore the signals / empty socket situations
			 * 
			*/
#ifdef FIXEDLINK
			if (*__errno() != EINTR && *__errno() != EAGAIN)
#else
			if (errno != EINTR && errno != EAGAIN)
#endif
			{
				result = UHCOMM_SOCKET_NG;
				UHCOMM_LOG(UHCOMM_LOG_ERROR, "packet read error (get minus packet). [remain size : %d]", remain_len);
				break;
			}
		}
	} while (remain_len != 0);

	return result;
}


/**
 * MCxgɑΉs܂
 */
int uhcomm_handle_event(uhpacket_t* packet) {
	
	int result = UHCOMM_NORMAL;
	int refresh_retry = 0;
	usb_device_info_list_t* tlist = NULL;
	usb_device_info_list_t* updateList = NULL;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

// ==============>
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "enter mutex. [list_mutex]");
	pthread_mutex_lock(&list_mutex);
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "get mutex. [list_mutex]");

	switch(packet->type) {	/* libusbh defines "type" values. */
		case UH_UGEN_IFINFO:
			UHCOMM_LOG(UHCOMM_LOG_WARNING, "unexpected event received. [ugen info]");
			break;

		case UH_REBOOT:
			UHCOMM_LOG(UHCOMM_LOG_INFO, "event received. [ncs reset]");
			notify_event(notify_ep, UHCOMM_NCS_REBOOT, NULL);
			break;
		
		case UH_DETACH:
			UHCOMM_LOG(UHCOMM_LOG_INFO, "event received. [detach : %s]", (packet->u).udev.devname);
			
			/* usb_device_info̕ (devnames󗓂Ȃ̂ɑΉj */
			uhcomm_trim_udev_name((packet->u).udev.devname, (packet->u).udev.udev_info.devnames[0], USB_MAX_DEVNAMELEN);
			/* detachꂽHub͎擾łȂ̂ŁAiʒmpɁjOĐڑfoCXXg擾Ă */
			update_device_info_from_list(&((packet->u).udev.udev_info), device_list);
			
			/* ڑfoCXXgO */
			remove_device_info(&((packet->u).udev.udev_info), &device_list);

			/* Hub̍XV */
			refresh_retry = 0;
			if (UHCOMM_CTRL_RETRY_MAX) {
				do {
					if (refresh_retry == UHCOMM_CTRL_RETRY_MAX) {
						UHCOMM_LOG(UHCOMM_LOG_WARNING, "can't update parent node. (maybe it also detached.) [bus : %d, addr : %d]", (packet->u).udev.udev_info.bus, (packet->u).udev.udev_info.addr);
						break;
					}
					updateList = NULL;
					refresh_uhub_info(device_list, &updateList);
					refresh_retry++;
					/* /dev/usb*̐mȏ擾ɂdelayꍇ̂ŁAgCőΉ */
				} while (find_parent_info_from_list(&((packet->u).udev.udev_info), device_list));
			}
			tlist = updateList;
			while (tlist) {
				/* XVHUB̒ʒm */
				notify_event(notify_ep, UHCOMM_DEVICE_UPDATE, &(tlist->info));
				tlist = (usb_device_info_list_t*)tlist->next;
			}			
			clear_device_info_list(&updateList);

			/* ؒffoCX̒ʒm */
			notify_event(notify_ep, UHCOMM_DEVICE_DETACH, &((packet->u).udev.udev_info));
			break;

		case UH_DEVINFO:
			UHCOMM_LOG(UHCOMM_LOG_INFO, "event received. [attach : %s]", (packet->u).udev.devname);
			UHCOMM_LOG(UHCOMM_LOG_DETAIL, "attach event [bus:%d, addr:%d, cookie:%d, product:%d, vender:%d, release:%d, class:%d, subclass:%d, protocol:%d, config:%d, lowspeed:%d, power:%d, nports:%d]",
					(packet->u).udev.udev_info.bus,
					(packet->u).udev.udev_info.addr,
					(packet->u).udev.udev_info.cookie.cookie,
					(packet->u).udev.udev_info.productNo,
					(packet->u).udev.udev_info.vendorNo,
					(packet->u).udev.udev_info.releaseNo,
					(packet->u).udev.udev_info.class,
					(packet->u).udev.udev_info.subclass,
					(packet->u).udev.udev_info.protocol,
					(packet->u).udev.udev_info.config,
					(packet->u).udev.udev_info.lowspeed,
					(packet->u).udev.udev_info.power,
					(packet->u).udev.udev_info.nports);

			/* usb_device_info̕ (devnames󗓂Ȃ̂ɑΉj */
			uhcomm_trim_udev_name((packet->u).udev.devname, (packet->u).udev.udev_info.devnames[0], USB_MAX_DEVNAMELEN);

			/* ڑfoCXXgɉ */
			if(add_device_info(&((packet->u).udev.udev_info), &device_list) == UHCOMM_MEMORY_ERROR) {
				UHCOMM_LOG(UHCOMM_LOG_CRITICAL, "memory not enough.");
				notify_event(notify_ep, UHCOMM_ERROR_OCCURRED, &((packet->u).udev.udev_info));
			}

			/* HubXV & ʒm */
			if (UHCOMM_CTRL_RETRY_MAX) {
				refresh_uhub_info(device_list, &updateList);
			}
			tlist = updateList;
			while (tlist) {
				if ((packet->u).udev.udev_info.cookie.cookie != (tlist->info).cookie.cookie) {
					/* attachCxg̃foCXupdateƂĂ͒ʒmȂ(attachƂČŒʒm) */
					notify_event(notify_ep, UHCOMM_DEVICE_UPDATE, &(tlist->info));
				}
				tlist = (usb_device_info_list_t*)tlist->next;
			}
			clear_device_info_list(&updateList);

			/* ʒmpɃCxgC (devnames, nports̕) */
			update_device_info_from_list(&((packet->u).udev.udev_info), device_list);

			/* o^Avɂ̃Cxg̃foCXڑʒm */
			notify_event(notify_ep, UHCOMM_DEVICE_ATTACH, &((packet->u).udev.udev_info));
			break;
		
		default:
			UHCOMM_LOG(UHCOMM_LOG_WARNING, "event received. [unknown : %d]", packet->type);
			break;
	}

// <==============
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex. [list_mutex]");
	pthread_mutex_unlock(&list_mutex);
	
	return result;
}


/**
 * USBhostdƂ̒ʐMNA܂<br>
 * comm_mutexɂrĂяoŎ擾Ă
*/
void uhcomm_clear() {

	void* vret;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	/* ʐMؒf */
	if (uh_fd > 0) {
		/* TODO iUSBHOSTdւ́jؒfʒm */
		close(uh_fd);
		uh_fd = -1;
	}

	/* zXgf[ĎI */
	if (recv_th) {
		UHCOMM_LOG(UHCOMM_LOG_FUNC, "call function. [pthread_join()]");
		pthread_join(*recv_th, &vret);
		recv_th = NULL;
	}

	/* CxgʒmXbh͂̂܂܂ɂĂ */
	/* icallbackŁAuhcomm_init\邽߁j */

	/* ڑfoCXj͌ʂɂ */

}


/**
 * AvP[Vւcallback֐o^܂<br>
 * o^A݂̐ڑfoCXXgCxgƂāicallback֐ʂājʒm܂
 *
 * @param endpoint callback̊֐
 * @return :UHCOMM_NORMAL (= 0) / s:G[`l (= -n)
 */
int uhcomm_register_endpoint(uhcomm_client_endpoint_t endpoint) {

	int result = UHCOMM_NORMAL;

	usb_device_info_list_t* info = NULL;
	usb_device_info_list_t* send_info = NULL;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

//  =========>
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "enter mutex. [list_mutex]");
	pthread_mutex_lock(&list_mutex);
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "get mutex. [list_mutex]");
	

	/* ێXgo^AvP[Vɒʒm邽߂Ɏ擾 */
	/* ʒmlist_mutex̔rԂ̊OłȂ߁ARs[Ď擾 */
	if (endpoint) {
		info = device_list;
		while (info) {
			result = add_device_info(&(info->info), &send_info);
			if (result != UHCOMM_NORMAL) {
				clear_device_info_list(&send_info);
				break;
			}
			info = (usb_device_info_list_t*)info->next;
		}
	}

	if (result == UHCOMM_NORMAL) {
		/* AvP[Vo^ */
		if (endpoint != NULL && notify_ep != NULL) {
			UHCOMM_LOG(UHCOMM_LOG_WARNING, "existed endpoint is overrided.");
		}
		notify_ep = endpoint;
	}		
//  <=========
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex. [list_mutex]");
	pthread_mutex_unlock(&list_mutex);

	/* o^AvP[VɐڑCxgƂĒʒm */
	info = send_info;
	while (info) {
		notify_event(notify_ep, UHCOMM_DEVICE_ATTACH, &(info->info));
		info = (usb_device_info_list_t*)info->next;
	}

	clear_device_info_list(&send_info);

// ------------>
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "enter mutex. [comm_mutex]");
	pthread_mutex_lock(&comm_mutex);
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "get mutex. [comm_mutex]");

	if (uh_fd < 1) {
		result = uhcomm_init(&uh_fd);
		if (result != UHCOMM_NORMAL) {
#ifdef FIXEDLINK
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "init failed. [result : %d, err : %s]", result, strerror(*__errno()));
#else
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "init failed. [result : %d, err : %s]", result, strerror(errno));
#endif
			result = UHCOMM_INIT_ERROR;
		}
	}

// <----------
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex. [comm_mutex]");
	pthread_mutex_unlock(&comm_mutex);

	return result;
}


/**
 * 3̈ЂƂ̃CxgʒmƂāAʒm҂Xgɓo^܂<br>
 * ʒmXbhx~ĂꍇAXbhN܂<br>
 * info͓ŃRs[̂ŁAreturnɊJĂ肠܂
 * @param endpoint : ʒmcallback֐(endpoint)
 * @param type : ʒmCxg̎
 * @param info : ʒmCxg̋@
 */
int notify_event(uhcomm_client_endpoint_t endpoint, int type, struct usb_device_info* info) {
	
	int result = UHCOMM_NORMAL;
	uhcomm_event_info_list_t* message = NULL;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");
	
	message = (uhcomm_event_info_list_t*)malloc(sizeof(uhcomm_event_info_list_t));
	if (message == NULL) {
		UHCOMM_LOG(UHCOMM_LOG_CRITICAL, "notifying message lost. (caused by bad alloc) [type : %d]", type);
		return UHCOMM_MEMORY_ERROR;
	}

	message->endpoint = endpoint;
	message->type = type;
	memset(&(message->info), 0, sizeof(struct usb_device_info));

	if (info) {
		memcpy(&(message->info), info, sizeof(*info));
	}
	message->next = NULL;

//  ---------->
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "enter mutex. [notify_mutex]");
	pthread_mutex_lock(&notify_mutex);
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "get mutex. [notify_mutex]");
	
	if (notify_list == NULL) {
		notify_list = message;
	} else {
		result = add_notify_info(message, &notify_list);
		if (result != UHCOMM_NORMAL) {
			free(message);
		//  <---------
			UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex. [notify_mutex]");
			if (pthread_mutex_unlock(&notify_mutex) != 0) {
				UHCOMM_LOG(UHCOMM_LOG_ERROR, "leaving mutex failed. [notify_mutex]");
			}
			return result;
		}
	}

	if (notify_th == NULL) {
		/* XbhN܂ */
		notify_th = (pthread_t*)malloc(sizeof(pthread_t));
		if (notify_th != NULL) {
			result = pthread_create(notify_th, NULL,start_notify_event, NULL);
			if (result != UH_OK) {
				UHCOMM_LOG(UHCOMM_LOG_ERROR, "event notifying thread not created. [failed pthread_create]");
				free(notify_th);
				notify_th = NULL;
			}
			//added by kawakubo
			//pthread_setname_np(*recv_th, "UhcommEventNotifier");
		} else {
			/* ɍēxXbhN悤Ƃ̂ŁAɃnhOȂ */
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "event_notifying thread not created. [can't allocate]");
		}
	} else {
		/* Xbh܂ */
		UHCOMM_LOG(UHCOMM_LOG_FUNC, "call function. [pthread_cond_signal]");
		pthread_cond_signal(&notify_cond);
		UHCOMM_LOG(UHCOMM_LOG_FUNC, "return function. [pthread_cond_signal]");
	}
//  <---------
	UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex. [notify_mutex]");
	if (pthread_mutex_unlock(&notify_mutex) != 0) {
		UHCOMM_LOG(UHCOMM_LOG_ERROR, "leaving mutex failed. [notify_mutex]");
	}

	return result;
}


/**
 * infȍAlist̍Ōɉ܂<br>
 * @see ΏۃXg͌ĂяoŔrĂ
 * @see infoallocateĂKv܂
 */
int add_notify_info(uhcomm_event_info_list_t* info, uhcomm_event_info_list_t** list) {
	
	uhcomm_event_info_list_t* tinfo = NULL;
	uhcomm_event_info_list_t** ainfo;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	if (info == NULL) {
		UHCOMM_LOG(UHCOMM_LOG_WARNING, "invalid parameter. [info : NULL]");
		return UHCOMM_PARAMETER_ERROR;
	}

	if (*list == NULL) {
		*list = info;
		return UHCOMM_NORMAL;
	} 

	tinfo = (uhcomm_event_info_list_t*)*list;
	
	while (tinfo->next) {
		tinfo = (uhcomm_event_info_list_t*)tinfo->next;
	}

//modify by shori for ver4
	//(uhcomm_event_info_list_t*)tinfo->next = info;
	ainfo = (uhcomm_event_info_list_t**)(&(tinfo->next));
	*ainfo = info;

	return UHCOMM_NORMAL;
}

/**
 * o^ĂAvP[Vւ̒ʒmȂXbhmain functionł<br>
 * MCxg̃L[ɂȂ܂ŃL[r܂
 * CxgL[ɂAsignal҂܂
 */
void* start_notify_event(void* arg) {

	uhcomm_event_info_list_t* info;
	uhcomm_event_info_list_t* ninfo;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	pthread_cond_init(&notify_cond, NULL);

	while(1) {
//  ---------->
		UHCOMM_LOG(UHCOMM_LOG_MUTEX, "enter mutex. [notify_mutex]");
		pthread_mutex_lock(&notify_mutex);
		UHCOMM_LOG(UHCOMM_LOG_MUTEX, "get mutex. [notify_mutex]");
		
		info = notify_list;
		
		if (info == NULL) {
			/* XgȂ̂ŁAsignal҂ */
			/* o^AvP[V݂Ȃ̂ŁAsignal҂ */
//  <---------
			UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex (&WAIT). [notify_mutex]");
			if (pthread_cond_wait(&notify_cond, &notify_mutex) != 0) {
				UHCOMM_LOG(UHCOMM_LOG_ERROR, "leaving mutex failed. [notify_mutex]");
			}
			//modify by shori for ver4: the specification of the method "pthread_cond_wait" is odd.
			UHCOMM_LOG(UHCOMM_LOG_MUTEX, "pthread_cond_wait (&RESTART). [notify_mutex]");
			UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex. [notify_mutex]");
			if(pthread_mutex_unlock(&notify_mutex) != 0) {
				UHCOMM_LOG(UHCOMM_LOG_ERROR, "leaving mutex failed. [notify_mutex]");
			}
			continue;
		}
			 
		ninfo = (uhcomm_event_info_list_t*)info->next;
		notify_list = ninfo;
		/* Xg̐擪𔲂oԂ̔rŏ\ */
		/* ʒmrĂƁAcallback悩callăfbhbN鋰ꂪ */
//  <---------
		UHCOMM_LOG(UHCOMM_LOG_MUTEX, "leave mutex. [notify_mutex]");
		if(pthread_mutex_unlock(&notify_mutex) != 0) {
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "leaving mutex failed. [notify_mutex]");
		}

		if (info->endpoint) {
			(*(info->endpoint))(info->type, &(info->info));
		}
		/* callback悪ȂCxgł̂܂ܔj */
		info->next = NULL;
		free(info);
	}
	
}


/**
 * Xgɑ݂HUBkernelhCo𗘗pčXV܂<br>
 * XVΏۂlistɑ݂HUBɌ肵܂<br>
 * XVꂽHUB񂪂΁Alist̒XVA܂XVƂlistɂi[܂
 * @param list XV郊Xg [I/O]
 * @param updateList XVꂽHUB [/O]
 */
void refresh_uhub_info(usb_device_info_list_t* list, usb_device_info_list_t** updateList) {
	
	int fd = -1;
	char ctrlfile[USB_MAX_DEVNAMELEN];

	int i = 0;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	if (list == NULL) {
		UHCOMM_LOG(UHCOMM_LOG_WARNING, "invalid parameter. [list : NULL]");
		return;
	}

	for(i = 0; i < UHCOMM_MAX_CONTROLLERS; i++) {
		
		struct stat status;
	
		memset (ctrlfile, 0, USB_MAX_DEVNAMELEN);
		sprintf(ctrlfile, "%s%s%d", UHCOMM_CTRL_PATH, UHCOMM_CTRL_NAME, i);

		if (stat(ctrlfile, &status) != 0) {
			//ȂȂ_ŏI
			break;
		}

		fd = open(ctrlfile, O_RDONLY);
		if (fd < 0) {
			UHCOMM_LOG(UHCOMM_LOG_ERROR, "can't open device special file. [file : %s]", ctrlfile);
			continue;
		}

		refresh_uhub_node(&fd, 1, list, updateList);

		close(fd);
		fd = -1;
	}
}

/**
 * addr̃foCXkernelhCo𗘗pčĎ擾A<br>
 * list̃foCXXV܂<br>
 * XV񂪂΁Alist̊YXVA<br>
 * ܂XVƂupdateListɂYǉ܂
 * @param fd kernelhCõt@CfBXNv^
 * @param addr Ď擾foCX̃AhX
 * @param list Ď擾foCXōXV郊Xg
 * @param updateList XV̗Xg [I/O]
 * @return UHCOMM_NORMAL : 
 */
int refresh_uhub_node(int* fd, u_int8_t addr, usb_device_info_list_t* list, usb_device_info_list_t** updateList) {
	
	int result = UHCOMM_NORMAL;
	usb_device_info_list_t* info = list;
	int i = 0;

	struct usb_device_info di;
	di.addr = addr;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function. [addr : %d]", addr);

	result = ioctl(*fd, USB_DEVICEINFO, &di);
	if (result < 0) {
#ifdef FIXEDLINK
		UHCOMM_LOG(UHCOMM_LOG_ERROR, "ioctl fault. [fd : %d, addr : %d, err : %s]", *fd, addr, strerror(*__errno()));
#else
		UHCOMM_LOG(UHCOMM_LOG_ERROR, "ioctl fault. [fd : %d, addr : %d, err : %s]", *fd, addr, strerror(errno));
#endif
		return result;
	}

	UHCOMM_LOG(UHCOMM_LOG_DETAIL, "get uhub [bus:%d, addr:%d, cookie:%d, class:%d, nports:%d, port1:%d, port2:%d, port3:%d, port4:%d]",
					di.bus,
					di.addr,
					di.cookie.cookie,
					di.class,
					di.nports,
					di.ports[0],
					di.ports[1],
					di.ports[2],
					di.ports[3]);

	/* refresh this node */
	info = list;
	while(info) {
		if ((info->info).cookie.cookie == di.cookie.cookie) {
			for (i = 0; i < di.nports; i++) {
				if ((info->info).ports[i] != di.ports[i]) {
					if (add_device_info(&di, updateList) != UHCOMM_NORMAL) {
						UHCOMM_LOG(UHCOMM_LOG_ERROR, "lost refreshed hub info [bus : %d, addr : %d]", di.bus, di.addr);
					}
					break;
				}
			}
			memcpy(&(info->info), &di, sizeof(di));
			break;
		}
		info = (usb_device_info_list_t*)info->next;
	}
	
	/* refresh lower uhub nodes */
	for(i = 0; i < di.nports; i++) {
		if (di.ports[i] > USB_MAX_DEVICES) {
			continue;
		}
		info = list;
		while (info) {
			if (di.ports[i] == info->info.addr && di.bus == info->info.bus) {
				if (info->info.class == UDCLASS_HUB) {
					/* HUB class ݂̂ɍXV */
					refresh_uhub_node(fd, di.ports[i], list, updateList);
				}
//				break;
			}
			info = (usb_device_info_list_t*)info->next;
		}
	}

	return result;
}


/**
 * dev̏Alist̓cookieŏ㏑܂
 * @param dev ㏑iHUB)foCX
 * @param list XVi[Xg
 */
int update_device_info_from_list(struct usb_device_info* dev, usb_device_info_list_t* list) {
	
	usb_device_info_list_t* info = NULL;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");

	if (dev == NULL || list == NULL) {
		UHCOMM_LOG(UHCOMM_LOG_WARNING, "invalid parameter. [dev/list : NULL]");
		return UHCOMM_PARAMETER_ERROR;
	}

	info = list;
	while (info) {
		if (info->info.cookie.cookie == dev->cookie.cookie) {
 			memcpy(dev, &(info->info),sizeof(*dev));
			return UHCOMM_NORMAL;
		}
		info = (usb_device_info_list_t*)info->next;
	}

	return UHCOMM_TARGET_NOT_FOUND;
}


/**
 * list̏Ɉinfo̐eNodeHUB񂪑݂΁AHUBԂ܂<br>
 * 擾͊JĂ͂܂ilist܂j
 * @param dev 	eNodeQƂdevice
 * @param list 	eNode{Ώlist
 * @return NULL:Ȃ / NULLȊOFeHUBiQƁj
 */
struct usb_device_info* find_parent_info_from_list(struct usb_device_info* dev, usb_device_info_list_t* list) {
	usb_device_info_list_t* tinfo = list;

	UHCOMM_LOG(UHCOMM_LOG_FUNC, "enter function.");
	
	if (!dev) {
		return NULL;
	}

	while (tinfo) {
		int i = 0;
		for (i = 0; i < (tinfo->info).nports; i++) {
			if ((tinfo->info).ports[i] == dev->addr 
				&& (tinfo->info).bus == dev->bus) {
				return &(tinfo->info);
			}
		}
		tinfo = (usb_device_info_list_t*)tinfo->next;
	}
	
	return NULL;
}
