/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: Activator for start up.
 *
 *
 */
package jp.co.ricoh.dsdk.app.usb.test;

import jp.co.ricoh.dsdk.service.util.ServerContext;
import jp.co.ricoh.dsdk.xlet.XletContext;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;


public class Activator implements BundleActivator {

	private BundleContext contxt = null;
	
    private HttpService http = null;
    private ServiceReference ref = null;
    String path = "";
	UsbTestServlet uts = null;
    
	public static String INSTALL_PATH;
	
	public void start(BundleContext contxt) throws Exception {
		System.out.println("Activator is start().");
		this.contxt = contxt;
		this.ref = contxt.getServiceReference("org.osgi.service.http.HttpService");
		if (this.ref == null) {
			throw new Exception("not found HTTP service");
		}
		this.http = (HttpService) contxt.getService(this.ref);
		if (this.http == null) {
			throw new Exception("not found HTTP service object");
		}
	
		path = (String)ServerContext.getProperty(this.contxt, ServerContext.Prop_Key.INSTALLPATH);;
		if(path.indexOf("file:")==0){
			path = path.substring("file:".length());
		}
		System.out.println("path = " + path);
		INSTALL_PATH = path;

		System.out.println("new UsbTestServlet");
		uts = new UsbTestServlet();
		System.out.println("start registerServlet");
		http.registerServlet("/usb/UsbTestServlet", uts, null, null);
		System.out.println("start registerResources");
		http.registerResources("/usb","/usb",null);
	}

	public void stop(BundleContext arg0) throws Exception {
		System.out.println("Activator is stopped().");
		if(http != null){
			this.http.unregister("/usb");
		}
		uts.close();
	}

}
