/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: TmsrMagStripeReader is a class that extends AbstractCardReader for reading as for the data of the TmsrMagStripeReader card. 
 *
 *
 */
package jp.co.ricoh.dsdk.usb.core.hid.prox;

import java.util.Vector;

import javax.usb.UsbException;
import javax.usb.util.UsbUtil;

import jp.co.ricoh.dsdk.usb.prox.CardListener;

/**
 * TmsrMagStripeReaderNX́AAbstractCardReadergTmsrMagStripeReaderJ[h̃f[^ǂݍ݂̂߂̃NXł
 * CardReaderœǂݍ܂ꂽbyte[]̂܂܃AvP[Vɓn܂B
 * TmsrMagStripeReader is a class that extends AbstractCardReader for reading as for the data of the TmsrMagStripeReader card. 
 */
public class TmsrMagStripeReader extends AbstractCardReader{

	private Vector listener = null;
	private StringBuffer str_data = null;
	private KeyBoard keyboard = null;

	/**
	 * TmsrMagStripeReaderNX̃CX^X쐬܂
	 * Create the TmsrMagStripeReader instance.
	 */
	public TmsrMagStripeReader() throws UsbException{
		super();
		System.out.println("Constructor TmsrMagStripeReader");
		this.listener = new Vector();
		this.str_data = new StringBuffer();
		this.keyboard = new KeyBoard();

		super.addListener(new CardListener(){
			public void readByte(byte[] data) {
				boolean endflag = false;
				boolean badflag = false;
				boolean shiftOption = false;
				
				/** 
				 * parse the data. */
				for (int i=0; i<data.length; i++){
					/**
					 *  finish parsing if the data is "RETURN" code */
					if( UsbUtil.toHexString(data[i]).equals("28")){
						endflag = true;
					}
					/**             
					 *  check the return value. */
					if(((i-6)%8) == 0){
						if(!UsbUtil.toHexString(data[i]).equals("00")){
							endflag = true;
							badflag = true;
							System.out.println("System Error");
						}
					}

					if(endflag){
						break;
					}
					/** 
					 *  store the data if it is not "00"    */
					if(!UsbUtil.toHexString(data[i]).equals("00")){
						if(UsbUtil.toHexString(data[i]).equals("02")){
							shiftOption = true;
						}else{
							String keyValue;
							if(shiftOption){
								keyValue = keyboard.getData(UsbUtil.toHexString(data[i]), true);
							}else{
								keyValue = keyboard.getData(UsbUtil.toHexString(data[i]), false);
							}
							str_data.append(keyValue);
							shiftOption = false;
						}
					}
				}
				
				/** 
				 *  no error and the end flag is enabled */
				if(!badflag && endflag){
					synchronized (listener) {
						for (int i = 0; i < listener.size(); i++) {
							if (listener.get(i) instanceof CardListener) {
								CardListener lis = (CardListener) listener.get(i);
								
								/**  
								 *  convert string data into byte array.*/
								byte[] b = str_data.toString().getBytes();

								str_data = new StringBuffer();
								lis.readByte(b);
								
								//The updating interval of the display is 1 second.
								try {
									Thread.sleep(1000);
								} catch (InterruptedException e) {
									e.printStackTrace();
								}
							}
						}
					}
				}
			}

			public void disconnect() {
				synchronized (listener) {
					for (int i = 0; i < listener.size(); i++) {
						if (listener.get(i) instanceof CardListener) {
							CardListener lis = (CardListener) listener.get(i);
							lis.disconnect();
						}
					}
				}
			}
		});
		
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.core.cardreader.AbstractCardReader#addListener(jp.co.ricoh.dsdk.app.usb.cardreader.CardDataListener)
	 */
	public void addListener(CardListener lis){
		synchronized (listener) {
			listener.add(lis);
		}
	}

	public void removeListener(CardListener lis) {
		synchronized (listener) {
			for(int i = 0; i < listener.size(); i++){
				CardListener cl = (CardListener)listener.get(i);
				if(cl == lis){
					listener.remove(i);
					break;
				}
			}
		}
	}
}