/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: GeneralCardReader is a class with the same function as AbstractCardReader. 
 *
 *
 */
package jp.co.ricoh.dsdk.usb.core.hid.prox;

import java.util.Vector;

import javax.usb.UsbException;
import javax.usb.util.UsbUtil;

import jp.co.ricoh.dsdk.usb.prox.CardListener;

/**
 * GeneralCardReaderNX́AAbstractCardReaderƓ@\CardReaderNXłB
 * CardReaderœǂݍ܂ꂽbyte[]̂܂܃AvP[Vɓn܂B
 * GeneralCardReader is a class with the same function as AbstractCardReader. 
 */
public class GeneralCardReader extends AbstractCardReader{
	
	private Vector listener = null;
	private StringBuffer str_data = null;
	
	/**
	 * GeneralCardReaderNX̃CX^X쐬܂
	 * Create the GeneralCardReader instance.
	 */
	public GeneralCardReader() throws UsbException{
		super();
		this.listener = new Vector();
		this.str_data = new StringBuffer();
		super.addListener(new CardListener(){
			public void readByte(byte[] data) {
				/** 
				 * parse the data. */
				for (int i=0; i<data.length; i++){
					str_data.append(UsbUtil.toHexString(data[i]));
				}
				
				synchronized (listener) {
					for (int i = 0; i < listener.size(); i++) {
						if (listener.get(i) instanceof CardListener) {
							CardListener lis = (CardListener) listener.get(i);
							
							/**  
							 *  convert string data into byte array.*/
							System.out.println("str_data is = " + str_data.toString());
							byte[] b = str_data.toString().getBytes();
							
							str_data = new StringBuffer();
							lis.readByte(b);
							
							//The updating interval of the display is 1 second.
							try {
								Thread.sleep(1000);
							} catch (InterruptedException e) {
								// TODO ꂽ catch ubN
								e.printStackTrace();
							}
						}
					}
				}
			}
			
			public void disconnect() {
				synchronized (listener) {
					for (int i = 0; i < listener.size(); i++) {
						if (listener.get(i) instanceof CardListener) {
							CardListener lis = (CardListener) listener.get(i);
							lis.disconnect();
						}
					}
				}
			}
		});
		
	}
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.core.cardreader.AbstractCardReader#addListener(jp.co.ricoh.dsdk.app.usb.cardreader.CardDataListener)
	 */
	public void addListener(CardListener lis){
		synchronized (listener) {
			listener.add(lis);
		}
	}
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.cardreader.CardDeviceListener#addListener(jp.co.ricoh.dsdk.app.usb.cardreader.CardDataListener)
	 */
	public void removeListener(CardListener lis) {
		synchronized (listener) {
			for(int i = 0; i < listener.size(); i++){
				CardListener cl = (CardListener)listener.get(i);
				if(cl == lis){
					listener.remove(i);
					break;
				}
			}
		}
	}
}
