/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: for start up.
 *
 *
 */
package jp.co.ricoh.dsdk.app.usb.test;

import java.util.ArrayList;
import java.util.List;

import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.event.UsbServicesEvent;
import javax.usb.event.UsbServicesListener;

import jp.co.ricoh.dsdk.panel.Container;
import jp.co.ricoh.dsdk.panel.Frame;
import jp.co.ricoh.dsdk.panel.Label;
import jp.co.ricoh.dsdk.panel.Window;
import jp.co.ricoh.dsdk.usb.UsbDeviceManager;
import jp.co.ricoh.dsdk.xlet.UnavailableContainerException;
import jp.co.ricoh.dsdk.xlet.Xlet;
import jp.co.ricoh.dsdk.xlet.XletContext;
import jp.co.ricoh.dsdk.xlet.XletStateChangeException;

public class UsbTest implements Xlet {
	
	private XletContext context = null;
	
	private Window rootWindow = null;
	
	private UsbDeviceManager device_reader = null;
	
	List devicePanelList = null;
	
	UsbServicesListener usl = null;
	
	public static String INSTALL_PATH;
	
	public void initXlet(XletContext context) throws XletStateChangeException {
		System.out.println("---------------InitXlet-------------------");

		this.context = context;
        /** Window擾 */
        /** Get window */
        try {
            Container parent = this.context.getContainer();
            while (!(parent instanceof Frame)) {
                parent = parent.getParent();
                if (parent == null)
                    break;
            }
            if (parent == null) {
                return;
            }
            this.rootWindow = (Frame) parent;
        } catch (UnavailableContainerException ex) {
            throw new XletStateChangeException();
        }
        
		INSTALL_PATH = (String) context
		.getXletProperty(XletContext.INSTALLEDPATH);
        
    	try {
            /** create usb device manager */
    		device_reader = new UsbDeviceManager();
    	} catch (UsbException e) {
			e.printStackTrace();
		}        
		devicePanelList = new ArrayList();

		/** Get the UsbDevice list. */
		List list = device_reader.getDevices();
		for(int i = 0; i < list.size(); i++){
			DevicePanel panel = new DevicePanel(this.rootWindow, (UsbDevice)list.get(i));	
			devicePanelList.add(panel);
		}
		
        /** create gui */
		createGUI();
		/** create listener */
		createListener();
	}

	public void startXlet() throws XletStateChangeException {
		System.out.println("---------------StartXlet-------------------");
	}
	
	public void pauseXlet() {
		System.out.println("---------------PauseXlet-------------------");
	}
	public void destroyXlet(boolean flag) throws XletStateChangeException {
		System.out.println("---------------DestroyXlet-------------------");
		closeDevicePanelList();
		device_reader.removeServicesListener(usl);
	}


	/**
	 * {@jp GUI쐬}{@en create GUI}.
	 */
	private void createGUI(){
		//System.out.println("In createGUI");
		/** UsbDevicẽXg擾 */
		/** Get the UsbDevice list. */
		List list = device_reader.getDevices();
		if(list.size()==0){
			/* DeviceĂȂꍇ */
			/** There are no attached usb device.*/
			Label label = new Label("No Device!");
			label.setBounds(10, 10, 90, 24);
			this.rootWindow.add(label);
			
		} else {
//			final int width = 190;
//			final int height = 95;
			final int width = 590;
			final int height = 95;
			
			/** plɕ\ */
			/** Display the panel. */
//			for(int i = 0, j = -1; i < list.size() && i < 6; i++){
//				if(i%3 == 0)j++;
//				/* UsbDeviceƂPaneladd */
//				//DevicePanel panel = new DevicePanel(this.rootWindow, (UsbDevice)list.get(i));
//				DevicePanel panel = (DevicePanel)devicePanelList.get(i);
//				panel.setBounds(5 + (width + 5) * (i % 3), 20 + (height + 10) * j, width, height);
//				this.rootWindow.add(panel);
////				devicePanelList.add(panel);
//			}
			
			for(int i = 0, j = -1; i < list.size() && i < 6; i++){
				if(i%1 == 0)j++;
				/* UsbDeviceƂPaneladd */
				//DevicePanel panel = new DevicePanel(this.rootWindow, (UsbDevice)list.get(i));
				DevicePanel panel = (DevicePanel)devicePanelList.get(i);
				panel.setBounds(5 + (width + 5) * (i % 1), 20 + (height + 10) * j, width, height);
				this.rootWindow.add(panel);
//				devicePanelList.add(panel);
			}
			
			
		}// if/elseI
		//System.out.println("Out createGUI");
	}
	
	/**
	 * {@jp UsbfoCX񂪍XVꂽƂɌĂ΂}{@en Create the listener}.
	 */
	private void createListener(){
		System.out.println("In createListener");

		/** foCXXVꂽꍇɌĂяo */
		/** When the device was attached or dettached, the UsbServicesListener class is called.*/
		usl = new UsbServicesListener() {
			public void usbDeviceAttached(UsbServicesEvent use) {
				System.out.println("usbDeviceAttached");
				//closeDevicePanelList();
				DevicePanel panel = new DevicePanel(rootWindow, use.getUsbDevice());	
				devicePanelList.add(panel);
				
				updateDevice();
			}
			public void usbDeviceDetached(UsbServicesEvent use) {
				System.out.println("usbDeviceDetached");
				/** Remove the device panel from devicePanelList.*/
				for(int i = 0; i < devicePanelList.size(); i++){
					DevicePanel dp = (DevicePanel)devicePanelList.get(i);
					UsbDevice ud = dp.getDevice();
					if(ud != use.getUsbDevice()){
						//dp.closeDevicePanel();
					}else{
						devicePanelList.remove(i);
					}
				}
				updateDevice();
			}
		};
		device_reader.addUsbServicesListener(usl);
		System.out.println("Out createListener");
	}
	
	/**
	 * {@jp DeviceupdateꂽƂɌĂ΂}{@en Update the displayed panel.}.
	 */
	private void updateDevice(){
		try{
			//WindowaddĂComponent폜
			/** delete the compornet from rootwindow.*/
			rootWindow.removeAll();
			createGUI();
			
			rootWindow.repaint();
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	/**
	 * Close the all devicePanel class.
	 */
	private void closeDevicePanelList(){
		/** Close the old USB device*/
		if(devicePanelList != null){
			for(int i =0; i < this.devicePanelList.size(); i++){
				DevicePanel dp = (DevicePanel)devicePanelList.get(i);
				dp.closeDevicePanel();
			}
		}
	}
}