/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: CardReaderManager is a class that manages CardReader. 
 *
 */

package jp.co.ricoh.dsdk.usb.prox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.util.UsbUtil;

import jp.co.ricoh.dsdk.usb.core.hid.prox.GeneralCardReader;

/**
 * CardReaderManagerNX́ACardReaderǗNXł
 * CardReaderManager is a class that manages CardReader. 
 */
public class CardReaderManager {

	private static final String property_file = "card.reader.properties";

	private static String INSTALL_PATH = "";
	
	/**
	 * CardReaderManager̃CX^X𐶐܂B
	 * Create the CardReaderManager instance.
	 */
	private CardReaderManager(){}
	
	/**
	 * UsbDevicew肵CardReaderServicẽCX^X擾܂
	 * Get the instance of CardReaderService specifying UsbDevice.
	 */
	public static CardReaderService getCardReaderService(UsbDevice device, String installpath)
			throws UsbException {
		INSTALL_PATH = installpath;
		CardReaderService crs = getInstance(device);
		return crs;
	}
	
	/**
	 * propertyt@CUsbDevicevendorIDK؂ȃNX̃CX^Xs܂
	 * Create an appropriate class's instance from vendorID of UsbDevice.
	 */
	private static CardReaderService getInstance(UsbDevice device) throws UsbException {
		/** propertiest@CǍ */
		/** read the property file */
		Properties pro = new Properties();
		InputStream in = null;
		try {
			File file = new File(INSTALL_PATH +  File.separator + property_file);
			in = new FileInputStream(file);
//			in = CardReaderManager.class.getClassLoader().getResourceAsStream(property_file);
			pro.load(in);
		} catch (IOException e) {
			System.err.println("not found the " + property_file + " file.");
		} finally {
			if(in != null)try{in.close();}catch(Exception e){}
		}

		Object class_obj = null;
		CardReaderService lise = null;
		
		String vender_id = UsbUtil.toHexString(device.getUsbDeviceDescriptor().idVendor());
		String product_id = UsbUtil.toHexString(device.getUsbDeviceDescriptor().idProduct());
		String bcdDevice = UsbUtil.toHexString(device.getUsbDeviceDescriptor().bcdDevice());
		Enumeration key = pro.keys(); 
		boolean flag = false;
		while(key.hasMoreElements()){
			Object key_obj = key.nextElement();
			if (key_obj instanceof String) {
				String key_info = (String) key_obj;
				DeviceProp dp = new DeviceProp(key_info);
				System.out.println("DeviceProp : " + dp.toString());
				
				if(vender_id.equals(dp.getVendor_id())&& 
						(product_id.equals(dp.getProduct_id())) && 
						(bcdDevice.equals(dp.getBcdDevice()))){
					flag = true;
					String class_name = pro.getProperty(key_info);

					//NX[_NX擾
					//get class from CardReaderManager.class's classLoader.
					try {
						Class class_cl = CardReaderManager.class.getClassLoader().loadClass(class_name);
						class_obj = class_cl.newInstance();
					} catch (ClassNotFoundException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e){
						e.printStackTrace();
					} catch (InstantiationException e){
						e.printStackTrace();
					}
					
					if (class_obj instanceof CardReaderService) {
						lise = (CardReaderService) class_obj;
						lise.setDevice(device);
					}
					break;
				}
			}
		}
		//If there is no vernderID in property file, please use GeneralCardReader.
		if(!flag){
			GeneralCardReader crs = new GeneralCardReader();
			lise = (CardReaderService) crs;
			lise.setDevice(device);
		}

		if(lise.equals(null)){
			throw new UsbException("CardReader is not registered.");
		}
		return lise;
	}
}
