/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: Waits for a card using javax.usb.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.app;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.event.UsbServicesEvent;
import javax.usb.event.UsbServicesListener;

import jp.co.ricoh.dsdk.ap.sample.localauth.auth.LoginService;
import jp.co.ricoh.dsdk.opt.auth.ccm.AlreadySetException;
import jp.co.ricoh.dsdk.usb.UsbDeviceManager;
import jp.co.ricoh.dsdk.usb.prox.CardListener;
import jp.co.ricoh.dsdk.usb.prox.CardReaderManager;
import jp.co.ricoh.dsdk.usb.prox.CardReaderService;

/**
 * ̃NX́Ajavax.usbgpCard̓Ǎ݂JnE~邽߂̃NXłB
 * CardWaiter is a class to start/stop reading Card using javax.usb. 
 */
public class CardWaiter {
	
	private CardReaderService service = null;
	private CardListener cardlistener = null;
	private LoginService ls;

	private static List readers = new ArrayList();
	private UsbDeviceManager deviceManager;
	private UsbServicesListener usbServicesListener;
	private static CardWaiter cardwaiterImpl = null;

	/**
	 * CardWaiter̃CX^X쐬܂B
	 * Creates the CardWaiter instance. 
	 */
	private CardWaiter() throws UsbException, IOException {
		initDeviceManager();
		this.ls = new LoginService();
	}
	
	/**
	 * USBDeviceManager̃CX^X擾܂
	 * Get the instance of USBDeviceManager.
	 */
	public static CardWaiter getInstance()throws UsbException{
		if(cardwaiterImpl == null){
			try {
				cardwaiterImpl = new CardWaiter();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return cardwaiterImpl;
	}
	
	private void initDeviceManager() {
		try {
			deviceManager = new UsbDeviceManager();
			usbServicesListener = new UsbServicesListener() {

				public void usbDeviceAttached(UsbServicesEvent event) {
					try {
						addDevice(event.getUsbDevice());
					} catch (UsbException e) {
						e.printStackTrace();
					}
				}

				public void usbDeviceDetached(UsbServicesEvent event) {
					UsbDevice device = event.getUsbDevice();
					for (int i = 0; i < readers.size(); i++) {
						CardReaderService reader = (CardReaderService) readers
								.get(i);
						if (reader.getDevice() == device) {
							readers.remove(i);
						}

					}
				}

			};
			deviceManager.addUsbServicesListener(usbServicesListener);

			if (deviceManager != null) {
				List devices = deviceManager.getDevices();
				for (Iterator iterator = devices.iterator(); iterator.hasNext();) {
					UsbDevice name = (UsbDevice) iterator.next();
					addDevice(name);
				}
			} else {
				throw new UsbException("DeviceManager is Null");
			}
		} catch (UsbException e) {
			e.printStackTrace();
		}
	}

	private void addDevice(UsbDevice name) throws UsbException {
		final CardReaderService reader = CardReaderManager
				.getCardReaderService(name, Activator.INSTALL_PATH);
		reader.addListener(new CardListener() {

			public void disconnect() {
				reader.stopReader();
				reader.removeListener(this);
			}

			public void readByte(byte[] data) {
				String cardId = new String(data);
				System.out.println("Card ID = " + cardId);
				ls.requestLogin(data);
			}

		});
		reader.startReader();
		readers.add(reader);
	}
    
	public void startReaders() {
		for (Iterator iterator = readers.iterator(); iterator.hasNext();) {
			CardReaderService reader = (CardReaderService) iterator.next();
			if (!reader.isReading()) {
				reader.startReader();
			}
		}
		try {
			ls.start();
		} catch (AlreadySetException e) {
			e.printStackTrace();
		}
	}

	public void stopReaders() {
		for (Iterator iterator = readers.iterator(); iterator.hasNext();) {
			CardReaderService reader = (CardReaderService) iterator.next();
			if (reader.isReading()) {
				reader.stopReader();
			}
		}
		ls.stop();
	}
    
}