/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: Encapsulates a login user.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.auth;

import java.util.Arrays;

import jp.co.ricoh.dsdk.ap.sample.localauth.util.HexUtil;

/**
 * このクラスは、ログインユーザをカプセル化したクラスです。
 * This is a class which encapsulates a login user.
 */
public class LoginUser {
	private byte[] id;
	private String loginName;
	private String loginPassword;
	
	/**
	 * LoginUserのインスタンスを生成します。
	 * Creates a LoginUser instance.
	 */
	public LoginUser(byte[] id, String loginName, String loginPassword) {
		if (id == null) id = new byte[0];
		if (loginName == null) loginName = "";
		if (loginPassword == null) loginPassword = "";
		this.id = id;
		this.loginName = loginName;
		this.loginPassword = loginPassword;
	}
	
	/**
	 * IDを取得します。
	 * Returns the ID.
	 */
	public byte[] getId() {
		return id;
	}
	
	/**
	 * IDを設定します。
	 * Sets the ID.
	 */
	public void setId(byte[] id) {
		if (id == null) id = new byte[0];
		this.id = id;
	}
	
	/**
	 * ログインユーザ名を取得します。
	 * Returns the login user name.
	 */
	public String getLoginName() {
		return loginName;
	}
	
	/**
	 * ログインユーザ名を設定します。
	 * Sets the login user name.
	 */
	public void setLoginName(String loginName) {
		if (loginName == null) loginName = "";
		this.loginName = loginName;
	}
	
	/**
	 * ログインパスワードを取得します。
	 * Returns the login password.
	 */
	public String getLoginPassword() {
		return loginPassword;
	}
	
	/**
	 * ログインパスワードを設定します。
	 * Sets the login password.
	 */
	public void setLoginPassword(String loginPassword) {
		if (loginPassword == null) loginPassword = "";
		this.loginPassword = loginPassword;
	}
	
	public boolean equals(LoginUser user) {
		if (!Arrays.equals(this.id, user.getId())) return false;
		if (!this.loginName.equals(user.getLoginName())) return false;
		if (!this.loginPassword.equals(user.getLoginPassword())) return false;
		return true;
	}
	
	public Object clone() {
		LoginUser _user = new LoginUser(null, null, null);
		byte[] _id = null;
		if (this.id != null) {
			_id = new byte[this.id.length];
			for (int i = 0; i < _id.length; i++) {
				_id[i] = id[i];
			}
		}
		_user.setId(_id);
		_user.setLoginName(new String(this.loginName));
		_user.setLoginPassword(new String(this.loginPassword));
		return _user;
	}
	
	public String toString() {
		return 
		"ID        : " + HexUtil.bytesToHexString(id) + '\n' +
		"LOGINNAME : " + loginName + '\n' + 
		"LOGINPASS : " +  loginPassword
		;
	}
}
