/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/




#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include <signal.h>

#include "rotate_api.h"
#include "map_mem.h"
#include "ROTATE_TOP_regstructs.h"

#include "logger.h"
#define DBG_PRFX "rotate: "
#define LOGGER_MODULE_MASK DEBUG_LOGGER_MODULE_PRINT | LOGGER_SUBMODULE_BIT( 18 )

#define	FILE_TYPE_BUFFER_SIZE	0x14
#define LINE_MAX_SIZE		0x80

#define	ROTATE_IMAGE_TILE_HEIGHT	0x40
#define	ROTATE_IMAGE_TILE_WIDTH		0x40


#define FILES_TO_BE_PROCESSED		0x10
ROTATE_ODMA_ROTATE_ODMA_UDMA_REGS_t *oudma_core;
ROTATE_ODMA_ROTATE_ODMA_CORE_REGS_t *odma_core;


static struct BigBuffer_s *in_buf_strip = NULL;
static struct BigBuffer_s **out_buf_strip = NULL;
int out_num_strips=0x00;

int main(int, char**);
int read_header(int fd, int *width, int *height, int *bpp, int *datapos, bool *ascii);
extern void logger_init();

struct in_strip_details
{
	int width;
	int height;
};

static void local_signal_handler( int exit_code ) 
{
    int i;
    uint8_t *out_data;
    printf("signal handler called %d\n", exit_code);
    


 //   dma_buffer_unmap_single(out_buf_strip[2], DMA_FROM_DEVICE);
 //   out_data = (uint8_t *)dma_buffer_mmap_forcpu(out_buf_strip[2]);
 //   printf("out_data %x\n", out_data);
    
  //  dump_buf(128, out_buf_strip[2]->datalen/128, 8, out_data);
#if 0
    reg32_dump_named((char *)oudma_core,
                   sizeof(ROTATE_IDMA_ROTATE_IDMA_CORE_REGS_t), "rotate_oudma_core_reg1");
    reg32_dump_named((char *)odma_core,
                   sizeof(ROTATE_ODMA_ROTATE_ODMA_CORE_REGS_t), "rotate_odma_core_reg");
#endif
    mapMem_destructor(); // free all memory maps to registers.
    mem_destructor();    // free all dma descriptors
    for (i=0;i<out_num_strips;i++) 
    {
        BigBuffer_Free(out_buf_strip[i]);
    }
    BigBuffer_Free(in_buf_strip);
    exit( exit_code );
}


int read_header(int fd, int *width, int *height, int *bpp, int *datapos, bool *ascii)
{
	char buf[LINE_MAX_SIZE];
	char tmp[LINE_MAX_SIZE];
	int bytesread=0;
	int i,j, prevpos=0, curpos=0;
        int max_val;

	memset(buf, 0x00, LINE_MAX_SIZE);
	bytesread = read(fd, buf, LINE_MAX_SIZE);
        *ascii = false;


	if (bytesread <=0){
		perror("File read error");
		*width = *height = *datapos = 0x00;
		return -1;
	}

	for (i=0; i<LINE_MAX_SIZE; i++){
		if ('\n' == buf[i] ||
				'\r' == buf[i]){
			/*printf("\n New line hit at %d datapos = %d\n",
					i, (i+1));*/
			*datapos = (i+1);
			break;
		}
	}

	for(i=0; i<*datapos; i++){
		if(buf[i] == 32){
			curpos = i;
			break;
		}
	}


        if (strncmp(&buf[prevpos], "P2", 2) ==0)
        {
            printf("%s %d: Got a P2 file \n", __func__, __LINE__);
            *ascii = true;
            prevpos = curpos + 1;
            for(i=prevpos, j=0; i<*datapos; i++, j++){
                    if(buf[i] == 32){
                            curpos = i;
                            tmp[j] = '\0';
                            break;
                    }
                    tmp[j] = buf[i];
            }

            *width = atoi(tmp);
            printf("width %d string %s\n", *width, tmp);
            prevpos = curpos+1;
            for(i=prevpos, j=0; i<*datapos; i++, j++){
                    if(buf[i] == 32 ||
                                    '\n' == buf[i] ||
                                    '\r' == buf[i]){
                            curpos = i;
                            tmp[j] = '\0';
                            break;
                    }
                    tmp[j] = buf[i];
            }
            printf("\nData in tmp is %s\n", tmp);
            *height = atoi(tmp);

            prevpos = curpos+1;
            for(i=prevpos, j=0; i<*datapos; i++, j++){
                    if(buf[i] == 32 ||
                                    '\n' == buf[i] ||
                                    '\r' == buf[i]){
                            curpos = i;
                            tmp[j] = '\0';
                            break;
                    }
                    tmp[j] = buf[i];
            }
            /*printf("\nData in tmp is %s\n", tmp);*/
            max_val = atoi(tmp);
            *bpp = 8;
        }
  //      printf("hello again %s prevpos %d\n"&buf[prevpos], prevpos);
        if (strncmp(&buf[prevpos], "P5", 2) == 0)
        {
            printf("%s %d: Got a P5 file \n", __func__, __LINE__);
            prevpos = curpos + 1;
            for(i=prevpos, j=0; i<*datapos; i++, j++){
                    if(buf[i] == 32){
                            curpos = i;
                            tmp[j] = '\0';
                            break;
                    }
                    tmp[j] = buf[i];
            }

            *width = atoi(tmp);
            printf("width %d\n", *width);
            prevpos = curpos+1;
            for(i=prevpos, j=0; i<*datapos; i++, j++){
                    if(buf[i] == 32 ||
                                    '\n' == buf[i] ||
                                    '\r' == buf[i]){
                            curpos = i;
                            tmp[j] = '\0';
                            break;
                    }
                    tmp[j] = buf[i];
            }
            /*printf("\nData in tmp is %s\n", tmp);*/
            *height = atoi(tmp);

            prevpos = curpos+1;
            for(i=prevpos, j=0; i<*datapos; i++, j++){
                    if(buf[i] == 32 ||
                                    '\n' == buf[i] ||
                                    '\r' == buf[i]){
                            curpos = i;
                            tmp[j] = '\0';
                            break;
                    }
                    tmp[j] = buf[i];
            }
            /*printf("\nData in tmp is %s\n", tmp);*/
            max_val = atoi(tmp);
            *bpp = 8;
            if (max_val == 255)
            {
                *bpp = 8;
            }
        }

        if (strncmp(&buf[prevpos], "P6", 2) ==0)
        {
            printf("%s %d: Got a P6 file \n", __func__, __LINE__);
            prevpos = curpos + 1;
            for(i=prevpos, j=0; i<*datapos; i++, j++){
                    if(buf[i] == 32){
                            curpos = i;
                            tmp[j] = '\0';
                            break;
                    }
                    tmp[j] = buf[i];
            }

            *width = atoi(tmp);
            printf("width %d \n", *width);
            prevpos = curpos+1;
            for(i=prevpos, j=0; i<*datapos; i++, j++){
                    if(buf[i] == 32 ||
                                    '\n' == buf[i] ||
                                    '\r' == buf[i]){
                            curpos = i;
                            tmp[j] = '\0';
                            break;
                    }
                    tmp[j] = buf[i];
            }
            /*printf("\nData in tmp is %s\n", tmp);*/
            *height = atoi(tmp);

            prevpos = curpos+1;
            for(i=prevpos, j=0; i<*datapos; i++, j++){
                    if(buf[i] == 32 ||
                                    '\n' == buf[i] ||
                                    '\r' == buf[i]){
                            curpos = i;
                            tmp[j] = '\0';
                            break;
                    }
                    tmp[j] = buf[i];
            }
            /*printf("\nData in tmp is %s\n", tmp);*/
            max_val = atoi(tmp);
            *bpp = 24;
        }
        if(!strncmp(&buf[prevpos], "P4", curpos-prevpos-1) ||
			!strncmp(&buf[prevpos], "p4", curpos-prevpos-1)){
		printf("\n File is a P4 file\n");
		prevpos = curpos+1;
		for(i=prevpos, j=0; i<*datapos; i++, j++){
			if(buf[i] == 32){
				curpos = i;
				tmp[j] = '\0';
				break;
			}
			tmp[j] = buf[i];
		}
		/*printf("\nData in tmp is %s\n", tmp);*/
		*width = atoi(tmp);
		prevpos = curpos+1;
		for(i=prevpos, j=0; i<*datapos; i++, j++){
			if(buf[i] == 32 ||
					'\n' == buf[i] ||
					'\r' == buf[i]){
				curpos = i;
				tmp[j] = '\0';
				break;
			}
			tmp[j] = buf[i];
		}
		/*printf("\nData in tmp is %s\n", tmp);*/
		*height = atoi(tmp);
                *bpp = 1;
	}



	return 0x00;
}


void dump_buf(uint32_t image_height, uint32_t image_width, uint32_t bpp, uint8_t *out_data)
{

        uint32_t i,j;
        for (i = 0; i < image_height; i++)
        {
            printf("Line %d ", i);
            for (j = 0; j < (bpp * image_width)/8; j++)
            {
                if ((j % 32) == 0)
                {
                    printf("\n");
                }
                if ((j % 4) == 0)
                {
                    printf(" ");
                }
                printf("%02x", out_data[i * ((bpp * image_width) / 8) + j]); 
            }
            printf("\n");
        }
}

int find_num(char *buf, uint32_t length)
{
    uint32_t i;
    for (i = 0; i < length; i++)
    {
        if ((buf[i] >= '0' && buf[i] <='9') || buf[i] == '\n')
        {
            return i;
        }
    }
    return 0;
}
int find_white(char *buf, uint32_t length)
{
    uint32_t i;
    for (i = 0; i < length; i++)
    {
        if (buf[i] == ' ' || buf[i] == '\n')
        {
            return i;
        }
    }
    return 0;
}
    void hex_dump_named(void *start_addr, int size, char* region_name);

int main(int argc, char **argv)
{
        int rotate_angle = 0;
	struct dirent **filelist;
	int i,n,fd,file_size;
	int width, height, datastartpos, dst_image_size=0;
	int image_width=0, image_height=0, pad_size=0;
	int ret = 0x00, num_strips=0x00;
	char *tmpbuf = NULL;
	struct rotate_and_place_s *rotate;
	int strip_height = 0x00;
	char temp_str[80];
        FILE *fo;
	struct in_strip_details *in_strip_details = NULL;
        uint8_t *out_data;
        int offset_x, offset_y;
        int bpp;
	char buf[LINE_MAX_SIZE];
        bool ascii;
        uint32_t total_read;
	FILE *imagepowerfile;

      //  struct rotate_udma_desc_s *in_desc, *out_desc;
//	void *hw_addr, *bb_hw_addr;

	if (argc<=1) {
		printf("dir input is invalid\n");
		return 0x01;
	}

	printf("%s %d: Entry \n", __func__, __LINE__);
	imagepowerfile = fopen("/dev/imagepower", "r");
	memInitMemory( 0, 1024*1024*128 );
	printf("%s %d: Entry \n", __func__, __LINE__);
	logger_init();
	printf("%s %d: Entry\n", __func__, __LINE__);
	uio_lib_init();    
        signal(SIGINT,  local_signal_handler);
        signal(SIGTERM, local_signal_handler);
        signal(SIGSEGV, local_signal_handler); 


	n = scandir(argv[1], &filelist, 0, alphasort);
	if (n < 0) {
		perror("scandir");
		return 0x01;
	}
        // rotate 0 y-flip 1
	num_strips = n - 2;

        in_strip_details = (struct in_strip_details*) MEM_MALLOC(
			sizeof(struct in_strip_details)*num_strips);


	if (!in_strip_details) {
		perror("Memory allocation failed");
		goto out;
	}
        
	for (i = 0; i < n; i++) {
		if (!strcmp(filelist[i]->d_name, ".") ||
				!strcmp(filelist[i]->d_name, ".."))
			continue;
		strcpy(temp_str, argv[1]);
		strcat(temp_str, "/");
		strcat(temp_str, filelist[i]->d_name);
                printf("File name %s\n", temp_str);
		fd = open(temp_str, O_RDONLY);

		if (0x00>fd) {
			perror("failed to open file\n");
			printf("Failed open\n");
			continue;
		}

		read_header(fd, &width, &height, &bpp, &datastartpos, &ascii);
		image_width = width;
		image_height += height;


		printf("%s %d: Entry i=%d width = %d height=%d\n",
				__func__, __LINE__, i, width, height);
		printf("%s %d: Entry i=%d strip_height = %d\n",
				__func__, __LINE__, i, strip_height);

		in_strip_details[i-2].width = width;
		in_strip_details[i-2].height = height;

		close(fd);
	}
        strip_height = 128;
      //  image_width = 96;
        image_width = 2048*2;
        image_height = 4096;
        offset_x = 0;
        offset_y = 0;

	printf("%s %d: image_width = %d\n", __func__, __LINE__, image_width);
	printf("%s %d: image_height = %d\n", __func__, __LINE__, image_height);
	//if (image_height%128 != 0x00)
//		pad_size = 128 - image_height%128;

	out_num_strips = image_height / strip_height;	//0
	if ((image_height % in_strip_details[0].height))
		out_num_strips++;

	out_buf_strip = (struct BigBuffer_s**) MEM_MALLOC(
			sizeof(struct BigBuffer_s*)*out_num_strips);


//	out_buf_strip = (struct BigBuffer_s**) MEM_MALLOC(
//			sizeof(struct BigBuffer_s*)*out_num_strips);
	printf("%s %d: out_num_strips %d\n", __func__, __LINE__,out_num_strips);
	if (!out_buf_strip) {
		perror("Memory allocation failed");
		goto out;
	}

	for (i=0;i<out_num_strips;i++) 
        {
            printf("width %d height %d bpp %d\n",image_width,strip_height,bpp);
		out_buf_strip[i] = dma_buffer_malloc(0,
				((image_width*strip_height*
				  bpp)/8));


                dma_buffer_map_single(out_buf_strip[i], DMA_FROM_DEVICE);
                dma_buffer_unmap_single(out_buf_strip[i], DMA_FROM_DEVICE);
                out_data = (uint8_t *)dma_buffer_mmap_forcpu(out_buf_strip[i]);
                printf("DATA length %d i %d address %x\n", out_buf_strip[i]->datalen, i, out_data);
                memset(out_data, 0xff, out_buf_strip[i]->datalen);
                out_data[0] = 0xa0+i;
                dma_buffer_unmmap_forcpu(out_buf_strip[i]); 
	}


	/*rotate = rotate_and_place_start(image_width, image_height,*/

	rotate = rotate_and_place_start(image_width, image_height,
			bpp, strip_height,
			out_num_strips, out_buf_strip);

//	printf("%s %d: Entry\n", __func_	void *hw_addr_, __LINE__);
	if (!rotate) {
		perror("Rotate Initialization failed");
		return 0x00;
	}
        #if 0
	if (rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
			0, 0,
			/*image_height, image_width)) {*/
			in_strip_details[0].width, in_strip_details[0].height)) {
	printf("%s %d: Entry\n", __func__, __LINE__);
		perror("Adding image to rotate failed");
		return 0x00;
	}
#endif
	dst_image_size = bpp *
		(image_width*(image_height+pad_size)/8);

	printf("%s %d: imagesize %d\n", __func__, __LINE__, dst_image_size);
	if (!dst_image_size){
		printf("\nDestination Image output size is invalid\n");
		goto out;
	}

	printf("%s %d: Entry\n", __func__, __LINE__);
	for (i=0; i < n; i++) 
        {
            uint32_t current_file_pos, out_file_pos;

		if (!strcmp(filelist[i]->d_name, ".") ||
				!strcmp(filelist[i]->d_name, ".."))
			continue;
		strcpy(temp_str, argv[1]);
		strcat(temp_str, "/");
		strcat(temp_str, filelist[i]->d_name);

		fd = open(temp_str, O_RDONLY);

		if (0x00>fd) {
                    printf("File name %s\n", temp_str);
                        perror("hello");
			perror("failed to open file\n");
			continue;
		}

	printf("%s %d: In strip loop %d\n", __func__, __LINE__,i);
		read_header(fd, &width, &height, &bpp, &datastartpos, &ascii);
	printf("wid %d hei %d start %d\n",width, height, datastartpos);
		file_size = lseek(fd, 0x00, SEEK_END);
	printf("file size %d\n",file_size);
		lseek(fd, 0x00, SEEK_SET);
	//printf("%s %d: Entry\n", __func__, __LINE__);
		tmpbuf = malloc((bpp*width*height)/8 + 0x100);
	printf("%s %d: Entry tmpbuf %x\n", __func__, __LINE__, tmpbuf);
		if(!tmpbuf)
			continue;
	printf("%s %d: Entry datastartpos %d\n", __func__, __LINE__, datastartpos);
		ret = read(fd, tmpbuf, datastartpos);
                printf("%s %d: Entry ascii %d\n", __func__, __LINE__, ascii);
                #if 1
                if (ascii)
                {
                    uint32_t now_pos = 0;
                    uint32_t amt_in_buf = 0;
                    uint32_t temp;
                    bool first_side = false;

                    current_file_pos = 0;
                    out_file_pos = 0;
                    printf("%s %d: Entry\n", __func__, __LINE__);
                    while (ret >= 0 && current_file_pos < width * height)
                    {
                        ret = read(fd, &buf[amt_in_buf], LINE_MAX_SIZE - amt_in_buf);
                        if (ret < 0)
                        {
                            break;
                        }
                        ret += amt_in_buf;
                        now_pos = current_file_pos;
                        while (1)
                        {        
                            temp = find_num(&buf[current_file_pos], LINE_MAX_SIZE - current_file_pos);
                            current_file_pos += temp;
                            if (ret < 0 || buf[current_file_pos] == '\n')
                            {
                                current_file_pos++;     // skip the cr
                                break;
                            }
                            #if 0
                            if (first_side)
                            {
                                first_side = false;
                                tmpbuf[out_file_pos++] |= atoi(&buf[current_file_pos])/16;
                            } else
                            {
                                first_side = true;
                                tmpbuf[out_file_pos] = (atoi(&buf[current_file_pos])/16)<<4; 
                            }
                            #endif
                            tmpbuf[out_file_pos++] = atoi(&buf[current_file_pos]);
                       //     printf("value %x current_file_pos %d out %d\n", tmpbuf[out_file_pos -1], current_file_pos, out_file_pos);
                            current_file_pos += find_white(&buf[current_file_pos], LINE_MAX_SIZE - current_file_pos);
                        }
                        memcpy(buf, &buf[current_file_pos - now_pos], ret-(current_file_pos - now_pos));
                        amt_in_buf = ret - (current_file_pos - now_pos);
                        current_file_pos = 0;
                    }
                    ret = out_file_pos;
                } else
                #endif
                {   
                    total_read = 0;
                    while (total_read < (file_size - datastartpos))
                    {
                        ret = read(fd, &tmpbuf[total_read], file_size - datastartpos-total_read); 
                        if (ret < 0)
                        {
                            continue;
                        }
                        printf("total_read %d\n", total_read);
                        total_read += ret;
                    }
                }
                #if 0
                fo = fopen("lena.pgm", "w");
                fwrite(tmpbuf, 1, height * width,fo);
                fclose(fo);
                #endif
	printf("%s %d: Entry\n", __func__, __LINE__);
		if (ret<0) {
			printf("%s %d: Entry\n", __func__, __LINE__);
			continue;
		}
                printf("input buffer %x %x %x %x\n", tmpbuf[0],tmpbuf[1],tmpbuf[2],tmpbuf[3]);
                printf("input buffer %x %x %x %x\n", tmpbuf[4],tmpbuf[5],tmpbuf[6],tmpbuf[7]);

       //         dump_buf(image_height,image_width,(uint8_t *)tmpbuf);
                printf("%s %d: Entry ret %d\n", __func__, __LINE__, ret);
		in_buf_strip = dma_buffer_adopt(tmpbuf, ret);

	//printf("%s %d: Entry\n", __func__, __LINE__);
		printf("Before retate and place height %d\n", height);
#if 0
                if (rotate_and_place_add_strip(rotate, height, in_buf_strip)) {
			perror("Adding data strip to rotate failed");
		}
                #endif
         //      rotate_and_place_add_strip(rotate, height, in_buf_strip);
	//printf("%s %d: Entry\n", __func__, __LINE__);
		close(fd);
	//printf("%s %d: Entry\n", __func__, __LINE__);
		//dma_buffer_free(in_buf_strip);
		//free(tmpbuf);
	//printf("%s %d: Entry\n", __func__, __LINE__);
	}

//	rotate = rotate_and_place_close(rotate);


//	rotate = rotate_and_place_start(image_width, image_height,
//			bpp, strip_height,
//			out_num_strips, out_buf_strip);

        ret = in_strip_details[0].height;
        if (ret < in_strip_details[0].width)
        {
            ret = in_strip_details[0].width;
        }
        #if 0
        offset_x = 0;
        offset_y = 0;
        rotate_and_place_add_image(rotate, offset_x, offset_y, 180,
                        0, 0, in_strip_details[0].width, in_strip_details[0].height*5);
        rotate_and_place_add_strip(rotate, height, in_buf_strip);
        rotate_and_place_add_strip(rotate, height, in_buf_strip);
        rotate_and_place_add_strip(rotate, height, in_buf_strip);
        #endif
        for (i = 0; i < 1; i++)
        {
            n = 2048 * i;
            offset_x = n; 
            offset_y = 4*(512+32)*i;
#if 0
    #if 1
            rotate_angle = 0;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 0, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);

           #endif
           #if 1
            offset_x += ret + 32;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            1, 0, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            #endif
            #if 1
            // rotate 0 y-flip 1
            offset_x += ret+32;
            rotate_angle = 0;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 1, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);

            #endif
            #if 1
            // 90 rotate
   //         offset_y = 0;
    //        offset_x = 0;
            #endif
            offset_x = n;
            offset_y += ret+32;
            #if 1
            rotate_angle = 90;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 0, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            #endif
            #if 1
            // rotate 90 x-flip 1
            rotate_angle = 90;
            offset_x += ret+32;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            1, 0, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            #endif
            #if 1
            //rotate 90 y-flip 1
            rotate_angle = 90;
            offset_x += ret+32;
        //  offset_x = 1088;
        //  offset_y = 544;
            rotate_angle = 90;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 1, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);

            #endif
            // 180 rotate
      //      offset_y = 1088;
            offset_x = n;
            offset_y += ret+32;
            #if 1
            rotate_angle = 180;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 0, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            #endif
            // rotate 180 x-flip 1
            #if 1
            rotate_angle = 180;
          //  offset_x = 0;
            offset_x += ret+32;
        //    offset_y = 608;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            1, 0, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            #endif
            #if 1
            // rotate 180 y-flip 1
            offset_x += ret+32;
            rotate_angle = 180;
      //      offset_x = 0;
      //      offset_y = 32;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 1, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);

            #endif
            #if 0
            // 270 rotate

         //   offset_y = 32;
            offset_y += ret+32;
            #endif
            #if 1
            offset_y += ret+32;
            offset_x = n;
            rotate_angle = 270;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 0, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            #endif
            #if 1
            // rotate 270 x-flip 1
            offset_x += ret+32;
            rotate_angle = 270;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            1, 0, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            #endif
            #if 1
            // rotate 270 y-flip 1
            offset_x += ret+32;        
            rotate_angle = 270;

            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 1, in_strip_details[0].width, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
           #endif
#endif
#if 0
            n += 512*3+256+128;;
            offset_x = n;
            offset_y = 0;
            rotate_angle = 0;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 0, in_strip_details[0].width, in_strip_details[0].height*3);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);

            offset_x += 512+32;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            1, 0, in_strip_details[0].width, in_strip_details[0].height*3);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            offset_x += 512+32;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 1, in_strip_details[0].width, in_strip_details[0].height*3);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);

            offset_x = n;
            offset_y = 512*3+32;
            rotate_angle = 90;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 0, in_strip_details[0].width*4, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);

            offset_x = n;
            offset_y += 512+32;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            1, 0, in_strip_details[0].width*4, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            offset_y += 512+32;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 1, in_strip_details[0].width*4, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);


            offset_x = n;
            offset_y += 512+32;
            rotate_angle = 270;

            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 0, in_strip_details[0].width*4, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);

            offset_x = n;
            offset_y += (512+32);
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            1, 0, in_strip_details[0].width*4, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
#if 1
            offset_y += 512+32;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 1, in_strip_details[0].width*4, in_strip_details[0].height);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
 #endif
 #endif
            n = 0;
            offset_x = n;
            offset_y = 4*(512+32);
            rotate_angle = 180;

#if 0
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 0, in_strip_details[0].width, in_strip_details[0].height*3);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);

            offset_x += (512+32);
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            1, 0, in_strip_details[0].width, in_strip_details[0].height*3);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            offset_x += 512+32;
            rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                            0, 1, in_strip_details[0].width, in_strip_details[0].height*3);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
            rotate_and_place_add_strip(rotate, height, in_buf_strip);
 #endif
 #if 1
            
            offset_y += 3*(512+32)+128 +24;
            offset_x = 0;
            offset_y = 0;
            for(rotate_angle = 0, offset_x = 0; rotate_angle <360; rotate_angle += 90)
            {
                int temp_y;
     //           offset_x = 22;
                offset_y = rotate_angle/90 * (512+256) + 32;
                offset_x = 0;
                temp_y = offset_y;
                rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                                0, 0, in_strip_details[0].width, in_strip_details[0].height);
                rotate_and_place_add_strip(rotate, height, in_buf_strip);
                #if 1
                for (n = 0; n < 64; n++)
                {
                    offset_y += 4; 
                    offset_x += 4;

                    rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                                    0, 0, in_strip_details[0].width, in_strip_details[0].height);
                    rotate_and_place_add_strip(rotate, height, in_buf_strip);
                }
                #endif
                offset_y = temp_y;
                offset_x += 512;
                rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                                1, 0, in_strip_details[0].width, in_strip_details[0].height);
                rotate_and_place_add_strip(rotate, height, in_buf_strip);
                for (n = 0; n < 64; n++)
                {
                    offset_y += 4; 
                    offset_x += 4;

                    rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                                    1, 0, in_strip_details[0].width, in_strip_details[0].height);
                    rotate_and_place_add_strip(rotate, height, in_buf_strip);
                }
                offset_x += 512;
                offset_y = temp_y;
                rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                                0, 1, in_strip_details[0].width, in_strip_details[0].height);
                rotate_and_place_add_strip(rotate, height, in_buf_strip);
                for (n = 0; n < 64; n++)
                {
                    offset_y += 4; 
                    offset_x += 4;

                    rotate_and_place_add_image(rotate, offset_x, offset_y, rotate_angle,
                                    0, 1, in_strip_details[0].width, in_strip_details[0].height);
                    rotate_and_place_add_strip(rotate, height, in_buf_strip);
                }
            }
#endif

        }
        rotate = rotate_and_place_close(rotate);
        mapMem_destructor(); // new attempt at not having a permanently running application.
        mem_destructor(); // new attempt at not having a permanently running application.
#if 1
        fo = fopen("outbuf.pbm", "w");

        if (0x00>fo) {
                perror("failed to open file\n");
                printf("Failed open\n");
        }      
        printf("Got to here\n");  
	if (bpp == 24) {
                sprintf(temp_str,"P6 %d %d 255\n", image_width, image_height);
        } else if (bpp == 8) {
                sprintf(temp_str,"P5 %d %d 255\n", image_width, image_height);
        } else {
                sprintf(temp_str, "P4 %d %d\n", image_width, image_height);
        }
        fwrite(temp_str, 1, strlen(temp_str), fo);
        for (i = 0; i < out_num_strips; i++)
        {
            dma_buffer_unmap_single(out_buf_strip[i], DMA_FROM_DEVICE); 
            out_data = (uint8_t *)dma_buffer_mmap_forcpu(out_buf_strip[i]);
            fwrite(out_data, 1, out_buf_strip[i]->datalen,fo);
        }
        fclose(fo);

#endif
        #if 0
        dma_buffer_unmap_single(out_buf_strip[0], DMA_FROM_DEVICE);
        out_data = (uint8_t *)dma_buffer_mmap_forcpu(out_buf_strip[0]);
        dump_buf(strip_height,image_width, bpp, out_data);
        printf("Strip 1\n");
        dma_buffer_unmap_single(out_buf_strip[1], DMA_FROM_DEVICE);
        out_data = (uint8_t *)dma_buffer_mmap_forcpu(out_buf_strip[1]);
        dump_buf(strip_height,image_width, bpp, out_data);
        #endif

 //       printf("%x %x\n", ((uint32_t *)out_data)[0], ((uint32_t *)out_data)[1]); 
out:
	free(filelist);
	for (i=0;i<out_num_strips;i++) 
        {
            BigBuffer_Free(out_buf_strip[i]);
        }
        BigBuffer_Free(in_buf_strip);
	fclose(imagepowerfile);
	return 0;
}
