/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2009 - 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/**
  *
  *This file contains hardware setup private definitions for Rotate
  *
 **/

#if !defined(__ROTATE_HW_PRIV_H__)
#define __ROTATE_HW_PRIV_H__

#ifndef _ALLOW_ROTATE_PRIV_INCLUSION_H
#error "Don't include rotate-setup-private.h directly, instead use \"rotate_api.h\""
#endif

#include <stdint.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <stdint.h>
#include <stdbool.h>

#include "ROTATE_TOP_regstructs.h"
#include "ROTATE_TOP_regmasks.h"
#include "regAddrs.h"
#include "error_types.h"
#include "lassert.h"
#include "dprintf.h"
#include "uio_lib_api.h"
#include "logger.h"

#define	ROTATE_CORE_REG_BASE	IPS_ROTATE_TOP_ROTATE_CORE_BASE
#define	ROTATE_IDMA_CORE_REG_BASE \
	IPS_ROTATE_TOP_ROTATE_IDMA_ROTATE_IDMA_CORE_BASE
#define	ROTATE_IUDMA_REG_BASE \
	IPS_ROTATE_TOP_ROTATE_IDMA_ROTATE_IDMA_UDMA_BASE
#define	ROTATE_ODMA_CORE_REG_BASE \
	IPS_ROTATE_TOP_ROTATE_ODMA_ROTATE_ODMA_CORE_BASE
#define	ROTATE_OUDMA_REG_BASE \
	IPS_ROTATE_TOP_ROTATE_ODMA_ROTATE_ODMA_UDMA_BASE

struct rotate_device
{
	ROTATE_CORE_REGS_t *rotate_core_regs;
	ROTATE_IDMA_ROTATE_IDMA_UDMA_REGS_t *rotate_iudma_regs;
	ROTATE_IDMA_ROTATE_IDMA_CORE_REGS_t *rotate_idma_core_regs;
	ROTATE_ODMA_ROTATE_ODMA_UDMA_REGS_t *rotate_oudma_regs;
	ROTATE_ODMA_ROTATE_ODMA_CORE_REGS_t *rotate_odma_core_regs;
	int (*notify_idma_interrupt)();
	int (*notify_iudma_interrupt)();
	int (*notify_odma_interrupt)();
	int (*notify_oudma_interrupt)();
};

enum interrupt_cause
{
        INT_COMPLETE = 0x00,
	INT_IDMA_LEN_ERROR,
	INT_ODMA_LEN_ERROR,
	INT_IUDMA_LEN_ERROR,
	INT_OUDMA_LEN_ERROR,
	INTR_MAX,
};

extern int init_rotate_hardware(struct rotate_device*);
extern int uninitialize_rotate_hardware(struct rotate_device*);

#endif /* __ROTATE_HW_PRIV_H__ */

