
/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

        
/**
      \file /Volumes/MRVL_TCrypt/G2/Gr2_R4_WTM/R4_Test/include/intnums.h

      Defines for the interrupt numbers for the main processor
      */

#ifndef __INTNUMS_H__
#define __INTNUMS_H__


#ifdef __cplusplus
extern "C" {
#endif


/*
	Interrupts on the GIC
*/

#define INTNUM_SSP1_INT_REQ_SSP1            		(32)		//ssp1_int_req (SSP1)(APB_TOP)
#define INTNUM_SSP2_INT_REQ_SSP2            		(33)		//ssp2_int_req (SSP2) (APB_TOP)
#define INTNUM_CORE_CSSCG                   		(34)		//CORE_CSSCG(From MPMU)
#define INTNUM_DDR_CSSCG                    		(35)		//DDR_CSSCG(From MPMU)
#define INTNUM_SCAN_CSSCG                   		(36)		//SCAN_CSSCG (from MPMU)
#define INTNUM_MPMU_IRQ                     		(37)		//MPMU_IRQ (From MPMU)
#define INTNUM_APMU_IRQ                     		(38)		//APMU_IRQ (From APMU)
#define INTNUM_TWSI1_INT_I2C_APB_TOP        		(39)		//twsi1_int (I2C-APB_TOP)
#define INTNUM_DMA_CHANNEL_INT              		(40)		//|dma_channel_int
#define INTNUM_ONEWIRE_INT                  		(41)		//onewire_int (APB_AON)
#define INTNUM_TIMER_1_IRQ                  		(42)		//timer_1_irq(APB_AON)
#define INTNUM_TIMER_2_IRQ                  		(43)		//timer_2_irq(APB_AON)
#define INTNUM_TIMER_3_IRQ                  		(44)		//timer_3_irq(APB_AON)
#define INTNUM_IPC0_WAKEUP                  		(45)		//ipc0_wakeup(APB_AON)
#define INTNUM_SSP3_INT_REQ_SSP3            		(46)		//ssp3_int_req (SSP3)(APB_TOP)
#define INTNUM_LAN_GMAC_INT                 		(47)		//lan_gmac_int
#define INTNUM_UART_INT_UART1               		(48)		//uart_int (UART1)(APB_AON)
#define INTNUM_UART_INT_UART2               		(49)		//uart_int (UART2)(APB_AON)
#define INTNUM_UART_INT_UART3               		(50)		//uart_int (UART3)(APB_AON)
#define INTNUM_UART_INT_UART4               		(51)		//uart_int (UART4)(APB_AON)
#define INTNUM_DM2_PCIE_IRQ                 		(52)		//Dm2_PCIe_IRQ
#define INTNUM_DM4_PCIE_IRQ                 		(53)		//Dm4_PCIe_IRQ
#define INTNUM_AP_SCCP_IRQ                  		(54)		//AP_SCCP_IRQ
#define INTNUM_WDT_IRQ_WATCH_DOG_TIMER      		(55)		//wdt_irq (Watch Dog Timer)(APB_AON)
#define INTNUM_NDSMC_DMA_INTR               		(56)		//ndsmc_dma_intr
#define INTNUM_MMC1_INT_SEPERATED           		(57)		//mmc1_int | sdh2icu_wakeup_int1
#define INTNUM_SDH2ICU_WAKEUP_INT1_SEPERATED		(57)		//mmc1_int | sdh2icu_wakeup_int1
#define INTNUM_MMC1_INT_OR_SDH2ICU_WAKEUP_INT1		(57)		//mmc1_int | sdh2icu_wakeup_int1
#define INTNUM_WTM_HST_INT_OUT              		(58)		//wtm_hst_int_out
#define INTNUM_LCD_IRQ                      		(59)		//lcd_irq
#define INTNUM_QS_IRQ_BOOTSPI               		(60)		//qs_irq (BootSPI)
#define INTNUM_USB2H_IRQ                    		(61)		//usb2H IRQ
#define INTNUM_USB2DUAL_IRQ                 		(62)		//usb2Dual_irq
#define INTNUM_USB3H_IRQ                    		(63)		//usb3H_irq
#define INTNUM_USB3D_IRQ                    		(64)		//usb3D_irq
#define INTNUM_ND2ICU_INT_NAND              		(65)		//nd2icu_int (NAND)
#define INTNUM_SATA_INT_PENDINGIO_WRAP      		(66)		//sata_int_pending(IO_WRAP)
#define INTNUM_SATA_PME_INTIO_WRAP          		(67)		//sata_pme_int(IO_WRAP)
#define INTNUM_SCM_GPIO_ORED_INT_AP         		(68)		//scm_gpio_ored_int_ap (??)
#define INTNUM_WTM_SP_INT_OUT               		(69)		//wtm_sp_int_out
#define INTNUM_MMC2_INT_SEPERATED           		(70)		//mmc2_int | sdh2icu_wakeup_int2
#define INTNUM_SDH2ICU_WAKEUP_INT2_SEPERATED		(70)		//mmc2_int | sdh2icu_wakeup_int2
#define INTNUM_MMC2_INT_OR_SDH2ICU_WAKEUP_INT2		(70)		//mmc2_int | sdh2icu_wakeup_int2
#define INTNUM_MMC3_INT_SEPERATED           		(71)		//mmc3_int | sdh2icu_wakeup_int3
#define INTNUM_SDH2ICU_WAKEUP_INT3_SEPERATED		(71)		//mmc3_int | sdh2icu_wakeup_int3
#define INTNUM_MMC3_INT_OR_SDH2ICU_WAKEUP_INT3		(71)		//mmc3_int | sdh2icu_wakeup_int3
#define INTNUM_IPC1_WAKEUP                  		(72)		//ipc1_wakeup(APB_TOP)
#define INTNUM_SM_INT_SMEMC                 		(73)		//sm_int (SMEMC)
#define INTNUM_SDH2ICU_WAKEUP_INT1          		(74)		//sdh2icu_wakeup_int1
#define INTNUM_MMC1_INT                     		(75)		//mmc1_int
#define INTNUM_SDH2ICU_WAKEUP_INT2          		(76)		//sdh2icu_wakeup_int2
#define INTNUM_MMC2_INT                     		(77)		//mmc2_int
#define INTNUM_SDH2ICU_WAKEUP_INT3          		(78)		//sdh2icu_wakeup_int3
#define INTNUM_MMC3_INT                     		(81)		//mmc3_int
#define INTNUM_M1_PMIC_INT_EDGE_DETECTED    		(82)		//m1_PMIC_INT_edge_detected
#define INTNUM_XAQ2_INTR_GC4                		(85)		//xaq2_intr (GC4)
#define INTNUM_TWSI2_INTI2C_APB_TOP         		(86)		//twsi2_int(I2C-APB_TOP)
#define INTNUM_TWSI5_INTI2C_APB_TOP         		(87)		//twsi5_int(I2C-APB_TOP)
#define INTNUM_TWSI4_INTI2C_APB_TOP         		(88)		//twsi4_int(I2C-APB_TOP)
#define INTNUM_CDMAINT_0                    		(89)		//CDMAInt[0]
#define INTNUM_CDMAINT_1                    		(90)		//CDMAInt[1]
#define INTNUM_R4_NPMUIRQ                   		(91)		//R4_nPMUIRQ
#define INTNUM_R4_NVALFIQ                   		(92)		//R4_nVALFIQ
#define INTNUM_R4_NVALIRQ                   		(93)		//R4_nVALIRQ
#define INTNUM_R4_NCTIIRQ                   		(94)		//R4_nCTIIRQ
#define INTNUM_APCPU_NAXIERRIRQ             		(95)		//apcpu_nAXIERRIRQ
#define INTNUM_APCPU_NINTERRIRQ             		(96)		//apcpu_nINTERRIRQ
#define INTNUM_APCPU_NPMUIRQ_0              		(97)		//apcpu_nPMUIRQ[0]
#define INTNUM_APCPU_NPMUIRQ_1              		(98)		//apcpu_nPMUIRQ[1]
#define INTNUM_APCPU_NPMUIRQ_2              		(99)		//apcpu_nPMUIRQ[2]
#define INTNUM_APCPU_NPMUIRQ_3              		(100)		//apcpu_nPMUIRQ[3]
#define INTNUM_APCPU_NCTIIRQ_0              		(101)		//apcpu_nCTIIRQ[0]
#define INTNUM_APCPU_NCTIIRQ_1              		(102)		//apcpu_nCTIIRQ[1]
#define INTNUM_APCPU_NCTIIRQ_2              		(103)		//apcpu_nCTIIRQ[2]
#define INTNUM_APCPU_NCTIIRQ_3              		(104)		//apcpu_nCTIIRQ[3]
#define INTNUM_APCPU_COMMRX_0               		(105)		//apcpu_COMMRX[0]
#define INTNUM_APCPU_COMMRX_1               		(106)		//apcpu_COMMRX[1]
#define INTNUM_APCPU_COMMRX_2               		(107)		//apcpu_COMMRX[2]
#define INTNUM_APCPU_COMMRX_3               		(108)		//apcpu_COMMRX[3]
#define INTNUM_APCPU_COMMTX_0               		(109)		//apcpu_COMMTX[0]
#define INTNUM_APCPU_COMMTX_1               		(110)		//apcpu_COMMTX[1]
#define INTNUM_APCPU_COMMTX_2               		(111)		//apcpu_COMMTX[2]
#define INTNUM_APCPU_COMMTX_3               		(112)		//apcpu_COMMTX[3]
#define INTNUM_APCPU_NCOMMIRQ_0             		(113)		//apcpu_nCOMMIRQ[0]
#define INTNUM_APCPU_NCOMMIRQ_1             		(114)		//apcpu_nCOMMIRQ[1]
#define INTNUM_APCPU_NCOMMIRQ_2             		(115)		//apcpu_nCOMMIRQ[2]
#define INTNUM_APCPU_NCOMMIRQ_3             		(116)		//apcpu_nCOMMIRQ[3]
#define INTNUM_APCPU_NWAMRRSTREQ_0          		(117)		//apcpu_nWAMRRSTREQ[0]
#define INTNUM_APCPU_NWAMRRSTREQ_1          		(118)		//apcpu_nWAMRRSTREQ[1]
#define INTNUM_APCPU_NWAMRRSTREQ_2          		(119)		//apcpu_nWAMRRSTREQ[2]
#define INTNUM_APCPU_NWAMRRSTREQ_3          		(120)		//apcpu_nWAMRRSTREQ[3]
#define INTNUM_MCK_PML_OVERFLOW_IRQMC       		(121)		//mck_pml_overflow_irq(MC)
#define INTNUM_DMA_CHANNEL_INT_0            		(122)		//dma_channel_int[0]
#define INTNUM_DMA_CHANNEL_INT_1            		(123)		//dma_channel_int[1]
#define INTNUM_DMA_CHANNEL_INT_2            		(124)		//dma_channel_int[2]
#define INTNUM_DMA_CHANNEL_INT_3            		(125)		//dma_channel_int[3]
#define INTNUM_DMA_CHANNEL_INT_4            		(126)		//dma_channel_int[4]
#define INTNUM_DMA_CHANNEL_INT_5            		(127)		//dma_channel_int[5]
#define INTNUM_DMA_CHANNEL_INT_6            		(128)		//dma_channel_int[6]
#define INTNUM_DMA_CHANNEL_INT_7            		(129)		//dma_channel_int[7]
#define INTNUM_DMA_CHANNEL_INT_8            		(130)		//dma_channel_int[8]
#define INTNUM_DMA_CHANNEL_INT_9            		(131)		//dma_channel_int[9]
#define INTNUM_DMA_CHANNEL_INT_10           		(132)		//dma_channel_int[10]
#define INTNUM_DMA_CHANNEL_INT_11           		(133)		//dma_channel_int[11]
#define INTNUM_DMA_CHANNEL_INT_12           		(134)		//dma_channel_int[12]
#define INTNUM_DMA_CHANNEL_INT_13           		(135)		//dma_channel_int[13]
#define INTNUM_DMA_CHANNEL_INT_14           		(136)		//dma_channel_int[14]
#define INTNUM_DMA_CHANNEL_INT_15           		(137)		//dma_channel_int[15]
#define INTNUM_M2M_INTERRUPTM2M0            		(138)		//m2m_interrupt(M2M0)
#define INTNUM_M2M2_INTERRUPTM2M1           		(139)		//m2m2_interrupt(M2M1)
#define INTNUM_EXT_IRQ_PADRING_CHECK        		(140)		//EXT_IRQ (Padring-Check)
#define INTNUM_SMMU_AP_CXT_NS               		(141)		//SMMU_AP_cxt_ns
#define INTNUM_SMMU_AP_COMB_NS              		(142)		//SMMU_AP_comb_ns
#define INTNUM_SMMU_AP_COMB_S               		(143)		//SMMU_AP_comb_s
#define INTNUM_SMMU_AP_PERF                 		(144)		//SMMU_AP_perf
#define INTNUM_AP_TIME_BASE_1US             		(145)		//AP-TIMEB1us
#define INTNUM_AP_TIME_BASE_10US            		(146)		//AP-TIMEB10us
#define INTNUM_AP_TIME_BASE_100US           		(147)		//AP-TIMEB100us
#define INTNUM_AP_TIME_BASE_1MS             		(148)		//AP-TIMEB1ms
#define INTNUM_AP_TIME_BASE_10MS            		(149)		//AP-TIMEB10ms
#define INTNUM_AP_TIME_BASE_100MS           		(150)		//AP-TIMEB100ms
#define INTNUM_SCCP_IRQ_0                   		(156)		//SCCP_IRQ[0]
#define INTNUM_SCCP_IRQ_1                   		(157)		//SCCP_IRQ[1]
#define INTNUM_TIME_BASE_1US                		(158)		//TIMEB1us
#define INTNUM_TIME_BASE_10US               		(159)		//TIMEB10us
#define INTNUM_TIME_BASE_100US              		(160)		//TIMEB100us
#define INTNUM_TIME_BASE_1MS                		(161)		//TIMEB1ms
#define INTNUM_TIME_BASE_10MS               		(162)		//TIMEB10ms
#define INTNUM_TIME_BASE_100MS              		(163)		//TIMEB100ms
#define INTNUM_TIMER_IRQ_0                  		(164)		//Timer_IRQ[0]
#define INTNUM_TIMER_IRQ_1                  		(165)		//Timer_IRQ[1]
#define INTNUM_TIMER_IRQ_2                  		(166)		//Timer_IRQ[2]
#define INTNUM_TIMER_IRQ_3                  		(167)		//Timer_IRQ[3]
#define INTNUM_UPCERROR_IRQ_0               		(168)		//UPCError_IRQ[0]
#define INTNUM_UPCERROR_IRQ_1               		(169)		//UPCError_IRQ[1]
#define INTNUM_AUDIO_IRQ                    		(170)		//Audio_IRQ
#define INTNUM_HVSYNC_IRQ                   		(171)		//HVSync_IRQ
#define INTNUM_ENG_IRQ_0                    		(172)		//Eng_IRQ[0]
#define INTNUM_ENG_IRQ_1                    		(173)		//Eng_IRQ[1]
#define INTNUM_ENG_IRQ_2                    		(174)		//Eng_IRQ[2]
#define INTNUM_ENG_IRQ_3                    		(175)		//Eng_IRQ[3]
#define INTNUM_ZX                       		(176)		//Zx_IRQ
#define INTNUM_SSPA_IRQ                     		(177)		//SSPA_IRQ
#define INTNUM_JBIG_DECODE_ODMA_IRQ_0       		(178)		//jbig_decode_odma_irq[0]
#define INTNUM_JBIG_DECODE_ODMA_IRQ_1       		(179)		//jbig_decode_odma_irq[1]
#define INTNUM_JBIG_DECODE_ODMA_IRQ_2       		(180)		//jbig_decode_odma_irq[2]
#define INTNUM_JBIG_DECODE_ODMA_IRQ_3       		(181)		//jbig_decode_odma_irq[3]
#define INTNUM_JBIG_DECODE_IDMA_IRQ_0       		(182)		//jbig_decode_idma_irq[0]
#define INTNUM_JBIG_DECODE_IDMA_IRQ_1       		(183)		//jbig_decode_idma_irq[1]
#define INTNUM_JBIG_DECODE_IDMA_IRQ_2       		(184)		//jbig_decode_idma_irq[2]
#define INTNUM_JBIG_DECODE_IDMA_IRQ_3       		(185)		//jbig_decode_idma_irq[3]
#define INTNUM_JBIG_DECODE_OVER_0           		(186)		//jbig_decode_over[0]
#define INTNUM_JBIG_DECODE_OVER_1           		(187)		//jbig_decode_over[1]
#define INTNUM_JBIG_DECODE_OVER_2           		(188)		//jbig_decode_over[2]
#define INTNUM_JBIG_DECODE_OVER_3           		(189)		//jbig_decode_over[3]
#define INTNUM_JBIG_CODEC_OMDA_IRQ_0        		(190)		//jbig_codec_omda_irq[0]
#define INTNUM_JBIG_CODEC_OMDA_IRQ_1        		(191)		//jbig_codec_omda_irq[1]
#define INTNUM_JBIG_CODEC_OMDA_IRQ_2        		(192)		//jbig_codec_omda_irq[2]
#define INTNUM_JBIG_CODEC_OMDA_IRQ_3        		(193)		//jbig_codec_omda_irq[3]
#define INTNUM_JBIG_CODEC_OMDA_IRQ_4        		(194)		//jbig_codec_omda_irq[4]
#define INTNUM_JBIG_CODEC_IDMA_IRQ_0        		(195)		//jbig_codec_idma_irq[0]
#define INTNUM_JBIG_CODEC_IDMA_IRQ_1        		(196)		//jbig_codec_idma_irq[1]
#define INTNUM_JBIG_CODEC_IDMA_IRQ_2        		(197)		//jbig_codec_idma_irq[2]
#define INTNUM_JBIG_CODEC_IDMA_IRQ_3        		(198)		//jbig_codec_idma_irq[3]
#define INTNUM_JBIG_CODEC_IDMA_IRQ_4        		(199)		//jbig_codec_idma_irq[4]
#define INTNUM_JBIG_CODEC_OVER_0            		(200)		//jbig_codec_over[0]
#define INTNUM_JBIG_CODEC_OVER_1            		(201)		//jbig_codec_over[1]
#define INTNUM_JBIG_CODEC_OVER_2            		(202)		//jbig_codec_over[2]
#define INTNUM_JBIG_CODEC_OVER_3            		(203)		//jbig_codec_over[3]
#define INTNUM_JBIG_CODEC_OVER_4            		(204)		//jbig_codec_over[4]
#define INTNUM_ROTATE_IRQ                   		(205)		//ROTATE_irq
#define INTNUM_JPEGIRQ_0                    		(206)		//JpegIrq[0]
#define INTNUM_JPEGIRQ_1                    		(207)		//JpegIrq[1]
#define INTNUM_STMOTORS_IRQ_0               		(208)		//STMotors_IRQ[0]
#define INTNUM_STMOTORS_IRQ_1               		(209)		//STMotors_IRQ[1]
#define INTNUM_STMOTORS_IRQ_2               		(210)		//STMotors_IRQ[2]
#define INTNUM_STMOTORS_IRQ_3               		(211)		//STMotors_IRQ[3]
#define INTNUM_STMOTORS_IRQ_4               		(212)		//STMotors_IRQ[4]
#define INTNUM_STMOTORS_IRQ_5               		(213)		//STMotors_IRQ[5]
#define INTNUM_DCMOTORS_IRQ_0               		(214)		//DCMotors_IRQ[0]
#define INTNUM_DCMOTORS_IRQ_1               		(215)		//DCMotors_IRQ[1]
#define INTNUM_DCMOTORS_IRQ_2               		(216)		//DCMotors_IRQ[2]
#define INTNUM_DCMOTORS_IRQ_3               		(217)		//DCMotors_IRQ[3]
#define INTNUM_DCMOTORS_IRQ_4               		(218)		//DCMotors_IRQ[4]
#define INTNUM_DCMOTORS_IRQ_5               		(219)		//DCMotors_IRQ[5]
#define INTNUM_DCMOTORS_IRQ_6               		(220)		//DCMotors_IRQ[6]
#define INTNUM_CDMA_IRQ                     		(221)		//CDMA_IRQ
#define INTNUM_PIE_IRQ                      		(222)		//Pie_IRQ
#define INTNUM_PIC_IRQ_0                    		(223)		//Pic_IRQ[0]
#define INTNUM_PIC_IRQ_1                    		(224)		//Pic_IRQ[1]
#define INTNUM_SCAN_IRQ                     		(225)		//Scan_IRQ
#define INTNUM_ICETEST_IRQ                  		(226)		//IceTest_Irq
#define INTNUM_CISX_IRQ                     		(227)		//Cisx_Irq
#define INTNUM_VID_IRQ_0                    		(228)		//Vid_IRQ[0]
#define INTNUM_VID_IRQ_1                    		(229)		//Vid_IRQ[1]
#define INTNUM_VID_IRQ_2                    		(230)		//Vid_IRQ[2]
#define INTNUM_VID_IRQ_3                    		(231)		//Vid_IRQ[3]
#define INTNUM_VID_IRQ_4                    		(232)		//Vid_IRQ[4]
#define INTNUM_VID_IRQ_5                    		(233)		//Vid_IRQ[5]
#define INTNUM_VID_IRQ_6                    		(234)		//Vid_IRQ[6]
#define INTNUM_VID_IRQ_7                    		(235)		//Vid_IRQ[7]
#define INTNUM_UPCNORM_IRQ_0                		(236)		//UPCNorm_IRQ[0]
#define INTNUM_UPCNORM_IRQ_1                		(237)		//UPCNorm_IRQ[1]
#define INTNUM_PIP_IRQ                      		(238)		//PIP_IRQ
#define INTNUM_VCF_IRQ                      		(239)		//Vcf_IRQ
#define INTNUM_APB2_IRQ                     		(240)		//APB2_IRQ
#define INTNUM_AAAAA_IRQ                    		(241)		//AAAAA_IRQ
#define INTNUM_ANTIC_IRQ                    		(242)		//ANTIC_IRQ
#define INTNUM_DEC_IRQ                      		(243)		//DEC_IRQ
#define INTNUM_DEC_FIQ                      		(244)		//DEC_FIQ
#define INTNUM_LMON_IRQ                     		(245)		//Lmon_IRQ
#define INTNUM_IPMU_IRQ                     		(246)		//IPMU_IRQ
#define INTNUM_SMMU_IPS_CXT_NS              		(247)		//SMMU_IPS_cxt_ns
#define INTNUM_SMMU_IPS_COMB_NS             		(248)		//SMMU_IPS_comb_ns
#define INTNUM_SMMU_IPS_COMB_S              		(249)		//SMMU_IPS_comb_s
#define INTNUM_SMMU_IPS_PERF                		(250)		//SMMU_IPS_perf

/*
	This section specifies if the above interrupts are level or
	edge triggered. This is a bit mask with interrupt id's as the index
	a 1 means edge triggered, a 0 means level triggered
*/
#define INT_TYPE1		(0x00000000)
#define INT_TYPE2		(0x00000000)
#define INT_TYPE3		(0x00000000)
#define INT_TYPE4		(0x00000000)
#define INT_TYPE5		(0x000007e7)
#define INT_TYPE6		(0xe0000000)
#define INT_TYPE7		(0x00000000)
#define INT_TYPE0		(0)
#define INT_TYPE8		(0)
#define INT_TYPE9		(0)
#define INT_TYPE10		(0)
#define INT_TYPE11		(0)
#define INT_TYPE12		(0)
#define INT_TYPE13		(0)
#define INT_TYPE14		(0)
#define INT_TYPE15		(0)
#define INT_TYPE16		(0)
#define INT_TYPE17		(0)
#define INT_TYPE18		(0)
#define INT_TYPE19		(0)
#define INT_TYPE20		(0)
#define INT_TYPE21		(0)
#define INT_TYPE22		(0)
#define INT_TYPE23		(0)
#define INT_TYPE24		(0)
#define INT_TYPE25		(0)
#define INT_TYPE26		(0)
#define INT_TYPE27		(0)
#define INT_TYPE28		(0)
#define INT_TYPE29		(0)
#define INT_TYPE30		(0)
#define INT_TYPE31		(0)

#ifdef __cplusplus
}
#endif

#endif // __INTNUMS_H__
