/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/




#include <stdint.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include "logger.h"
#include "lassert.h"

void XAssertFail(const char *expression, const char *file, int line,
                 unsigned long int errvalue)
{
    _assert(expression, file, line);
}

char* reg32_as_binary(char *buf, int bufsize, uint32_t reg_val) 
{
    int i;
    uint32_t bit;

    DBG_ASSERT( bufsize > 32 );
    DBG_ASSERT( buf );

    for ( i = 0, bit = 1; i < 32; i++ )
	buf[31-i] = reg_val & (bit << i) ? '1' : '0';  
    buf[32] = 0;

    return buf;
}
 
char* reg32_hexonly(char *buf, int bufsize, uint32_t reg_val) 
{
    int cnt = 0;
    DBG_ASSERT(buf);

    cnt += snprintf( &buf[cnt], bufsize-cnt, "%s ", ":hex" );
    return buf;
}

void reg32_dump_named_arr(void *start_addr, int num_registers, 
			  char *region, 
			  char* (*reg_func_array[])(char *buf, int bufsize, uint32_t reg_val))
{
    uint32_t ashex;
    void* offset;
    char buf[256] = " ";
    uint32_t n;
    char *output;
    
    DBG_ASSERT( start_addr );
    DBG_ASSERT( (((uint32_t)start_addr) & 0x03) == 0 );

    if (region) {
        dbg_printf("\n%s:\n", region);
    }

    for ( offset = start_addr, n = 0; n < num_registers; n++, offset += 4 ) {
	ashex = *(uint32_t *)offset; 
	if ( reg_func_array[n] ) {
	    output = reg_func_array[n]( buf, 256, ashex );
	    dbg_printf("0x%08x  0x%08x  %s\n", offset, ashex, output);
	}
    }
}
