
/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef ASIC_MASK_H
#define ASIC_MASK_H

/// Macros to isolate asic turmoil in the structure names based on placement hierarchy.
///


/// concatination macro with 6 arguments
#define CAT_6(a,b,c,d,e,f) a ## b ## c ## d ## e ## f
/// REPLACE_VAL( ever_changing_structure_hierarchy_name, 
///              field_name,
///              bit(s)_name,
///              register,
///              new_value 
///              )
/// this uses the asic supplied *_masks and *_structs files but allows the structure name to be
/// easily replaced, this is needed since the structure location/name seems to change with each asic.
///
#define REPLACE_VAL( STRUCTN, FIELDN, BITN, reg, val ) \
  CAT_6( STRUCTN, _, FIELDN, _, BITN, _REPLACE_VAL )((reg), (val))

/// same as REPLACE_VAL but just reads the bits instead of replacing them.
#define MASK_SHIFT( STRUCTN, FIELDN, BITN, reg ) \
  CAT_6( STRUCTN, _, FIELDN, _, BITN, _MASK_SHIFT )((reg))

#define MASK( STRUCTN, FIELDN, BITN ) \
  CAT_6( STRUCTN, _, FIELDN, _, BITN, _MASK )

#endif // ASIC_MASK_H
