 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _ROTATE_TOP_REGSTRUCTS_H_
#define _ROTATE_TOP_REGSTRUCTS_H_

#include <stdint.h>

//====================================================================
//
//Register File: ROTATE_TOP (ROTATE_TOP)
//
//====================================================================

//====================================================================
//
//Register File: ROTATE_IDMA (ROTATE_IDMA)
//
//====================================================================

//====================================================================
//
//Register File: ROTATE_CORE (ROTATE_CORE)
/** \brief Register Descriptions for the Rotate Block*/
//
//====================================================================

typedef struct ROTATE_CORE_REGS_s
{
  volatile uint32_t CTRL;  ///< 0x0 [R/W]: Rotate Control Register
  volatile uint32_t MASK;  ///< 0x4 [R/W]: Rotate Data Mask Register
  volatile uint32_t REPLACE;  ///< 0x8 [R/W]: Rotate Replace Data Register
  volatile uint32_t SOFT_RESET;  ///< 0xc [W]: Rotate Soft Reset Register
  volatile uint32_t RACR;  ///< 0x10 [R/W]: SRAM Access Control Register
  volatile uint32_t RAR;  ///< 0x14 [W]: SRAM Address Register
  volatile uint32_t RASR;  ///< 0x18 [R]: SRAM Address Status Register
  volatile uint32_t RDWR;  ///< 0x1c [W]: SRAM Data Write Register
  volatile uint32_t RDRR;  ///< 0x20 [R]: SRAM Data Read Register
  volatile uint32_t ROT_PARAM0;  ///< 0x24 [R]: ROTATE Parameter Register 0
  volatile uint32_t ROT_PARAM1;  ///< 0x28 [R]: ROTATE Parameter Register 1
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x30 [R]: ROTATE Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: ROTATE Tagging Revision 1
} ROTATE_CORE_REGS_t;

//====================================================================
//
//Register File: ROTATE_ODMA (ROTATE_ODMA)
//
//====================================================================

//====================================================================
//
//Register File: ROTATE_IDMA_UDMA (ROTATE_IDMA_ROTATE_IDMA_UDMA)
//
//====================================================================

typedef struct ROTATE_IDMA_ROTATE_IDMA_UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} ROTATE_IDMA_ROTATE_IDMA_UDMA_REGS_t;

//====================================================================
//
//Register File: ROTATE_IDMA_CORE (ROTATE_IDMA_ROTATE_IDMA_CORE)
//
//====================================================================

typedef struct ROTATE_IDMA_ROTATE_IDMA_CORE_REGS_s
{
  volatile uint32_t ICFG;  ///< 0x0 [R/W]: IDMA Configuration Register
  volatile uint32_t ILW;  ///< 0x4 [R/W]: IDMA Image Line Width Register
  volatile uint32_t IIH;  ///< 0x8 [R/W]: IDMA Image Height Register
  volatile uint32_t ITS;  ///< 0xc [R/W]: IDMA Tile Size Register
  volatile uint32_t ISOFFST;  ///< 0x10 [R/W]: IDMA Swath Offset Register
  volatile uint32_t ITOFFST;  ///< 0x14 [R/W]: IDMA Tile Offset Register
  volatile uint32_t IIER;  ///< 0x18 [R/W]: IDMA Interrupt Enable Register
  volatile uint32_t IIPR;  ///< 0x1c [R]: IDMA Interrupt Pending Register
  volatile uint32_t IICR;  ///< 0x20 [W]: IDMA Interrupt Clear Register
  volatile uint32_t IIFR;  ///< 0x24 [W]: IDMA Interrupt Force Register
  volatile uint32_t ITR0;  ///< 0x28 [R]: IDMA Tag Register 0
  volatile uint32_t ITR1;  ///< 0x2c [R]: IDMA Tag Register 1
  volatile uint32_t ITR2;  ///< 0x30 [R]: IDMA Tag Register 2
} ROTATE_IDMA_ROTATE_IDMA_CORE_REGS_t;

//====================================================================
//
//Register File: ROTATE_ODMA_UDMA (ROTATE_ODMA_ROTATE_ODMA_UDMA)
//
//====================================================================

typedef struct ROTATE_ODMA_ROTATE_ODMA_UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} ROTATE_ODMA_ROTATE_ODMA_UDMA_REGS_t;

//====================================================================
//
//Register File: ROTATE_ODMA_CORE (ROTATE_ODMA_ROTATE_ODMA_CORE)
//
//====================================================================

typedef struct ROTATE_ODMA_ROTATE_ODMA_CORE_REGS_s
{
  volatile uint32_t ICFG;  ///< 0x0 [R/W]: ODMA Configuration Register
  volatile uint32_t ILW;  ///< 0x4 [R/W]: ODMA Image Line Width Register
  volatile uint32_t IIH;  ///< 0x8 [R/W]: ODMA Image Height Register
  volatile uint32_t ITS;  ///< 0xc [R/W]: ODMA Tile Size Register
  volatile uint32_t ISOFFST;  ///< 0x10 [R/W]: ODMA Swath Offset Register
  volatile uint32_t ITOFFST;  ///< 0x14 [R/W]: ODMA Tile Offset Register
  volatile uint32_t IIER;  ///< 0x18 [R/W]: ODMA Interrupt Enable Register
  volatile uint32_t IIPR;  ///< 0x1c [R]: ODMA Interrupt Pending Register
  volatile uint32_t IICR;  ///< 0x20 [W]: ODMA Interrupt Clear Register
  volatile uint32_t IIFR;  ///< 0x24 [W]: ODMA Interrupt Force Register
  volatile uint32_t ITR0;  ///< 0x28 [R]: ODMA Tag Register 0
  volatile uint32_t ITR1;  ///< 0x2c [R]: ODMA Tag Register 1
  volatile uint32_t ITR2;  ///< 0x30 [R]: ODMA Tag Register 2
} ROTATE_ODMA_ROTATE_ODMA_CORE_REGS_t;

#endif // ROTATE_TOP
