/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _JPEGHW_LIB_H
#define _JPEGHW_LIB_H

#include "jpeghw_api.h"
#include "jhw_api.h"

#ifndef MIN
	#define MIN(a,b)(a)<(b)?(a):(b)
#endif


struct jpeghw_dev_struct {
	struct jpeghw_common_struct * info;
	uint32_t hw_config_flags;

	uint32_t image_bytes_per_row;

	uint32_t mcu_aligned_width;
	uint32_t mcu_aligned_height;
	uint32_t mcu_bytes_per_row;

	struct BigBuffer_s *cacheBuffer;
	uint32_t cacheMaxLines;
	uint32_t cacheLines;

	void *jhw_dev;
};

typedef struct jpeghw_dev_struct *jpeghw_dev_ptr;


jpeghw_error_type_t jpeghw_error(struct jpeghw_common_struct * info, jpeghw_error_type_t err_code);
jpeghw_error_type_t jpeghw_error_exit(struct jpeghw_common_struct * info, jpeghw_error_type_t err_code);
void jpeghw_error_reset(struct jpeghw_common_struct * info);

void jpeghw_finish(struct jpeghw_common_struct * info);

bool jpeghw_valid_buffer(struct BigBuffer_s* bb);

struct jpeghw_dev_struct *jpeghw_new_dev(struct jpeghw_common_struct * info);
void jpeghw_free_dev(jpeghw_dev_ptr dev);

struct BigBuffer_s *jpeghw_mcu_new_aligned_buffer(jpeghw_dev_ptr dev);
int jpeghw_mcu_cache_consume_scanlines(jpeghw_dev_ptr dev, struct BigBuffer_s *scanlines, uint32_t skip_lines, uint32_t total_lines);
bool jpeghw_mcu_cache_flush_scanlines(jpeghw_dev_ptr dev, bool eoi);

#endif //_JPEGHW_LIB_H
