/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _JPEGHW_DBG_H
#define _JPEGHW_DBG_H

//#define DEBUG 1
#if DEBUG

#include <stdio.h>
#include <syslog.h> // general logging capabilities

#ifndef JPEGHW_DBG_PREFIX
 #define JPEGHW_DBG_PREFIX "jpeghw-"
#endif

#define JPEGHW_VALIDATE_COMMON_INFO(info) ASSERT(info->type == e_JPEGHW_OBJ_COMPRESS || info->type == e_JPEGHW_OBJ_DECOMPRESS )
#define JPEGHW_VALIDATE_INFO(info, t) ASSERT(info->common.type == t)
#define JPEGHW_VALIDATE_DEV(dev) ASSERT(dev != NULL)

#if 0
// basic exceptional circumstance
#define DBG_ERR(...) printf(__VA_ARGS__)

// info circumstance
#define DBG_WARN(...) printf(__VA_ARGS__)

// general tracing of interest
#define DBG_INFO(...) printf(__VA_ARGS__)

// debug message
#define DBG_MSG(...) printf(__VA_ARGS__)

#define DBG_INIT()
#define DBG_TERMINATE()
#else
// basic exceptional circumstance
#define DBG_ERR(...) syslog(LOG_ERR, __VA_ARGS__)

// info circumstance
#define DBG_WARN(...) syslog(LOG_WARNING, __VA_ARGS__)

// general tracing of interest
#define DBG_INFO(...) syslog(LOG_INFO, __VA_ARGS__)

// debug message
#define DBG_MSG(...) syslog(LOG_DEBUG, __VA_ARGS__)

#define DBG_INIT() 	 openlog(JPEGHW_DBG_PREFIX, LOG_CONS | LOG_PID | LOG_NDELAY, LOG_USER);
#define DBG_TERMINATE() closelog();
#endif

#else //DEBUG

#define JPEGHW_VALIDATE_COMMON_INFO(info)
#define JPEGHW_VALIDATE_INFO(info, t)
#define JPEGHW_VALIDATE_DEV(dev)

#define DBG_ERR(...)
#define DBG_WARN(...)
#define DBG_INFO(...)
#define DBG_STATUS(...)

#define DBG_INIT()
#define DBG_TERMINATE()

#endif //DEBUG

#endif //_JPEGHW_DBG_H
