/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


  
#ifndef jpeg_common_H
#define jpeg_common_H

#include <pthread.h>
#include <semaphore.h>

/* JPEG decompression header defines */
#define HEADER_BYTE 0xFF
#define FILL_BYTE   0xFF
#define SOI_BYTE    0xD8
#define EOI_BYTE    0xD9
#define SOS_BYTE    0xDA
#define DQT_BYTE    0xDB
#define DNL_BYTE    0xDC
#define DRI_BYTE    0xDD
#define JFIF_BYTE   0xE0

#define RST0_BYTE   0xD0
#define RST1_BYTE   0xD1
#define RST2_BYTE   0xD2
#define RST3_BYTE   0xD3
#define RST4_BYTE   0xD4
#define RST5_BYTE   0xD5
#define RST6_BYTE   0xD6
#define RST7_BYTE   0xD7

#define SOF_BASELINE_BYTE 0xC0
#define SOF_OTHER_BYTE    0xC0
#define SOF_OTHER_MASK    0xF0

#define DHT_BYTE      0xC4

/* PPM parse header structures */
typedef struct
{
	uint32_t 	image_width;
	uint32_t 	image_height;
	uint32_t 	bytes_per_pixel;
} PPM_header_struct;

/* JPEG header structures */
typedef struct jpeghw_jpeg_header_struct JPEG_header_struct;

// SOF struct
typedef struct
{
    uint8_t hdr_msb;
    uint8_t hdr_lsb;
    uint8_t Lf_msb;
    uint8_t Lf_lsb;
    uint8_t P;
    uint8_t Y_msb;
    uint8_t Y_lsb;
    uint8_t X_msb;
    uint8_t X_lsb;
    uint8_t Nf;
} SOF_struct;

// SOF comp_spec struct
typedef struct
{
    uint8_t  C;
    uint8_t  HV;
    uint8_t  T;
} SOF_comp_spec_struct;

// DRI struct
typedef struct
{
    uint8_t hdr_msb;
    uint8_t hdr_lsb;
    uint8_t Lf_msb;
    uint8_t Lf_lsb;
    uint8_t Ri_msb;
    uint8_t Ri_lsb;
} DRI_struct;

// SOS struct
typedef struct
{
    uint8_t hdr_msb;
    uint8_t hdr_lsb;
    uint8_t Lf_msb;
    uint8_t Lf_lsb;
    uint8_t Ns;
} SOS_struct;

// SOS comp_spec struct
typedef struct
{
    uint8_t  Cs;
    uint8_t  TdTa;
} SOS_comp_spec_struct;

// DQT struct
typedef struct
{
    uint8_t hdr_msb;
    uint8_t hdr_lsb;
    uint8_t Lq_msb;
    uint8_t Lq_lsb;
} DQT_struct;

// DQT comp_spec struct
typedef struct
{
    uint8_t  PqTq;
    uint8_t  Q [64];
} DQT_comp_spec_struct;

// DHT struct
typedef struct
{
    uint8_t hdr_msb;
    uint8_t hdr_lsb;
    uint8_t Lh_msb;
    uint8_t Lh_lsb;
} DHT_struct;

// DHT comp_spec struct
typedef struct
{
    uint8_t TcTh;
    uint8_t Li[16];
    uint8_t V[384];
} DHT_comp_spec_struct;


/* Structure for both the list head and the list nodes */
typedef struct testLinkList_s testLinkList;
struct testLinkList_s
{
	testLinkList* nextNode;     // next node on list
	testLinkList* prevNode;     // previous node on list
};
#define CONTAINING_RECORD(address, type, field) ((address) ? ((type*)( ((char*)(address)) - ((unsigned int)((char *)&(((type *)0)->field) - (char *)0)))) : 0 )

typedef struct testFifo_s testFifo;
struct testFifo_s
{
	ATLISTENTRY list;

	pthread_mutex_t mutex;
    sem_t fill_sem;
    sem_t empty_sem;
    uint32_t maxCount;

};

typedef struct testFifoRecord_s testFifoRecord;
struct testFifoRecord_s
{
	ATLISTENTRY list_node; // must be first

    void* data;
};

// externs
extern const uint8_t g_quantization_table[101][256];
extern const uint8_t g_dc_bits[2][16];
extern const uint8_t g_dc_val[2][12];
extern const uint8_t g_ac_bits[2][16];
extern const uint8_t g_ac_val[2][162];


/* parsing routines */
int parse_jpeg_header(FILE *fp, struct jpeghw_jpeg_header_struct* jpeginfo, bool stop_after_sof);
int parse_ppm_header(FILE *fp, PPM_header_struct* ppminfo);

/* generate routines */
void generate_jpeg_header(FILE *fp, struct jpeghw_compress_struct* cinfo);
void generate_ppm_header(FILE *fp, struct jpeghw_decompress_struct* dinfo);


/* FIFO routines */
void testFifo_Init(testFifo* pFifoHead, uint32_t maxFifoCount);
void testFifo_Destroy(testFifo* pFifoHead);
int testFifo_Add(testFifo* pFifoHead, void* dataPtr, bool wait);
void* testFifo_Remove(testFifo* pFifoHead, bool wait);
bool testFifo_IsEmpty(testFifo* pFifoHead);

int page_jpeg_fixup_page_length(FILE *dst_file, uint32_t lines_encoded);

#endif // jpeg_common_H
