/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


 
#ifndef JHW_UIO_H
#define JHW_UIO_H

/// isr events and flags
#define JPEG_reserved            1  /*       1 */
#define JPEG_DECODED         (1<<1) /*       2 */
#define JPEG_ENCODED         (1<<2) /*       4 */
#define JPEG_DMA_IN          (1<<3) /*       8 */

#define JPEG_DMA_OUT         (1<<4) /*     x10 */
#define POGO_DMA_IN          (1<<5) /*     x20 */
#define POGO_DMA_OUT         (1<<6) /*     x40 */
#define JPEG_DECODE_ERROR    (1<<7) /*     x80 */

#define JPEG_ISR_EOI         (1<<8) /*    x100 */
#define POGO_DMA_ERR_IN      (1<<9) /*    x200 */
#define POGO_DMA_ERR_OUT    (1<<10) /*    x400 */
#define POGO_DMA_ERR_RANGE  (1<<11) /*    x800 */

#define POGO_DMA_ERR_LENGTH (1<<12) /*   x1000 */
#define POGO_DMA_HW_OWN     (1<<13) /*   x2000 */
#define POGO_DMA_EOS        (1<<14) /*   x4000 */
#define TERMINATE_THRD      (1<<15) /*   x8000 */

#define JPEG_ENCODE_ERROR   (1<<16) /*  x10000 */
#define JPEG_ENCODE_TIMEOUT (1<<17) /*  x20000 */
#define JPEG_DECODE_TIMEOUT (1<<18) /*  x40000 */

jpeghw_error_type_t jhw_open_available_core(struct jpeg_dev_info_s * dev, bool wait);
int jhw_close_core(struct jpeg_dev_info_s * dev);

int jhw_attach_to_device(struct jpeg_dev_info_s * dev);
int jhw_detach_from_device(struct jpeg_dev_info_s * dev);

int jhw_enable_device_interrupts(struct jpeg_dev_info_s * dev);

void jhw_iomap_registers();
void jhw_iounmap_registers();

#endif 
