/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


 
#ifndef JHW_MEM_TEST_H
#define JHW_MEM_TEST_H

#include "jhw_dev.h"

// enable memory test reporting to trouble-shoot memory leaks
//#define JHW_MEM_TEST
#ifdef JHW_MEM_TEST
  int g_allocated;
  int g_mapped;
  int g_smapped;
  pthread_mutex_t mem_mutex;

  #define DEC_G_ALLOCATED() pthread_mutex_lock(&mem_mutex); g_allocated--;\
                            DBG_INFO("%s dec g_allocated=%d\n",__func__, g_allocated);\
                            pthread_mutex_unlock(&mem_mutex); 
  #define INC_G_ALLOCATED() pthread_mutex_lock(&mem_mutex); g_allocated++;\
                            DBG_INFO("%s inc g_allocated=%d\n",__func__, g_allocated);\
                            pthread_mutex_unlock(&mem_mutex); 
  #define DEC_G_SMAPPED()   pthread_mutex_lock(&mem_mutex); g_smapped--;  \
                            DBG_INFO("%s dec g_smapped=%d\n",  __func__, g_smapped);\
                            pthread_mutex_unlock(&mem_mutex); 
  #define INC_G_SMAPPED()   pthread_mutex_lock(&mem_mutex); g_smapped++;  \
                            DBG_INFO("%s inc g_smapped=%d\n",  __func__, g_smapped);\
                            pthread_mutex_unlock(&mem_mutex); 
  #define DEC_G_MAPPED()    pthread_mutex_lock(&mem_mutex); g_mapped--;   \
                            DBG_INFO("%s dec g_mapped=%d\n",   __func__, g_mapped);\
                            pthread_mutex_unlock(&mem_mutex); 
  #define INC_G_MAPPED()    pthread_mutex_lock(&mem_mutex); g_mapped++;  \
                            DBG_INFO("%s inc g_mapped=%d\n",   __func__, g_mapped);\
                            pthread_mutex_unlock(&mem_mutex); 
  #define INIT_MEM_STATS() { pthread_mutex_init(&mem_mutex,0); g_allocated = 0; g_mapped = 0; g_smapped = 0; }
  #define DSP_MEM_STATS()  { if(g_allocated > 0) printf("allocated = %d\n", g_allocated); \
                             if(g_mapped > 0) printf("mapped = %d\n", g_mapped); \
                             if(g_smapped > 0) printf("smapped = %d\n", g_smapped); }
  #define TERM_MEM_STATS() { pthread_mutex_destroy(&mem_mutex); }
#else
  #define DEC_G_ALLOCATED()
  #define INC_G_ALLOCATED()
  #define DEC_G_SMAPPED()
  #define INC_G_SMAPPED()
  #define DEC_G_MAPPED()
  #define INC_G_MAPPED()
  #define INIT_MEM_STATS()
  #define TERM_MEM_STATS()
  #define DSP_MEM_STATS()
#endif

#endif 
