/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


 
#ifndef JHW_DMA_H
#define JHW_DMA_H

#include "dma_buffer.h"

#define TIMEOUT (FAIL -1)

// if USE_SPLIT_DESCRIPTORS is defined the compression IDMA will incorporate split buffering.  
// This can improve performance because rather than combining two buffers into one 
// contiguous buffer the descriptor can be programmed to span two buffers.
#define USE_SPLIT_DESCRIPTORS 

// descriptors used to program DMAs
struct jhw_dma_desc_s
{
	jpegdescsize_t control_reg;
	jpegdescsize_t length;
	jpegdescsize_t source_addr;
	jpegdescsize_t next_desc_addr;
	jpegdescsize_t src_addr_low_0;
	jpegdescsize_t src_addr_high_0;
	jpegdescsize_t src_addr_low_1;
	jpegdescsize_t src_addr_high_1;
    void * hwaddr;
    struct BigBuffer_s * big_buffer;
};

typedef struct jhw_dma_desc_s jhw_dma_desc_t;


int jhwc_destroy_idma_list(struct jpeghw_compress_struct * jhwcinfo, bool wait_for_complete);
int jhwc_destroy_odma_list(struct jpeghw_compress_struct * jhwcinfo, bool wait_for_complete);
int jhwc_init_odma_list(struct jpeghw_compress_struct * jhwcinfo);
int jhwc_start_odma(struct jpeghw_compress_struct * jhwcinfo);

int jhwc_destoy_idma_list(struct jpeghw_compress_struct * jhwcinfo, bool wait_for_complete);
int jhwc_init_idma_list(struct jpeghw_compress_struct * jhwcinfo);
int jhwc_add_idma_data(struct jpeghw_compress_struct * jhwcinfo, 
		       struct BigBuffer_s *big_buffer, bool last_buffer);


int jhwd_destroy_odma_list(struct jpeghw_decompress_struct * jhwdinfo, bool wait_for_complete);
int jhwd_init_odma_list(struct jpeghw_decompress_struct * jhwdinfo);
int jhwd_get_odma_data(struct jpeghw_decompress_struct * jhwdinfo, 
      struct BigBuffer_s *big_buffer, uint32_t *buflen_received, bool *last_buffer);

int jhwd_destroy_idma_list(struct jpeghw_decompress_struct * jhwdinfo, bool wait_for_complete);
int jhwd_init_idma_list(struct jpeghw_decompress_struct * jhwdinfo);
int jhwd_start_idma(struct jpeghw_decompress_struct * jhwdinfo);

#endif 
