/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


 
#ifndef JHWC_CORE_H
#define JHWC_CORE_H


/*
 * \brief resets the JPEG core 
 *
 *  Using the register pointers found within the jhwcinfo structure
 *    retest the JPEG core hardware.
 *
 *  Returns OK (0) if the encoder was successfully intialized, FAIL (-1) otherwise.
 */
void jhwc_reset_core(struct jpeghw_common_struct * jhwinfo);
void jhwd_reset_core(struct jpeghw_common_struct * jhwinfo);


/*
 * \brief intialize the jpeg hardware
 *
 *  Using the register pointers found within the jhwcinfo structure
 *    intializes the compressor/decompressor hardware.
 *
 *  Returns OK (0) if the encoder was successfully intialized, FAIL (-1) otherwise.
 */
int jhwc_init_compression_hw(struct jpeghw_compress_struct * jhwcinfo);
int jhwd_init_decompression_hw(struct jpeghw_decompress_struct * jhwdinfo);

/*
 * \brief sets the new height into the DIM-Y register
 *
 *  Using the register pointers found within the jhwcinfo structure
 *    set the DIM-Y register to a new height.  This facilitates late
 *    initialization of the image height when it is not known when the
 *    compression begins.  Otherwise the hardware will hang expecting
 *    more data.
 *
 */
void jhwc_update_DIM_Y(struct jpeghw_compress_struct * jhwcinfo, int height);

/*
 * \brief resets the IDMA 
 *
 *  Using the register pointers found within the jhwcinfo structure
 *    retest the IDMA channel hardware.
 *
 *  Returns OK (0) if the encoder was successfully intialized, FAIL (-1) otherwise.
 */
int jhwc_reset_idma(struct jpeghw_compress_struct * jhwcinfo);
int jhwd_reset_idma(struct jpeghw_decompress_struct * jhwdinfo);

/*
 * \brief resets the ODMA 
 *
 *  Using the register pointers found within the jhwcinfo structure
 *    retest the ODMA channel hardware.
 *
 *  Returns OK (0) if the encoder was successfully intialized, FAIL (-1) otherwise.
 */
int jhwc_reset_odma(struct jpeghw_compress_struct * jhwcinfo);
int jhwd_reset_odma(struct jpeghw_decompress_struct * jhwdinfo);



#endif 
