/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef  JHW_ASIC_H
#define  JHW_ASIC_H 

// map hw register names (per/asic)
#if defined(ASIC_JPEG32)

/// asic-specific headers
#include "regAddrs.h"
#include "UDMA_regstructs.h"
#include "UDMA_regmasks.h"
#include "JPEG_TOP_regstructs.h"
#include "JPEG_TOP_regmasks.h"
#include "JPEG_CORE_regstructs.h"
#include "JPEG_CORE_regmasks.h"
#include "POGO_IDMA_regstructs.h"
#include "POGO_IDMA_regmasks.h"
#include "POGO_ODMA_regstructs.h"
#include "POGO_ODMA_regmasks.h"
#include "JPEG_ODMA_regstructs.h"
#include "JPEG_ODMA_regmasks.h"
#include "JPEG_IDMA_regstructs.h"
#include "JPEG_IDMA_regmasks.h"
#include "JPEG_POGO_regstructs.h"
#include "JPEG_POGO_regmasks.h"
#include "DEPOGO_regstructs.h"
#include "DEPOGO_regmasks.h"
#include "CSC_JEDI_regstructs.h"
#include "CSC_JEDI_regmasks.h"

// set jpegdescsize_t to indicate 32-bit descriptor
typedef uint32_t jpegdescsize_t;

// JPEG_IDMA and JPEG_ODMA typedefs
typedef UDMA_REGS_t JPEG_IDMA_UDMA_REGS_t;
typedef UDMA_REGS_t JPEG_ODMA_UDMA_REGS_t;

#define INTNUM_JPEG0 206 /* 1st core */
#define INTNUM_JPEG1 207 /* 2nd core */

#define JPEG_DEVICES_AVAILABLE 2

#define JPEG_0_BASE                 IPS_JPEG_0_CORE_BASE
#define JPEG_0_TOP_BASE             IPS_JPEG_0_TOP_BASE
#define JPEG_0_POGO_IDMA_UDMA_BASE  IPS_JPEG_0_POGO_IDMA_POGO_IDMA_UDMA_BASE
#define JPEG_0_POGO_IDMA_CORE_BASE  IPS_JPEG_0_POGO_IDMA_POGO_IDMA_CORE_BASE
#define JPEG_0_JPEG_ODMA_UDMA_BASE  IPS_JPEG_0_JPEG_ODMA_UDMA_BASE
#define JPEG_0_JPEG_ODMA_CORE_BASE  IPS_JPEG_0_JPEG_ODMA_CORE_BASE

#define JPEG_0_POGO_BASE            IPS_JPEG_0_POGO_BASE
#define JPEG_0_DEPOGO_BASE          IPS_JPEG_0_DEPOGO_BASE
#define JPEG_0_CSC_BASE             IPS_JPEG_0_CSC_BASE

#define JPEG_0_JPEG_IDMA_UDMA_BASE  IPS_JPEG_0_JPEG_IDMA_UDMA_BASE
#define JPEG_0_JPEG_IDMA_CORE_BASE  IPS_JPEG_0_JPEG_IDMA_CORE_BASE
#define JPEG_0_POGO_ODMA_UDMA_BASE  IPS_JPEG_0_POGO_ODMA_POGO_ODMA_UDMA_BASE
#define JPEG_0_POGO_ODMA_CORE_BASE  IPS_JPEG_0_POGO_ODMA_POGO_ODMA_CORE_BASE

#define JPEG_1_BASE                 IPS_JPEG_1_CORE_BASE
#define JPEG_1_TOP_BASE             IPS_JPEG_1_TOP_BASE
#define JPEG_1_POGO_IDMA_UDMA_BASE  IPS_JPEG_1_POGO_IDMA_POGO_IDMA_UDMA_BASE
#define JPEG_1_POGO_IDMA_CORE_BASE  IPS_JPEG_1_POGO_IDMA_POGO_IDMA_CORE_BASE
#define JPEG_1_JPEG_ODMA_UDMA_BASE  IPS_JPEG_1_JPEG_ODMA_UDMA_BASE
#define JPEG_1_JPEG_ODMA_CORE_BASE  IPS_JPEG_1_JPEG_ODMA_CORE_BASE

#define JPEG_1_POGO_BASE            IPS_JPEG_1_POGO_BASE
#define JPEG_1_DEPOGO_BASE          IPS_JPEG_1_DEPOGO_BASE
#define JPEG_1_CSC_BASE             IPS_JPEG_1_CSC_BASE

#define JPEG_1_JPEG_IDMA_UDMA_BASE  IPS_JPEG_1_JPEG_IDMA_UDMA_BASE
#define JPEG_1_JPEG_IDMA_CORE_BASE  IPS_JPEG_1_JPEG_IDMA_CORE_BASE
#define JPEG_1_POGO_ODMA_UDMA_BASE  IPS_JPEG_1_POGO_ODMA_POGO_ODMA_UDMA_BASE
#define JPEG_1_POGO_ODMA_CORE_BASE  IPS_JPEG_1_POGO_ODMA_POGO_ODMA_CORE_BASE

#elif defined(ASIC_JPEG64)

/// asic-specific headers
#include "regAddrs.h"
#include "UDMA_regstructs.h"
#include "UDMA_regmasks.h"
#include "JPEG_TOP_regstructs.h"
#include "JPEG_TOP_regmasks.h"
#include "JPEG_CORE_regstructs.h"
#include "JPEG_CORE_regmasks.h"
#include "POGO_IDMA_regstructs.h"
#include "POGO_IDMA_regmasks.h"
#include "POGO_ODMA_regstructs.h"
#include "POGO_ODMA_regmasks.h"
#include "JPEG_ODMA_regstructs.h"
#include "JPEG_ODMA_regmasks.h"
#include "JPEG_IDMA_regstructs.h"
#include "JPEG_IDMA_regmasks.h"
#include "JPEG_POGO_regstructs.h"
#include "JPEG_POGO_regmasks.h"
#include "DEPOGO_regstructs.h"
#include "DEPOGO_regmasks.h"
#include "CSC_JEDI_regstructs.h"
#include "CSC_JEDI_regmasks.h"


// set jpegdescsize_t to indicate 64-bit descriptor
typedef uint64_t jpegdescsize_t;

#define INTNUM_JPEG0 206 /* 1st core */
#define INTNUM_JPEG1 207 /* 2nd core */

#define JPEG_DEVICES_AVAILABLE 2

#define JPEG_0_BASE                 IPS_JPEG_0_CORE_BASE
#define JPEG_0_TOP_BASE             IPS_JPEG_0_TOP_BASE
#define JPEG_0_POGO_IDMA_UDMA_BASE  IPS_JPEG_0_POGO_IDMA_POGO_IDMA_UDMA_BASE
#define JPEG_0_POGO_IDMA_CORE_BASE  IPS_JPEG_0_POGO_IDMA_POGO_IDMA_CORE_BASE
#define JPEG_0_JPEG_ODMA_UDMA_BASE  IPS_JPEG_0_JPEG_ODMA_UDMA_BASE
#define JPEG_0_JPEG_ODMA_CORE_BASE  IPS_JPEG_0_JPEG_ODMA_CORE_BASE

#define JPEG_0_POGO_BASE            IPS_JPEG_0_POGO_BASE
#define JPEG_0_DEPOGO_BASE          IPS_JPEG_0_DEPOGO_BASE
#define JPEG_0_CSC_BASE             IPS_JPEG_0_CSC_BASE

#define JPEG_0_JPEG_IDMA_UDMA_BASE  IPS_JPEG_0_JPEG_IDMA_UDMA_BASE
#define JPEG_0_JPEG_IDMA_CORE_BASE  IPS_JPEG_0_JPEG_IDMA_CORE_BASE
#define JPEG_0_POGO_ODMA_UDMA_BASE  IPS_JPEG_0_POGO_ODMA_POGO_ODMA_UDMA_BASE
#define JPEG_0_POGO_ODMA_CORE_BASE  IPS_JPEG_0_POGO_ODMA_POGO_ODMA_CORE_BASE

#define JPEG_1_BASE                 IPS_JPEG_1_CORE_BASE /* IPS_JPEG_1_BASE */
#define JPEG_1_TOP_BASE             IPS_JPEG_1_TOP_BASE
#define JPEG_1_POGO_IDMA_UDMA_BASE  IPS_JPEG_1_POGO_IDMA_POGO_IDMA_UDMA_BASE
#define JPEG_1_POGO_IDMA_CORE_BASE  IPS_JPEG_1_POGO_IDMA_POGO_IDMA_CORE_BASE
#define JPEG_1_JPEG_ODMA_UDMA_BASE  IPS_JPEG_1_JPEG_ODMA_UDMA_BASE
#define JPEG_1_JPEG_ODMA_CORE_BASE  IPS_JPEG_1_JPEG_ODMA_CORE_BASE

#define JPEG_1_POGO_BASE            IPS_JPEG_1_POGO_BASE
#define JPEG_1_DEPOGO_BASE          IPS_JPEG_1_DEPOGO_BASE
#define JPEG_1_CSC_BASE             IPS_JPEG_1_CSC_BASE

#define JPEG_1_JPEG_IDMA_UDMA_BASE  IPS_JPEG_1_JPEG_IDMA_UDMA_BASE
#define JPEG_1_JPEG_IDMA_CORE_BASE  IPS_JPEG_1_JPEG_IDMA_CORE_BASE
#define JPEG_1_POGO_ODMA_UDMA_BASE  IPS_JPEG_1_POGO_ODMA_POGO_ODMA_UDMA_BASE
#define JPEG_1_POGO_ODMA_CORE_BASE  IPS_JPEG_1_POGO_ODMA_POGO_ODMA_CORE_BASE

#else
#error Unsupported ASIC
#endif

#endif // JHW_ASIC_H 

