 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _UDMA_REGSTRUCTS_H_
#define _UDMA_REGSTRUCTS_H_


//====================================================================
//
//Register File: UDMA Registers (UDMA)
//
//====================================================================

typedef struct UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} UDMA_REGS_t;

#endif // UDMA
