 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _UDMA_REGMASKS_H_
#define _UDMA_REGMASKS_H_

//====================================================================
//
//Register File: UDMA Registers (UDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  UDMA_UCR_RESERVED1_MASK 0xfff00000
#define  UDMA_UCR_RESERVED1_SHIFT 20
#define  UDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UDMA_UCR_RESERVED1_MASK) >> UDMA_UCR_RESERVED1_SHIFT)
#define  UDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << UDMA_UCR_RESERVED1_SHIFT))

#define  UDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  UDMA_UCR_DATAAXCACHE_SHIFT 16
#define  UDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & UDMA_UCR_DATAAXCACHE_MASK) >> UDMA_UCR_DATAAXCACHE_SHIFT)
#define  UDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << UDMA_UCR_DATAAXCACHE_SHIFT))

#define  UDMA_UCR_DESCARCACHE_MASK 0xf000
#define  UDMA_UCR_DESCARCACHE_SHIFT 12
#define  UDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & UDMA_UCR_DESCARCACHE_MASK) >> UDMA_UCR_DESCARCACHE_SHIFT)
#define  UDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << UDMA_UCR_DESCARCACHE_SHIFT))

#define  UDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  UDMA_UCR_DESCAWCACHE_SHIFT 8
#define  UDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & UDMA_UCR_DESCAWCACHE_MASK) >> UDMA_UCR_DESCAWCACHE_SHIFT)
#define  UDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << UDMA_UCR_DESCAWCACHE_SHIFT))

#define  UDMA_UCR_RESERVED2_MASK 0xc0
#define  UDMA_UCR_RESERVED2_SHIFT 6
#define  UDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & UDMA_UCR_RESERVED2_MASK) >> UDMA_UCR_RESERVED2_SHIFT)
#define  UDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << UDMA_UCR_RESERVED2_SHIFT))

#define  UDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  UDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  UDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & UDMA_UCR_HANDSHAKEENABLE_MASK) >> UDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  UDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << UDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  UDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  UDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  UDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & UDMA_UCR_OWNWRITEDISABLE_MASK) >> UDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  UDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << UDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  UDMA_UCR_OWNPOLARITY_MASK 0x8
#define  UDMA_UCR_OWNPOLARITY_SHIFT 3
#define  UDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & UDMA_UCR_OWNPOLARITY_MASK) >> UDMA_UCR_OWNPOLARITY_SHIFT)
#define  UDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << UDMA_UCR_OWNPOLARITY_SHIFT))

#define  UDMA_UCR_BEATS_MASK 0x6
#define  UDMA_UCR_BEATS_SHIFT 1
#define  UDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & UDMA_UCR_BEATS_MASK) >> UDMA_UCR_BEATS_SHIFT)
#define  UDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UCR_BEATS_MASK) | (((uint32_t)val) << UDMA_UCR_BEATS_SHIFT))

#define  UDMA_UCR_ENABLE_MASK 0x1
#define  UDMA_UCR_ENABLE_SHIFT 0
#define  UDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & UDMA_UCR_ENABLE_MASK) >> UDMA_UCR_ENABLE_SHIFT)
#define  UDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << UDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  UDMA_USR_RESERVED1_MASK 0xfffff800
#define  UDMA_USR_RESERVED1_SHIFT 11
#define  UDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & UDMA_USR_RESERVED1_MASK) >> UDMA_USR_RESERVED1_SHIFT)
#define  UDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << UDMA_USR_RESERVED1_SHIFT))

#define  UDMA_USR_DMAPAUSED_MASK 0x400
#define  UDMA_USR_DMAPAUSED_SHIFT 10
#define  UDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & UDMA_USR_DMAPAUSED_MASK) >> UDMA_USR_DMAPAUSED_SHIFT)
#define  UDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << UDMA_USR_DMAPAUSED_SHIFT))

#define  UDMA_USR_PAUSEAFTER_MASK 0x200
#define  UDMA_USR_PAUSEAFTER_SHIFT 9
#define  UDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & UDMA_USR_PAUSEAFTER_MASK) >> UDMA_USR_PAUSEAFTER_SHIFT)
#define  UDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << UDMA_USR_PAUSEAFTER_SHIFT))

#define  UDMA_USR_PAUSEBEFORE_MASK 0x100
#define  UDMA_USR_PAUSEBEFORE_SHIFT 8
#define  UDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & UDMA_USR_PAUSEBEFORE_MASK) >> UDMA_USR_PAUSEBEFORE_SHIFT)
#define  UDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << UDMA_USR_PAUSEBEFORE_SHIFT))

#define  UDMA_USR_INTONFINISH_MASK 0x80
#define  UDMA_USR_INTONFINISH_SHIFT 7
#define  UDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & UDMA_USR_INTONFINISH_MASK) >> UDMA_USR_INTONFINISH_SHIFT)
#define  UDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << UDMA_USR_INTONFINISH_SHIFT))

#define  UDMA_USR_STOPONFINISH_MASK 0x40
#define  UDMA_USR_STOPONFINISH_SHIFT 6
#define  UDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & UDMA_USR_STOPONFINISH_MASK) >> UDMA_USR_STOPONFINISH_SHIFT)
#define  UDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << UDMA_USR_STOPONFINISH_SHIFT))

#define  UDMA_USR_CMDBUFFULL_MASK 0x20
#define  UDMA_USR_CMDBUFFULL_SHIFT 5
#define  UDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & UDMA_USR_CMDBUFFULL_MASK) >> UDMA_USR_CMDBUFFULL_SHIFT)
#define  UDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << UDMA_USR_CMDBUFFULL_SHIFT))

#define  UDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  UDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  UDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & UDMA_USR_CMDBUFEMPTY_MASK) >> UDMA_USR_CMDBUFEMPTY_SHIFT)
#define  UDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << UDMA_USR_CMDBUFEMPTY_SHIFT))

#define  UDMA_USR_DATABUFFULL_MASK 0x8
#define  UDMA_USR_DATABUFFULL_SHIFT 3
#define  UDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & UDMA_USR_DATABUFFULL_MASK) >> UDMA_USR_DATABUFFULL_SHIFT)
#define  UDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << UDMA_USR_DATABUFFULL_SHIFT))

#define  UDMA_USR_DATABUFEMPTY_MASK 0x4
#define  UDMA_USR_DATABUFEMPTY_SHIFT 2
#define  UDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & UDMA_USR_DATABUFEMPTY_MASK) >> UDMA_USR_DATABUFEMPTY_SHIFT)
#define  UDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << UDMA_USR_DATABUFEMPTY_SHIFT))

#define  UDMA_USR_CLEAR_MASK 0x2
#define  UDMA_USR_CLEAR_SHIFT 1
#define  UDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & UDMA_USR_CLEAR_MASK) >> UDMA_USR_CLEAR_SHIFT)
#define  UDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_CLEAR_MASK) | (((uint32_t)val) << UDMA_USR_CLEAR_SHIFT))

#define  UDMA_USR_BUSY_MASK 0x1
#define  UDMA_USR_BUSY_SHIFT 0
#define  UDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & UDMA_USR_BUSY_MASK) >> UDMA_USR_BUSY_SHIFT)
#define  UDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~UDMA_USR_BUSY_MASK) | (((uint32_t)val) << UDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  UDMA_UPR_RESERVED1_MASK 0xff000000
#define  UDMA_UPR_RESERVED1_SHIFT 24
#define  UDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & UDMA_UPR_RESERVED1_MASK) >> UDMA_UPR_RESERVED1_SHIFT)
#define  UDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << UDMA_UPR_RESERVED1_SHIFT))

#define  UDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  UDMA_UPR_FIFODEPTH_SHIFT 8
#define  UDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & UDMA_UPR_FIFODEPTH_MASK) >> UDMA_UPR_FIFODEPTH_SHIFT)
#define  UDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << UDMA_UPR_FIFODEPTH_SHIFT))

#define  UDMA_UPR_RESERVED2_MASK 0xe0
#define  UDMA_UPR_RESERVED2_SHIFT 5
#define  UDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & UDMA_UPR_RESERVED2_MASK) >> UDMA_UPR_RESERVED2_SHIFT)
#define  UDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << UDMA_UPR_RESERVED2_SHIFT))

#define  UDMA_UPR_SERPSUPPORT_MASK 0x10
#define  UDMA_UPR_SERPSUPPORT_SHIFT 4
#define  UDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & UDMA_UPR_SERPSUPPORT_MASK) >> UDMA_UPR_SERPSUPPORT_SHIFT)
#define  UDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << UDMA_UPR_SERPSUPPORT_SHIFT))

#define  UDMA_UPR_DESCLENGTH_MASK 0x8
#define  UDMA_UPR_DESCLENGTH_SHIFT 3
#define  UDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & UDMA_UPR_DESCLENGTH_MASK) >> UDMA_UPR_DESCLENGTH_SHIFT)
#define  UDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << UDMA_UPR_DESCLENGTH_SHIFT))

#define  UDMA_UPR_BUSWIDTH_MASK 0x4
#define  UDMA_UPR_BUSWIDTH_SHIFT 2
#define  UDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & UDMA_UPR_BUSWIDTH_MASK) >> UDMA_UPR_BUSWIDTH_SHIFT)
#define  UDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << UDMA_UPR_BUSWIDTH_SHIFT))

#define  UDMA_UPR_MEMALIGN_MASK 0x3
#define  UDMA_UPR_MEMALIGN_SHIFT 0
#define  UDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & UDMA_UPR_MEMALIGN_MASK) >> UDMA_UPR_MEMALIGN_SHIFT)
#define  UDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << UDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  UDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  UDMA_UIER_RESERVED1_SHIFT 6
#define  UDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & UDMA_UIER_RESERVED1_MASK) >> UDMA_UIER_RESERVED1_SHIFT)
#define  UDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << UDMA_UIER_RESERVED1_SHIFT))

#define  UDMA_UIER_OUTOFRANGE_MASK 0x20
#define  UDMA_UIER_OUTOFRANGE_SHIFT 5
#define  UDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & UDMA_UIER_OUTOFRANGE_MASK) >> UDMA_UIER_OUTOFRANGE_SHIFT)
#define  UDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << UDMA_UIER_OUTOFRANGE_SHIFT))

#define  UDMA_UIER_RRESP_MASK 0x10
#define  UDMA_UIER_RRESP_SHIFT 4
#define  UDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & UDMA_UIER_RRESP_MASK) >> UDMA_UIER_RRESP_SHIFT)
#define  UDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIER_RRESP_MASK) | (((uint32_t)val) << UDMA_UIER_RRESP_SHIFT))

#define  UDMA_UIER_BRESP_MASK 0x8
#define  UDMA_UIER_BRESP_SHIFT 3
#define  UDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & UDMA_UIER_BRESP_MASK) >> UDMA_UIER_BRESP_SHIFT)
#define  UDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIER_BRESP_MASK) | (((uint32_t)val) << UDMA_UIER_BRESP_SHIFT))

#define  UDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  UDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  UDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & UDMA_UIER_CLEARCOMPLETE_MASK) >> UDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  UDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << UDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  UDMA_UIER_DESC_MASK 0x2
#define  UDMA_UIER_DESC_SHIFT 1
#define  UDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & UDMA_UIER_DESC_MASK) >> UDMA_UIER_DESC_SHIFT)
#define  UDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIER_DESC_MASK) | (((uint32_t)val) << UDMA_UIER_DESC_SHIFT))

#define  UDMA_UIER_OWN_MASK 0x1
#define  UDMA_UIER_OWN_SHIFT 0
#define  UDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & UDMA_UIER_OWN_MASK) >> UDMA_UIER_OWN_SHIFT)
#define  UDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIER_OWN_MASK) | (((uint32_t)val) << UDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  UDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  UDMA_UIPR_RESERVED1_SHIFT 6
#define  UDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & UDMA_UIPR_RESERVED1_MASK) >> UDMA_UIPR_RESERVED1_SHIFT)
#define  UDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << UDMA_UIPR_RESERVED1_SHIFT))

#define  UDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  UDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  UDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & UDMA_UIPR_OUTOFRANGE_MASK) >> UDMA_UIPR_OUTOFRANGE_SHIFT)
#define  UDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << UDMA_UIPR_OUTOFRANGE_SHIFT))

#define  UDMA_UIPR_RRESP_MASK 0x10
#define  UDMA_UIPR_RRESP_SHIFT 4
#define  UDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & UDMA_UIPR_RRESP_MASK) >> UDMA_UIPR_RRESP_SHIFT)
#define  UDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << UDMA_UIPR_RRESP_SHIFT))

#define  UDMA_UIPR_BRESP_MASK 0x8
#define  UDMA_UIPR_BRESP_SHIFT 3
#define  UDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & UDMA_UIPR_BRESP_MASK) >> UDMA_UIPR_BRESP_SHIFT)
#define  UDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << UDMA_UIPR_BRESP_SHIFT))

#define  UDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  UDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  UDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & UDMA_UIPR_CLEARCOMPLETE_MASK) >> UDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  UDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << UDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  UDMA_UIPR_DESC_MASK 0x2
#define  UDMA_UIPR_DESC_SHIFT 1
#define  UDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & UDMA_UIPR_DESC_MASK) >> UDMA_UIPR_DESC_SHIFT)
#define  UDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIPR_DESC_MASK) | (((uint32_t)val) << UDMA_UIPR_DESC_SHIFT))

#define  UDMA_UIPR_OWN_MASK 0x1
#define  UDMA_UIPR_OWN_SHIFT 0
#define  UDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & UDMA_UIPR_OWN_MASK) >> UDMA_UIPR_OWN_SHIFT)
#define  UDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIPR_OWN_MASK) | (((uint32_t)val) << UDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  UDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  UDMA_UICR_RESERVED1_SHIFT 6
#define  UDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & UDMA_UICR_RESERVED1_MASK) >> UDMA_UICR_RESERVED1_SHIFT)
#define  UDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << UDMA_UICR_RESERVED1_SHIFT))

#define  UDMA_UICR_OUTOFRANGE_MASK 0x20
#define  UDMA_UICR_OUTOFRANGE_SHIFT 5
#define  UDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & UDMA_UICR_OUTOFRANGE_MASK) >> UDMA_UICR_OUTOFRANGE_SHIFT)
#define  UDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << UDMA_UICR_OUTOFRANGE_SHIFT))

#define  UDMA_UICR_RRESP_MASK 0x10
#define  UDMA_UICR_RRESP_SHIFT 4
#define  UDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & UDMA_UICR_RRESP_MASK) >> UDMA_UICR_RRESP_SHIFT)
#define  UDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UICR_RRESP_MASK) | (((uint32_t)val) << UDMA_UICR_RRESP_SHIFT))

#define  UDMA_UICR_BRESP_MASK 0x8
#define  UDMA_UICR_BRESP_SHIFT 3
#define  UDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & UDMA_UICR_BRESP_MASK) >> UDMA_UICR_BRESP_SHIFT)
#define  UDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UICR_BRESP_MASK) | (((uint32_t)val) << UDMA_UICR_BRESP_SHIFT))

#define  UDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  UDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  UDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & UDMA_UICR_CLEARCOMPLETE_MASK) >> UDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  UDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << UDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  UDMA_UICR_DESC_MASK 0x2
#define  UDMA_UICR_DESC_SHIFT 1
#define  UDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & UDMA_UICR_DESC_MASK) >> UDMA_UICR_DESC_SHIFT)
#define  UDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UICR_DESC_MASK) | (((uint32_t)val) << UDMA_UICR_DESC_SHIFT))

#define  UDMA_UICR_OWN_MASK 0x1
#define  UDMA_UICR_OWN_SHIFT 0
#define  UDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & UDMA_UICR_OWN_MASK) >> UDMA_UICR_OWN_SHIFT)
#define  UDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UICR_OWN_MASK) | (((uint32_t)val) << UDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  UDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  UDMA_UIFR_RESERVED1_SHIFT 6
#define  UDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & UDMA_UIFR_RESERVED1_MASK) >> UDMA_UIFR_RESERVED1_SHIFT)
#define  UDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << UDMA_UIFR_RESERVED1_SHIFT))

#define  UDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  UDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  UDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & UDMA_UIFR_OUTOFRANGE_MASK) >> UDMA_UIFR_OUTOFRANGE_SHIFT)
#define  UDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << UDMA_UIFR_OUTOFRANGE_SHIFT))

#define  UDMA_UIFR_RRESP_MASK 0x10
#define  UDMA_UIFR_RRESP_SHIFT 4
#define  UDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & UDMA_UIFR_RRESP_MASK) >> UDMA_UIFR_RRESP_SHIFT)
#define  UDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << UDMA_UIFR_RRESP_SHIFT))

#define  UDMA_UIFR_BRESP_MASK 0x8
#define  UDMA_UIFR_BRESP_SHIFT 3
#define  UDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & UDMA_UIFR_BRESP_MASK) >> UDMA_UIFR_BRESP_SHIFT)
#define  UDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << UDMA_UIFR_BRESP_SHIFT))

#define  UDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  UDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  UDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & UDMA_UIFR_CLEARCOMPLETE_MASK) >> UDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  UDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << UDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  UDMA_UIFR_DESC_MASK 0x2
#define  UDMA_UIFR_DESC_SHIFT 1
#define  UDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & UDMA_UIFR_DESC_MASK) >> UDMA_UIFR_DESC_SHIFT)
#define  UDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIFR_DESC_MASK) | (((uint32_t)val) << UDMA_UIFR_DESC_SHIFT))

#define  UDMA_UIFR_OWN_MASK 0x1
#define  UDMA_UIFR_OWN_SHIFT 0
#define  UDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & UDMA_UIFR_OWN_MASK) >> UDMA_UIFR_OWN_SHIFT)
#define  UDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UIFR_OWN_MASK) | (((uint32_t)val) << UDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  UDMA_UDR_DESC_MASK 0xffffffff
#define  UDMA_UDR_DESC_SHIFT 0
#define  UDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & UDMA_UDR_DESC_MASK) >> UDMA_UDR_DESC_SHIFT)
#define  UDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UDR_DESC_MASK) | (((uint32_t)val) << UDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  UDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  UDMA_UBAR_BURSTADDR_SHIFT 0
#define  UDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & UDMA_UBAR_BURSTADDR_MASK) >> UDMA_UBAR_BURSTADDR_SHIFT)
#define  UDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << UDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  UDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  UDMA_UBLR_RESERVED1_SHIFT 10
#define  UDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & UDMA_UBLR_RESERVED1_MASK) >> UDMA_UBLR_RESERVED1_SHIFT)
#define  UDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << UDMA_UBLR_RESERVED1_SHIFT))

#define  UDMA_UBLR_BURSTDIR_MASK 0x200
#define  UDMA_UBLR_BURSTDIR_SHIFT 9
#define  UDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & UDMA_UBLR_BURSTDIR_MASK) >> UDMA_UBLR_BURSTDIR_SHIFT)
#define  UDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << UDMA_UBLR_BURSTDIR_SHIFT))

#define  UDMA_UBLR_BURSTLAST_MASK 0x100
#define  UDMA_UBLR_BURSTLAST_SHIFT 8
#define  UDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & UDMA_UBLR_BURSTLAST_MASK) >> UDMA_UBLR_BURSTLAST_SHIFT)
#define  UDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << UDMA_UBLR_BURSTLAST_SHIFT))

#define  UDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  UDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  UDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & UDMA_UBLR_BURSTLENGTH_MASK) >> UDMA_UBLR_BURSTLENGTH_SHIFT)
#define  UDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << UDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  UDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  UDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  UDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & UDMA_UBRR_BYTESREMAIN_MASK) >> UDMA_UBRR_BYTESREMAIN_SHIFT)
#define  UDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << UDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  UDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  UDMA_UTR0_TAGMAJ_SHIFT 16
#define  UDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & UDMA_UTR0_TAGMAJ_MASK) >> UDMA_UTR0_TAGMAJ_SHIFT)
#define  UDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << UDMA_UTR0_TAGMAJ_SHIFT))

#define  UDMA_UTR0_TAGMID_MASK 0xffff
#define  UDMA_UTR0_TAGMID_SHIFT 0
#define  UDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & UDMA_UTR0_TAGMID_MASK) >> UDMA_UTR0_TAGMID_SHIFT)
#define  UDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << UDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  UDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  UDMA_UTR1_RESERVED1_SHIFT 16
#define  UDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & UDMA_UTR1_RESERVED1_MASK) >> UDMA_UTR1_RESERVED1_SHIFT)
#define  UDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << UDMA_UTR1_RESERVED1_SHIFT))

#define  UDMA_UTR1_TAGCFG_MASK 0xffff
#define  UDMA_UTR1_TAGCFG_SHIFT 0
#define  UDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & UDMA_UTR1_TAGCFG_MASK) >> UDMA_UTR1_TAGCFG_SHIFT)
#define  UDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~UDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << UDMA_UTR1_TAGCFG_SHIFT))

#endif // UDMA
