 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _JPEG_TOP_REGMASKS_H_
#define _JPEG_TOP_REGMASKS_H_

//====================================================================
//
//Register File: JPEG_TOP (JPEG_TOP)
/** \brief Register descriptions for the JPEG TOP registers.*/
//
//====================================================================

//====================================================================
//Register: Interrupt Pending Register (IRQ_PEND)
/** \brief Used to read the status of the block's interrupts.*/
//====================================================================

#define  JPEG_TOP_IRQ_PEND_RESERVED1_MASK 0xffffffe0
#define  JPEG_TOP_IRQ_PEND_RESERVED1_SHIFT 5
#define  JPEG_TOP_IRQ_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_RESERVED1_MASK) >> JPEG_TOP_IRQ_PEND_RESERVED1_SHIFT)
#define  JPEG_TOP_IRQ_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_RESERVED1_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_RESERVED1_SHIFT))

#define  JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_MASK 0x10
#define  JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_SHIFT 4
#define  JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_MASK) >> JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_SHIFT)
#define  JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_SHIFT))

#define  JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_MASK 0x8
#define  JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_SHIFT 3
#define  JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_MASK) >> JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_SHIFT)
#define  JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_SHIFT))

#define  JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_MASK 0x4
#define  JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_SHIFT 2
#define  JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_MASK) >> JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_SHIFT)
#define  JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_SHIFT))

#define  JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_MASK 0x2
#define  JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_SHIFT 1
#define  JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_MASK) >> JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_SHIFT)
#define  JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_SHIFT))

#define  JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_MASK 0x1
#define  JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_SHIFT 0
#define  JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_MASK) >> JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_SHIFT)
#define  JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_SHIFT))

//====================================================================
//Register: Configuration Register (CR)
/** \brief This register configures the operation of the JPEG_TOP blocks.*/
//====================================================================

#define  JPEG_TOP_CR_SOFT_RESET_MASK 0x80000000
#define  JPEG_TOP_CR_SOFT_RESET_SHIFT 31
#define  JPEG_TOP_CR_SOFT_RESET_MASK_SHIFT(reg) (((reg) & JPEG_TOP_CR_SOFT_RESET_MASK) >> JPEG_TOP_CR_SOFT_RESET_SHIFT)
#define  JPEG_TOP_CR_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_CR_SOFT_RESET_MASK) | (((uint32_t)val) << JPEG_TOP_CR_SOFT_RESET_SHIFT))

#define  JPEG_TOP_CR_RESERVED1_MASK 0x7fffffff
#define  JPEG_TOP_CR_RESERVED1_SHIFT 0
#define  JPEG_TOP_CR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_TOP_CR_RESERVED1_MASK) >> JPEG_TOP_CR_RESERVED1_SHIFT)
#define  JPEG_TOP_CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_CR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_TOP_CR_RESERVED1_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  JPEG_TOP_REV0_MAJ_MASK 0xffff0000
#define  JPEG_TOP_REV0_MAJ_SHIFT 16
#define  JPEG_TOP_REV0_MAJ_MASK_SHIFT(reg) (((reg) & JPEG_TOP_REV0_MAJ_MASK) >> JPEG_TOP_REV0_MAJ_SHIFT)
#define  JPEG_TOP_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_REV0_MAJ_MASK) | (((uint32_t)val) << JPEG_TOP_REV0_MAJ_SHIFT))

#define  JPEG_TOP_REV0_MID_MASK 0xffff
#define  JPEG_TOP_REV0_MID_SHIFT 0
#define  JPEG_TOP_REV0_MID_MASK_SHIFT(reg) (((reg) & JPEG_TOP_REV0_MID_MASK) >> JPEG_TOP_REV0_MID_SHIFT)
#define  JPEG_TOP_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_REV0_MID_MASK) | (((uint32_t)val) << JPEG_TOP_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  JPEG_TOP_REV1_RESERVED1_MASK 0xffff0000
#define  JPEG_TOP_REV1_RESERVED1_SHIFT 16
#define  JPEG_TOP_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_TOP_REV1_RESERVED1_MASK) >> JPEG_TOP_REV1_RESERVED1_SHIFT)
#define  JPEG_TOP_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_REV1_RESERVED1_MASK) | (((uint32_t)val) << JPEG_TOP_REV1_RESERVED1_SHIFT))

#define  JPEG_TOP_REV1_CFG_MASK 0xffff
#define  JPEG_TOP_REV1_CFG_SHIFT 0
#define  JPEG_TOP_REV1_CFG_MASK_SHIFT(reg) (((reg) & JPEG_TOP_REV1_CFG_MASK) >> JPEG_TOP_REV1_CFG_SHIFT)
#define  JPEG_TOP_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_REV1_CFG_MASK) | (((uint32_t)val) << JPEG_TOP_REV1_CFG_SHIFT))

#endif // JPEG_TOP
