 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _POGO_JPEG_REGMASKS_H_
#define _POGO_JPEG_REGMASKS_H_

//====================================================================
//
//Register File: JPEG Pogoizer (POGO_JPEG)
/** \brief (rev 0 . 6 . 1 . 0)
    These registers provide the means to program the characteristics of the desired
    pogoizing operation.*/
//
//====================================================================

//====================================================================
//Register: Pogoizer Configuration Register (Cfg)
/** \brief The fields in this register are used to configure the characteristics of the desired
      pogoizing operation.*/
//====================================================================

#define  POGO_JPEG_CFG_RESERVED1_MASK 0xffffc000
#define  POGO_JPEG_CFG_RESERVED1_SHIFT 14
#define  POGO_JPEG_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_RESERVED1_MASK) >> POGO_JPEG_CFG_RESERVED1_SHIFT)
#define  POGO_JPEG_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_RESERVED1_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_RESERVED1_SHIFT))

#define  POGO_JPEG_CFG_PIXORDER_MASK 0x2000
#define  POGO_JPEG_CFG_PIXORDER_SHIFT 13
#define  POGO_JPEG_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_PIXORDER_MASK) >> POGO_JPEG_CFG_PIXORDER_SHIFT)
#define  POGO_JPEG_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_PIXORDER_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_PIXORDER_SHIFT))

#define  POGO_JPEG_CFG_RESERVED2_MASK 0x1000
#define  POGO_JPEG_CFG_RESERVED2_SHIFT 12
#define  POGO_JPEG_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_RESERVED2_MASK) >> POGO_JPEG_CFG_RESERVED2_SHIFT)
#define  POGO_JPEG_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_RESERVED2_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_RESERVED2_SHIFT))

#define  POGO_JPEG_CFG_SCALEX_MASK 0xc00
#define  POGO_JPEG_CFG_SCALEX_SHIFT 10
#define  POGO_JPEG_CFG_SCALEX_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_SCALEX_MASK) >> POGO_JPEG_CFG_SCALEX_SHIFT)
#define  POGO_JPEG_CFG_SCALEX_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_SCALEX_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_SCALEX_SHIFT))

#define  POGO_JPEG_CFG_SCALEY_MASK 0x300
#define  POGO_JPEG_CFG_SCALEY_SHIFT 8
#define  POGO_JPEG_CFG_SCALEY_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_SCALEY_MASK) >> POGO_JPEG_CFG_SCALEY_SHIFT)
#define  POGO_JPEG_CFG_SCALEY_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_SCALEY_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_SCALEY_SHIFT))

#define  POGO_JPEG_CFG_RESERVED3_MASK 0x80
#define  POGO_JPEG_CFG_RESERVED3_SHIFT 7
#define  POGO_JPEG_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_RESERVED3_MASK) >> POGO_JPEG_CFG_RESERVED3_SHIFT)
#define  POGO_JPEG_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_RESERVED3_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_RESERVED3_SHIFT))

#define  POGO_JPEG_CFG_BPP_MASK 0x70
#define  POGO_JPEG_CFG_BPP_SHIFT 4
#define  POGO_JPEG_CFG_BPP_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_BPP_MASK) >> POGO_JPEG_CFG_BPP_SHIFT)
#define  POGO_JPEG_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_BPP_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_BPP_SHIFT))

#define  POGO_JPEG_CFG_COLORSWAP_MASK 0x8
#define  POGO_JPEG_CFG_COLORSWAP_SHIFT 3
#define  POGO_JPEG_CFG_COLORSWAP_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_COLORSWAP_MASK) >> POGO_JPEG_CFG_COLORSWAP_SHIFT)
#define  POGO_JPEG_CFG_COLORSWAP_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_COLORSWAP_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_COLORSWAP_SHIFT))

#define  POGO_JPEG_CFG_FMT_MASK 0x7
#define  POGO_JPEG_CFG_FMT_SHIFT 0
#define  POGO_JPEG_CFG_FMT_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_FMT_MASK) >> POGO_JPEG_CFG_FMT_SHIFT)
#define  POGO_JPEG_CFG_FMT_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_FMT_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_FMT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  POGO_JPEG_REV0_MAJ_MASK 0xffff0000
#define  POGO_JPEG_REV0_MAJ_SHIFT 16
#define  POGO_JPEG_REV0_MAJ_MASK_SHIFT(reg) (((reg) & POGO_JPEG_REV0_MAJ_MASK) >> POGO_JPEG_REV0_MAJ_SHIFT)
#define  POGO_JPEG_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_REV0_MAJ_MASK) | (((uint32_t)val) << POGO_JPEG_REV0_MAJ_SHIFT))

#define  POGO_JPEG_REV0_MID_MASK 0xffff
#define  POGO_JPEG_REV0_MID_SHIFT 0
#define  POGO_JPEG_REV0_MID_MASK_SHIFT(reg) (((reg) & POGO_JPEG_REV0_MID_MASK) >> POGO_JPEG_REV0_MID_SHIFT)
#define  POGO_JPEG_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_REV0_MID_MASK) | (((uint32_t)val) << POGO_JPEG_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  POGO_JPEG_REV1_RESERVED1_MASK 0xffff0000
#define  POGO_JPEG_REV1_RESERVED1_SHIFT 16
#define  POGO_JPEG_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_JPEG_REV1_RESERVED1_MASK) >> POGO_JPEG_REV1_RESERVED1_SHIFT)
#define  POGO_JPEG_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_REV1_RESERVED1_MASK) | (((uint32_t)val) << POGO_JPEG_REV1_RESERVED1_SHIFT))

#define  POGO_JPEG_REV1_CFG_MASK 0xffff
#define  POGO_JPEG_REV1_CFG_SHIFT 0
#define  POGO_JPEG_REV1_CFG_MASK_SHIFT(reg) (((reg) & POGO_JPEG_REV1_CFG_MASK) >> POGO_JPEG_REV1_CFG_SHIFT)
#define  POGO_JPEG_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_REV1_CFG_MASK) | (((uint32_t)val) << POGO_JPEG_REV1_CFG_SHIFT))

#endif // POGO_JPEG
