 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _JPEG_ODMA_CORE_REGSTRUCTS_H_
#define _JPEG_ODMA_CORE_REGSTRUCTS_H_

//====================================================================
//
//Register File: JPEG_ODMA_CORE (JPEG_ODMA_CORE)
//
//====================================================================

typedef struct JPEG_ODMA_CORE_REGS_s
{
  volatile uint32_t OTR0;  ///< 0x0 [R]: ODMA Tag Register 0
  volatile uint32_t OTR1;  ///< 0x4 [R]: ODMA Tag Register 1
  volatile uint32_t OTR2;  ///< 0x8 [R]: ODMA Tag Register 2
  volatile uint32_t OIER;  ///< 0xc [R/W]: ODMA Interrupt Enable Register
  volatile uint32_t OIPR;  ///< 0x10 [R]: ODMA Interrupt Pending Register
  volatile uint32_t OICR;  ///< 0x14 [W]: ODMA Interrupt Clear Register
  volatile uint32_t OIFR;  ///< 0x18 [W]: ODMA Interrupt Force Register
  volatile uint32_t OBLR;  ///< 0x1c [R]: ODMA Buffer Length Register
} JPEG_ODMA_CORE_REGS_t;

#endif // JPEG_ODMA_CORE
