 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _JPEG_ODMA_CORE_REGMASKS_H_
#define _JPEG_ODMA_CORE_REGMASKS_H_


//====================================================================
//
//Register File: JPEG_ODMA_CORE (JPEG_ODMA_CORE)
//
//====================================================================

//====================================================================
//Register: ODMA Tag Register 0 (OTR0)
//====================================================================

#define  JPEG_ODMA_CORE_OTR0_RESERVED1_MASK 0xffff0000
#define  JPEG_ODMA_CORE_OTR0_RESERVED1_SHIFT 16
#define  JPEG_ODMA_CORE_OTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR0_RESERVED1_MASK) >> JPEG_ODMA_CORE_OTR0_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR0_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR0_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OTR0_TAGCFG_MASK 0xffff
#define  JPEG_ODMA_CORE_OTR0_TAGCFG_SHIFT 0
#define  JPEG_ODMA_CORE_OTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR0_TAGCFG_MASK) >> JPEG_ODMA_CORE_OTR0_TAGCFG_SHIFT)
#define  JPEG_ODMA_CORE_OTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR0_TAGCFG_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR0_TAGCFG_SHIFT))

//====================================================================
//Register: ODMA Tag Register 1 (OTR1)
//====================================================================

#define  JPEG_ODMA_CORE_OTR1_RESERVED1_MASK 0xffff0000
#define  JPEG_ODMA_CORE_OTR1_RESERVED1_SHIFT 16
#define  JPEG_ODMA_CORE_OTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR1_RESERVED1_MASK) >> JPEG_ODMA_CORE_OTR1_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR1_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR1_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OTR1_TAGMAJ_MASK 0xffff
#define  JPEG_ODMA_CORE_OTR1_TAGMAJ_SHIFT 0
#define  JPEG_ODMA_CORE_OTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR1_TAGMAJ_MASK) >> JPEG_ODMA_CORE_OTR1_TAGMAJ_SHIFT)
#define  JPEG_ODMA_CORE_OTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR1_TAGMAJ_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: ODMA Tag Register 2 (OTR2)
//====================================================================

#define  JPEG_ODMA_CORE_OTR2_RESERVED1_MASK 0xffff0000
#define  JPEG_ODMA_CORE_OTR2_RESERVED1_SHIFT 16
#define  JPEG_ODMA_CORE_OTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR2_RESERVED1_MASK) >> JPEG_ODMA_CORE_OTR2_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR2_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR2_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OTR2_TAGMID_MASK 0xffff
#define  JPEG_ODMA_CORE_OTR2_TAGMID_SHIFT 0
#define  JPEG_ODMA_CORE_OTR2_TAGMID_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR2_TAGMID_MASK) >> JPEG_ODMA_CORE_OTR2_TAGMID_SHIFT)
#define  JPEG_ODMA_CORE_OTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR2_TAGMID_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR2_TAGMID_SHIFT))

//====================================================================
//Register: ODMA Interrupt Enable Register (OIER)
//====================================================================

#define  JPEG_ODMA_CORE_OIER_RESERVED1_MASK 0xfffffffe
#define  JPEG_ODMA_CORE_OIER_RESERVED1_SHIFT 1
#define  JPEG_ODMA_CORE_OIER_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIER_RESERVED1_MASK) >> JPEG_ODMA_CORE_OIER_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIER_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIER_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OIER_EOI_MASK 0x1
#define  JPEG_ODMA_CORE_OIER_EOI_SHIFT 0
#define  JPEG_ODMA_CORE_OIER_EOI_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIER_EOI_MASK) >> JPEG_ODMA_CORE_OIER_EOI_SHIFT)
#define  JPEG_ODMA_CORE_OIER_EOI_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIER_EOI_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIER_EOI_SHIFT))

//====================================================================
//Register: ODMA Interrupt Pending Register (OIPR)
//====================================================================

#define  JPEG_ODMA_CORE_OIPR_RESERVED1_MASK 0xfffffffe
#define  JPEG_ODMA_CORE_OIPR_RESERVED1_SHIFT 1
#define  JPEG_ODMA_CORE_OIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIPR_RESERVED1_MASK) >> JPEG_ODMA_CORE_OIPR_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIPR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIPR_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OIPR_EOI_MASK 0x1
#define  JPEG_ODMA_CORE_OIPR_EOI_SHIFT 0
#define  JPEG_ODMA_CORE_OIPR_EOI_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIPR_EOI_MASK) >> JPEG_ODMA_CORE_OIPR_EOI_SHIFT)
#define  JPEG_ODMA_CORE_OIPR_EOI_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIPR_EOI_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIPR_EOI_SHIFT))

//====================================================================
//Register: ODMA Interrupt Clear Register (OICR)
//====================================================================

#define  JPEG_ODMA_CORE_OICR_RESERVED1_MASK 0xfffffffe
#define  JPEG_ODMA_CORE_OICR_RESERVED1_SHIFT 1
#define  JPEG_ODMA_CORE_OICR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OICR_RESERVED1_MASK) >> JPEG_ODMA_CORE_OICR_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OICR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OICR_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OICR_EOI_MASK 0x1
#define  JPEG_ODMA_CORE_OICR_EOI_SHIFT 0
#define  JPEG_ODMA_CORE_OICR_EOI_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OICR_EOI_MASK) >> JPEG_ODMA_CORE_OICR_EOI_SHIFT)
#define  JPEG_ODMA_CORE_OICR_EOI_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OICR_EOI_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OICR_EOI_SHIFT))

//====================================================================
//Register: ODMA Interrupt Force Register (OIFR)
//====================================================================

#define  JPEG_ODMA_CORE_OIFR_RESERVED1_MASK 0xfffffffe
#define  JPEG_ODMA_CORE_OIFR_RESERVED1_SHIFT 1
#define  JPEG_ODMA_CORE_OIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIFR_RESERVED1_MASK) >> JPEG_ODMA_CORE_OIFR_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIFR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIFR_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OIFR_EOI_MASK 0x1
#define  JPEG_ODMA_CORE_OIFR_EOI_SHIFT 0
#define  JPEG_ODMA_CORE_OIFR_EOI_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIFR_EOI_MASK) >> JPEG_ODMA_CORE_OIFR_EOI_SHIFT)
#define  JPEG_ODMA_CORE_OIFR_EOI_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIFR_EOI_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIFR_EOI_SHIFT))

//====================================================================
//Register: ODMA Buffer Length Register (OBLR)
//====================================================================

#define  JPEG_ODMA_CORE_OBLR_RESERVED1_MASK 0xff000000
#define  JPEG_ODMA_CORE_OBLR_RESERVED1_SHIFT 24
#define  JPEG_ODMA_CORE_OBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OBLR_RESERVED1_MASK) >> JPEG_ODMA_CORE_OBLR_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OBLR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OBLR_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OBLR_BUFLENGTH_MASK 0xffffff
#define  JPEG_ODMA_CORE_OBLR_BUFLENGTH_SHIFT 0
#define  JPEG_ODMA_CORE_OBLR_BUFLENGTH_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OBLR_BUFLENGTH_MASK) >> JPEG_ODMA_CORE_OBLR_BUFLENGTH_SHIFT)
#define  JPEG_ODMA_CORE_OBLR_BUFLENGTH_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OBLR_BUFLENGTH_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OBLR_BUFLENGTH_SHIFT))

#endif // JPEG_ODMA_CORE
