 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _JPEG_IDMA_CORE_REGMASKS_H_
#define _JPEG_IDMA_CORE_REGMASKS_H_

//====================================================================
//
//Register File: JPEG_IDMA_CORE (JPEG_IDMA_CORE)
//
//====================================================================

//====================================================================
//Register: IDMA Tag Register 0 (ITR0)
//====================================================================

#define  JPEG_IDMA_CORE_ITR0_RESERVED1_MASK 0xffff0000
#define  JPEG_IDMA_CORE_ITR0_RESERVED1_SHIFT 16
#define  JPEG_IDMA_CORE_ITR0_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_IDMA_CORE_ITR0_RESERVED1_MASK) >> JPEG_IDMA_CORE_ITR0_RESERVED1_SHIFT)
#define  JPEG_IDMA_CORE_ITR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_IDMA_CORE_ITR0_RESERVED1_MASK) | (((uint32_t)val) << JPEG_IDMA_CORE_ITR0_RESERVED1_SHIFT))

#define  JPEG_IDMA_CORE_ITR0_TAGCFG_MASK 0xffff
#define  JPEG_IDMA_CORE_ITR0_TAGCFG_SHIFT 0
#define  JPEG_IDMA_CORE_ITR0_TAGCFG_MASK_SHIFT(reg) (((reg) & JPEG_IDMA_CORE_ITR0_TAGCFG_MASK) >> JPEG_IDMA_CORE_ITR0_TAGCFG_SHIFT)
#define  JPEG_IDMA_CORE_ITR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~JPEG_IDMA_CORE_ITR0_TAGCFG_MASK) | (((uint32_t)val) << JPEG_IDMA_CORE_ITR0_TAGCFG_SHIFT))

//====================================================================
//Register: IDMA Tag Register 1 (ITR1)
//====================================================================

#define  JPEG_IDMA_CORE_ITR1_RESERVED1_MASK 0xffff0000
#define  JPEG_IDMA_CORE_ITR1_RESERVED1_SHIFT 16
#define  JPEG_IDMA_CORE_ITR1_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_IDMA_CORE_ITR1_RESERVED1_MASK) >> JPEG_IDMA_CORE_ITR1_RESERVED1_SHIFT)
#define  JPEG_IDMA_CORE_ITR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_IDMA_CORE_ITR1_RESERVED1_MASK) | (((uint32_t)val) << JPEG_IDMA_CORE_ITR1_RESERVED1_SHIFT))

#define  JPEG_IDMA_CORE_ITR1_TAGMAJ_MASK 0xffff
#define  JPEG_IDMA_CORE_ITR1_TAGMAJ_SHIFT 0
#define  JPEG_IDMA_CORE_ITR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & JPEG_IDMA_CORE_ITR1_TAGMAJ_MASK) >> JPEG_IDMA_CORE_ITR1_TAGMAJ_SHIFT)
#define  JPEG_IDMA_CORE_ITR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~JPEG_IDMA_CORE_ITR1_TAGMAJ_MASK) | (((uint32_t)val) << JPEG_IDMA_CORE_ITR1_TAGMAJ_SHIFT))

//====================================================================
//Register: IDMA Tag Register 2 (ITR2)
//====================================================================

#define  JPEG_IDMA_CORE_ITR2_RESERVED1_MASK 0xffff0000
#define  JPEG_IDMA_CORE_ITR2_RESERVED1_SHIFT 16
#define  JPEG_IDMA_CORE_ITR2_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_IDMA_CORE_ITR2_RESERVED1_MASK) >> JPEG_IDMA_CORE_ITR2_RESERVED1_SHIFT)
#define  JPEG_IDMA_CORE_ITR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_IDMA_CORE_ITR2_RESERVED1_MASK) | (((uint32_t)val) << JPEG_IDMA_CORE_ITR2_RESERVED1_SHIFT))

#define  JPEG_IDMA_CORE_ITR2_TAGMID_MASK 0xffff
#define  JPEG_IDMA_CORE_ITR2_TAGMID_SHIFT 0
#define  JPEG_IDMA_CORE_ITR2_TAGMID_MASK_SHIFT(reg) (((reg) & JPEG_IDMA_CORE_ITR2_TAGMID_MASK) >> JPEG_IDMA_CORE_ITR2_TAGMID_SHIFT)
#define  JPEG_IDMA_CORE_ITR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~JPEG_IDMA_CORE_ITR2_TAGMID_MASK) | (((uint32_t)val) << JPEG_IDMA_CORE_ITR2_TAGMID_SHIFT))

#endif // JPEG_IDMA_CORE
