 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _CSC_JEDI_REGSTRUCTS_H_
#define _CSC_JEDI_REGSTRUCTS_H_


//====================================================================
//
//Register File: JEDI Configuration (CSC_JEDI)
/** \brief (rev 0 . 4 . 2 . 1)
    Register Descriptions for the JEDI CSC block*/
//
//====================================================================

typedef struct CSC_JEDI_REGS_s
{
  volatile uint32_t CCR;  ///< 0x0 [R/W]: CSC Configuration Register
  volatile uint32_t reserved0[3];
  volatile uint32_t REV0;  ///< 0x10 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x14 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[58];
  volatile uint32_t MCR0;  ///< 0x100 [R/W]: Multiply Coefficient Register 0 (row 0, col 0)
  volatile uint32_t MCR1;  ///< 0x104 [R/W]: Multiply Coefficient Register 1 (row 0, col 1)
  volatile uint32_t MCR2;  ///< 0x108 [R/W]: Multiply Coefficient Register 2 (row 0, col 2)
  volatile uint32_t MCR3;  ///< 0x10c [R/W]: Multiply Coefficient Register 3 (row 1, col 0)
  volatile uint32_t MCR4;  ///< 0x110 [R/W]: Multiply Coefficient Register 4 (row 1, col 1)
  volatile uint32_t MCR5;  ///< 0x114 [R/W]: Multiply Coefficient Register 5 (row 1, col 2)
  volatile uint32_t MCR6;  ///< 0x118 [R/W]: Multiply Coefficient Register 6 (row 2, col 0)
  volatile uint32_t MCR7;  ///< 0x11c [R/W]: Multiply Coefficient Register 7 (row 2, col 1)
  volatile uint32_t MCR8;  ///< 0x120 [R/W]: Multiply Coefficient Register 8 (row 2, col 2)
} CSC_JEDI_REGS_t;

#endif // CSC_JEDI
