/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#include <stdint.h>
#include <stdbool.h>

#ifndef _jpeg_strip_adaptor_header_H
#define _jpeg_strip_adaptor_header_H

/// band?
struct region_description  ///< input or output strip area region record
{
    struct BigBuffer_s *bb; ///< memory in the kernel 
    uint32_t bytes; ///< total bytes in strip
    uint32_t lines; ///< lines per strip
    bool is_last; ///< eof indicator
    int error_code; ///< if used needs pointer to error codes in foo_error.h

};

struct jpeg_page_adaptor;

struct jpeg_strip_adaptor
{
#define jpeg_strip_adaptor_BaseClassMembers				\
    /** receives strip, the input image, returns bytes generated */	\
    void (*recv_strip)( struct jpeg_page_adaptor *page,		\
			struct jpeg_strip_adaptor *from_strip, void *blob );			\
    /** send strip, the output image	*/				\
    void (*send_strip)( struct jpeg_page_adaptor *page,	/* dst */	\
			struct jpeg_strip_adaptor *to_strip, void *blob );		\
    /** attach external strip data must be subclassed */		\
    void (*adopt_bb_from_blob)(  struct jpeg_page_adaptor *page, \
    		struct jpeg_strip_adaptor *strip,	\
    		void *blob \
	);								\
    									\
    /** free/or destroy reference to strip_blob that attached */        \
    void (*free_in_strip)( struct jpeg_strip_adaptor *strip );		\
    /** variables are set/computed in attach_from_strip() */		\
    uint32_t bytes_per_pixel; /**< 3 rgb 1 gray */			\
    uint32_t width_pix_in;  /**< input unpadded pixel width of image */	\
    uint32_t lines_in; /**< input strip height */			\
    uint32_t out_strip_height; /**< output strip height <= input */	\
    uint32_t out_strip_width;  /**< output pixel width of image */	\
    bool is_end_of_page /**< maybe short, scan adf paper size is unknown */ 


    /// end BaseClassMembers
    

    jpeg_strip_adaptor_BaseClassMembers;  // put this macro in your subclass 
};

struct jpeg_strip_adaptor *construct_jpeg_strip_adaptor(struct jpeg_strip_adaptor *reuse_if_not_null);

#if 0
/// non-mcu -> mcu aligned strip height aggregation
int jpeg_min_mcu_buffer_bytes(int bytes_per_row, int bytes_per_pixel); //!< return min byte size required for given pixel/row parameters
int jpeg_cache_lines(struct BigBuffer_s* payload, int lines); //!< cache a given #of line payload
int jpeg_lines_cached(void); //!< determine how many lines are currently cached

// 
struct BigBuffer_s* jpeg_mcu_align_dma_strip(struct jpeg_line_accumulator *cache,
					     struct BigBuffer_s* input,  //< return output 
					     int lines_requested,  //< MCU height 8 or 16
					     int in_bytes_per_row, //< input width
					     int out_bytes_per_row, //< <= input width allow clipping.
					     bool eof //< is end of page pad fill flush.
    );
#endif

void jpeg_recv_strip(struct jpeg_page_adaptor *page,
                     struct jpeg_strip_adaptor *strip, void *blob);
void jpeg_send_strip(struct jpeg_page_adaptor *page,
                     struct jpeg_strip_adaptor *strip, void *blob);
#endif // _jpeg_strip_adaptor_header_H

//eof jpeg_strip_adaptor.h
