/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef JPEG_page_adaptor_H_INCLUDED
#define JPEG_page_adaptor_H_INCLUDED
#include <stdint.h>
#include <stdbool.h>
#include <stdio.h>

/// todo: move / remove this:
#define JPEG_MAX_LINES_PER_STRIP 64

/// base class defines interfaces for a page jpeg page adaptor 
/// a sub class must provide implementation for all the function pointers starting with from_.
struct jpeg_page_adaptor 
{
#define jpeg_page_adaptor_BaseClassMembers				\
    void (*adopt_from_page)( struct jpeg_page_adaptor *page, void *blob ); \
    void (*recv_page)( struct jpeg_page_adaptor *page, void *blob ); \
    void (*jpeg_send_page)( struct jpeg_page_adaptor *page, void *blob );		\
    void (*page_close)( struct jpeg_page_adaptor *page );	/* addor extra close behaviour */ \
    void (*add_strip)( struct jpeg_page_adaptor *page, uint32_t height, bool end_of_image ); \
    int (*fixup_jpg_page_length)(struct jpeg_page_adaptor* base); \
    uint32_t strip_in_cnt;	/**< counter */				\
    uint32_t strip_in_height;	/**< running height sum */		\
    uint32_t strip_out_cnt;	/**< counter */				\
    uint32_t strip_out_height;	/**< running height sum */		\
    uint32_t out_page_height;    /**< input desire with early exit reset */ 

    /// end BaseClassMembers
    

    jpeg_page_adaptor_BaseClassMembers;  ///< base class instantiated with this macro in derived class
};

/// accessors fetch / compute data 
///
/// input page width in pixels  
uint32_t jpa_from_page_pix_width( struct jpeg_page_adaptor *psa );

/// anticipated input page height in lines, 
uint32_t jpa_from_page_page_height( struct jpeg_page_adaptor *psa );

/// true if we expect the next output strip to be the last output strip for the page.
bool jpa_from_page_at_output_eoi( struct jpeg_page_adaptor *page, uint32_t output_strip_height );

/// fixup page length if required
void jpa_fixup_jpg_page( struct jpeg_page_adaptor *jpa );

/// close device cleanly on end of page in the middle of work as a cancel/abort 
void jpa_from_page_close( struct jpeg_page_adaptor *page ); 

/// get a foreign page object, attach it to the page_adaptor and start operating on it.
/// calls jpeg_send_page for you.
/// recv() 
/// { 
///    attach()
///    send()
/// }
void jpeg_recv_page( struct jpeg_page_adaptor *jpa, void *blob );


/// base class constructor 
/// typically called once 
/// close / free is the current destructor path.
struct jpeg_page_adaptor *construct_jpeg_page_adaptor( 
    struct jpeg_page_adaptor *reuse_if_not_null );

#endif // JPEG_page_adaptor_H_INCLUDED
