
/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include <stdbool.h>
#include "dma_buffer.h"
#include "dma_alloc_api.h"
#include "debug.h"


void realloc_test()
{
    #include "BigBuffer.h"
    #define BigBuffer_t struct BigBuffer_s
	int i;
	
	static BigBuffer_t *old_bb = NULL;
	static BigBuffer_t *new_bb = NULL;
	struct mlimiter_s *limiter = mlimiter_by_name("print");
	mlimiter_start(limiter);
	old_bb = BigBuffer_Malloc(limiter, 100);

	if(old_bb == NULL){
		return;
	}

	for( i = 0;i<100;i++){
		
		old_bb->data[i] = i;
	}
	for( i = 0;i<100;i++){
		printf("Before old_bb->data[%d] = %d \n",i,old_bb->data[i]);
	}
	printf("Before realloc:old_bb = 0x%x, old_bb->data = 0x%x\n",old_bb,old_bb->data);
	new_bb = BigBuffer_realloc(old_bb, 20);
	printf("After realloc:old_bb = 0x%x, old_bb->data = 0x%x\n",old_bb,old_bb->data);
	printf("After realloc:new_bb = 0x%x, new_bb->data = 0x%x\n",new_bb,new_bb->data);
	for( i = 0;i<20;i++){
		printf("after new_bb->data[%d] = %d \n",i,new_bb->data[i]);
	}
        BigBuffer_Free(new_bb);

        struct BigBuffer_s *bb = dma_buffer_malloc(0, 500);
        char *v = dma_buffer_mmap_forcpu(bb);
        for  ( i = 0; i < 256; i++ ) {
            v[i] = i;
	}
        dma_buffer_unmmap_forcpu(bb);
        bb = dma_buffer_realloc( bb, 1000 );
        v = dma_buffer_mmap_forcpu(bb);
        for  ( i = 0; i < 256; i++ ) {
            if (v[i] != i) {
                printf("realloc fail %d %d \n", v[i], i);
		break;
	    }
        }
        dma_buffer_unmmap_forcpu(bb);
        BigBuffer_Free(bb);
        
}


int main( int argc, char *argv[] )
{
    int i;
    memInitMemory( 0, 1024*1024*128 );


    realloc_test();
    // descriptor alloc
    {
	void *kv = 0;
	void *hw = 0;
    
	kv  = (void*) memMallocPhysical( &hw, 32, 8, __FILE__, __LINE__);
	printf("physical kv %p hw %d \n", kv, hw );
	if (kv) 
	    memFreePhysical( hw, kv );
    }
    // dma_buffer alloc
    {
	struct BigBuffer_s *bb = 0;
	bb = dma_buffer_malloc( 0, 1024*100 );
	printf("bb %p\n", bb);
    

	reg32_dump_named(bb->dma_alloc, sizeof(struct dma_alloc_s), "dma_alloc");

	dma_buffer_map_single( bb, DMA_TO_DEVICE );
	dma_buffer_unmap_single( bb, DMA_TO_DEVICE );
	char * ptr = (char*) dma_buffer_mmap_forcpu( bb );
	printf("ptr %p\n", ptr);
	int i;
	if (ptr) 
	{
	    for (i=0; i<1024; i++)
		ptr[i]=i;
	    hex_dump_named(ptr, 2048, "2k ptr ");
	    ptr = (char*) dma_buffer_unmmap_forcpu( bb );
	}
	
	bb = BigBuffer_Free( bb );
    }

    realloc_test();

    mapMem_destructor(); // new attempt at not having a permanently running application.
    mem_destructor(); //

    for ( i=0; i < 9000; i++)
    {
	void *kv = 0;
	void *hw = 0;
    
	kv  = (void*) memMallocPhysical( &hw, 32, 8, __FILE__, __LINE__);
	printf("physical kv %p hw %d \n", kv, hw );
	if (kv && (i & 1)) 
	    memFreePhysical( hw, kv );
    }


    mapMem_destructor(); // free all memory maps ( registers )
    mem_destructor(); // free all coherent allocations ( descriptors )
    // free all your dma_buffer allocations, not done since these can be shared between processes and processors.  
    //
    return 0;
}
